/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.cli.FederationManager;
import com.sun.identity.shared.locale.L10NMessage;
import java.text.MessageFormat;
import java.util.logging.Level;

public class AddCircleOfTrustMembers
extends AuthenticatedCommand {
    private String realm;
    private String cot;
    private String spec;
    private String entityID;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
        this.entityID = this.getStringOptionValue("entityid");
        String[] params = new String[]{this.realm, this.entityID, this.cot, this.spec};
        this.writeLog(0, Level.INFO, "ATTEMPT_ADD_COT_MEMBER", params);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            cotManager.addCircleOfTrustMember(this.realm, this.cot, this.spec, this.entityID);
            Object[] objs = new Object[]{this.spec, this.cot, this.entityID, this.realm};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("add-circle-of-trust-member-succeeded"), objs));
            this.writeLog(0, Level.INFO, "SUCCEEDED_ADD_COT_MEMBER", params);
        }
        catch (COTException e) {
            this.debugWarning("AddCircleOfTrustMembers.handleRequest", e);
            if (e instanceof L10NMessage) {
                String[] args = new String[]{this.realm, this.entityID, this.cot, this.spec, e.getL10NMessage(this.getCommandManager().getLocale())};
                this.writeLog(1, Level.INFO, "FAILED_ADD_COT_MEMBER", args);
                throw new CLIException(e.getL10NMessage(this.getCommandManager().getLocale()), 127);
            }
            String[] args = new String[]{this.realm, this.entityID, this.cot, this.spec, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_ADD_COT_MEMBER", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

