/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdCachedServices;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesFactory;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class IdRepoListener {
    private Map configMap = null;
    private static IdEventListener remoteListener = null;
    private static Debug debug = Debug.getInstance((String)"idrepoListener");
    protected static SOAPClient sclient;
    private static IdType[] defaultIdTypes;
    private static boolean cacheChecked;
    private static boolean cacheEnabled;
    private static IdServices idServices;
    public static final int OBJECT_ADDED = 1;
    public static final int OBJECT_CHANGED = 4;
    public static final int OBJECT_REMOVED = 2;
    public static final int OBJECT_RENAMED = 8;

    public void allObjectsChanged() {
        String org;
        ArrayList list;
        if (debug.messageEnabled()) {
            debug.message("IdRepoListener: allObjectsChanged Called!");
        }
        if (!cacheChecked) {
            idServices = IdServicesFactory.getDataStoreServices();
            if (idServices instanceof IdCachedServices) {
                cacheEnabled = true;
            }
            cacheChecked = true;
        }
        if (cacheEnabled) {
            ((IdCachedServices)idServices).clearCache();
        }
        if ((list = (ArrayList)AMIdentityRepository.listeners.get(org = (String)this.configMap.get("realm"))) != null) {
            int size = list.size();
            for (int j = 0; j < size; ++j) {
                IdEventListener l = (IdEventListener)list.get(j);
                l.allIdentitiesChanged();
            }
        }
        if (remoteListener != null) {
            remoteListener.allIdentitiesChanged();
        }
    }

    public void objectChanged(String name, int type, Map cMap) {
        this.objectChanged(name, null, type, cMap);
    }

    public void objectChanged(String name, IdType idType, int changeType, Map cMap) {
        if (debug.messageEnabled()) {
            debug.message("objectChanged called with IdType= name: " + name + " IdType: " + idType + " ChangeType: " + changeType + "\nConfigmap = " + cMap);
        }
        String org = (String)this.configMap.get("realm");
        ArrayList list = (ArrayList)AMIdentityRepository.listeners.get(org);
        if (!cacheChecked) {
            idServices = IdServicesFactory.getDataStoreServices();
            if (idServices instanceof IdCachedServices) {
                cacheEnabled = true;
            }
            cacheChecked = true;
        }
        if (name.length() > 0) {
            String[] changed = this.getChangedIds(name, idType, cMap);
            block10: for (int i = 0; i < changed.length; ++i) {
                if (cacheEnabled) {
                    ((IdCachedServices)idServices).dirtyCache(changed[i], changeType, false, false, Collections.EMPTY_SET);
                }
                if (list != null) {
                    int size = list.size();
                    block11: for (int j = 0; j < size; ++j) {
                        IdEventListener l = (IdEventListener)list.get(j);
                        switch (changeType) {
                            case 1: 
                            case 4: {
                                l.identityChanged(changed[i]);
                                continue block11;
                            }
                            case 2: {
                                l.identityDeleted(changed[i]);
                                continue block11;
                            }
                            case 8: {
                                l.identityRenamed(changed[i]);
                            }
                        }
                    }
                }
                if (remoteListener == null) continue;
                switch (changeType) {
                    case 1: 
                    case 4: {
                        remoteListener.identityChanged(changed[i]);
                        continue block10;
                    }
                    case 2: {
                        remoteListener.identityDeleted(changed[i]);
                        continue block10;
                    }
                    case 8: {
                        remoteListener.identityRenamed(changed[i]);
                    }
                }
            }
        }
    }

    public static void addRemoteListener(IdEventListener l) {
        remoteListener = l;
    }

    public Map getConfigMap() {
        return this.configMap;
    }

    public void setConfigMap(Map cMap) {
        this.configMap = cMap;
    }

    public void setServiceAttributes(String sName, Map attrs) throws IdRepoException {
        String realm = (String)this.configMap.get("realm");
        String pluginName = (String)this.configMap.get("plugin-name");
        if (realm == null || pluginName == null) {
            AMIdentityRepository.debug.error("IdRepoListener.setServiveAttribute: realm or plugin name is null");
            Object[] args = new Object[]{sName, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
        try {
            SSOToken token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager scm = new ServiceConfigManager(token, "sunIdentityRepositoryService", "1.0");
            ServiceConfig sc = scm.getOrganizationConfig(realm, null);
            if (sc == null) {
                return;
            }
            ServiceConfig subConfig = sc.getSubConfig(pluginName);
            if (subConfig == null) {
                return;
            }
            Map attributes = subConfig.getAttributes();
            HashSet<String> vals = (HashSet<String>)attributes.get("sun-idrepo-ldapv3-config-service-attributes");
            if (vals == null || vals == Collections.EMPTY_SET) {
                vals = new HashSet<String>();
            }
            if (sclient == null) {
                sclient = new SOAPClient("dummy");
            }
            String mapStr = sclient.encodeMap("result", attrs);
            vals = new HashSet();
            vals.add(mapStr);
            attributes.put("sun-idrepo-ldapv3-config-service-attributes", vals);
            subConfig.setAttributes(attributes);
        }
        catch (SMSException smse) {
            AMIdentityRepository.debug.error("IdRepoListener: Unable to set service attributes", (Throwable)smse);
            Object[] args = new Object[]{sName, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
        catch (SSOException ssoe) {
            AMIdentityRepository.debug.error("IdRepoListener: Unable to set service attributes", (Throwable)((Object)ssoe));
            Object[] args = new Object[]{sName, IdType.ROLE.getName()};
            throw new IdRepoException("amIdRepo", "105", args);
        }
    }

    private String[] getChangedIds(String name, IdType type, Map cMap) {
        int size = IdUtils.supportedTypes.size();
        if (cMap == null || cMap.isEmpty()) {
            String[] ct = new String[1];
            if (DN.isDN((String)name)) {
                ct[0] = name;
            } else {
                if (type == null) {
                    type = IdType.USER;
                }
                ct[0] = "id=" + name + ",ou=" + type.getName() + "," + ServiceManager.getBaseDN();
            }
            return ct;
        }
        String[] changedTypes = null;
        IdType[] types = null;
        if (type == null) {
            changedTypes = new String[size];
            if (defaultIdTypes == null) {
                Set idtypes = IdUtils.supportedTypes;
                defaultIdTypes = new IdType[idtypes.size()];
                defaultIdTypes = idtypes.toArray(defaultIdTypes);
            }
            types = defaultIdTypes;
        } else {
            changedTypes = new String[1];
            types = new IdType[]{type};
        }
        String realm = (String)cMap.get("realm");
        String Amsdk = (String)cMap.get("amsdk");
        boolean isAmsdk = Amsdk != null;
        for (int i = 0; i < types.length; ++i) {
            IdType itype = types[i];
            String n = DN.isDN((String)name) ? LDAPDN.explodeDN((String)name, (boolean)true)[0] : name;
            String id = "id=" + n + ",ou=" + itype.getName() + "," + realm;
            if (isAmsdk) {
                id = id + ",amsdkdn=" + name;
            }
            changedTypes[i] = id;
        }
        return changedTypes;
    }
}

