/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.s1is;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LogConfigReader
implements ServiceListener {
    private static Debug debug;
    private static ServiceSchema smsLogSchema;
    private static ServiceSchema smsPlatformSchema;
    private static ServiceSchema smsNamingSchema;
    private static Map logAttributes;
    private static Map platformAttributes;
    private static Map namingAttributes;
    private String localProtocol = null;
    private String localHost = null;
    private String localPort = null;
    public static String localLogServiceID;
    private static boolean isRegisteredForDSEvents;
    private LogManager manager;

    public LogConfigReader() throws IOException {
        SSOToken ssoToken;
        debug = Debug.getInstance((String)"amLog");
        this.localProtocol = SystemProperties.get("com.iplanet.am.server.protocol");
        this.localHost = SystemProperties.get("com.iplanet.am.server.host");
        this.localPort = SystemProperties.get("com.iplanet.am.server.port");
        localLogServiceID = this.localProtocol + "://" + this.localHost + ":" + this.localPort;
        try {
            ssoToken = this.getSSOToken();
        }
        catch (SSOException ssoe) {
            debug.error("LogConfigReader: Could not get proper SSOToken", (Throwable)((Object)ssoe));
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("LogConfigReader: ssoToken obtained" + ssoToken);
        }
        try {
            this.getDefaultAttributes(ssoToken);
        }
        catch (SMSException smse) {
            debug.warning("LogConfigReader: Could not get defaultAttributes", (Throwable)smse);
            return;
        }
        catch (SSOException ssoe) {
            debug.error("LogConfigReader: Could not get defaultAttributes", (Throwable)((Object)ssoe));
            return;
        }
        String configString = this.constructInputStream();
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(configString.getBytes("ISO8859-1"));
        }
        catch (UnsupportedEncodingException unse) {
            debug.error("LogConfigReader: unsupported Encoding" + unse);
        }
        this.manager = LogManagerUtil.getLogManager();
        try {
            this.manager.readConfiguration(inputStream);
        }
        catch (IOException ioe) {
            debug.error("LogConfigReader: Can not load configuration" + ioe);
            throw new IOException(ioe.toString());
        }
        this.setLocalFlag();
    }

    private String constructInputStream() {
        Iterator it;
        Set set;
        String tempBuffer;
        StringBuffer sbuffer = new StringBuffer(2000);
        String key = null;
        String value = null;
        boolean fileBackend = false;
        String basedir = null;
        String famuri = null;
        try {
            byte[] btmp;
            famuri = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
            famuri = famuri.replace('\\', '/');
            basedir = SystemProperties.get("com.iplanet.services.configpath");
            basedir = basedir.replace('\\', '/');
            if (famuri.startsWith("/")) {
                btmp = famuri.getBytes();
                famuri = new String(btmp, 1, btmp.length - 1);
            }
            if (basedir.endsWith("/")) {
                btmp = basedir.getBytes();
                basedir = new String(btmp, 0, btmp.length - 1);
            }
            if ((value = CollectionHelper.getMapAttr((Map)(logAttributes = smsLogSchema.getAttributeDefaults()), (String)(key = "iplanet-am-logging-type"))) == null || value.length() == 0) {
                debug.warning("LogConfigReader: Backend string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
                fileBackend = value.equals("File");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read Backend ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-db-driver";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Driver string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read driver ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-db-password";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Password string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read password ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-db-user";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: DB_USER string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read db user ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-allfields";
            tempBuffer = "time, Data, ";
            set = (Set)logAttributes.get(key);
            it = set.iterator();
            tempBuffer = tempBuffer + (String)it.next();
            while (it.hasNext()) {
                tempBuffer = tempBuffer + ", " + (String)it.next();
            }
            sbuffer.append(key).append("=").append(tempBuffer).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read all field  ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-logfields";
            set = (Set)logAttributes.get(key);
            if (set != null && set.size() != 0) {
                it = set.iterator();
                tempBuffer = (String)it.next();
                while (it.hasNext()) {
                    tempBuffer = tempBuffer + ", " + (String)it.next();
                }
                sbuffer.append(key).append("=").append(tempBuffer).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read log-field ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-max-file-size";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Max File Size string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read maxfilesize ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-num-hist-file";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: NUM_HIST_FILES string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read numhistfiles ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-archiver-class";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Archiver string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read filehandler ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-file-handler";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: FileHandler class string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read filehandler ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-secure-file-handler";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Secure FH string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read secure filehandler ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-jdbc-handler";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: DBHandler string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read dbhandler ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-remote-handler";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Remote Handler string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read remotehandler ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-elf-formatter";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader:ELFFormatter string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read elfformatter ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-secure-elf-formatter";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Secure ELFFormatter string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read secure formatter ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-db-formatter";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read dbformatter ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-remote-formatter";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read remoteformatter ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-authz-class";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: AUTHZ string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read authz class", (Throwable)e);
        }
        this.getLoggingDirectory(fileBackend, basedir, famuri, sbuffer);
        try {
            key = "iplanet-am-logging-security-status";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Security status string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read security status ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-secure-signing-algorithm";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key, (String)"SHA1withRSA");
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read secure log signing alogorithm ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-secure-log-helper-class-name";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key, (String)"com.sun.identity.log.secure.SecureLogHelperJSSImpl");
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read secure log helper class name ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-secure-certificate-store";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: secure logger certificate store is null");
            } else {
                if ((value = value.replace('\\', '/')).contains("%BASE_DIR%") || value.contains("%SERVER_URI%")) {
                    value = value.replaceAll("%BASE_DIR%", basedir);
                    value = value.replaceAll("%SERVER_URI%", famuri);
                }
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read secure logger certificate store ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-verify-period-in-seconds";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Verify period string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read logverify period", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-signature-period-in-seconds";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: sign period string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read sign fieldname ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-file-read-handler";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: file readhandler string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read filehandler class ", (Throwable)e);
        }
        try {
            key = "sun-am-logging-db-read-handler";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: DB readhandler string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: could not read DBreadhandler class ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-max-records";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Max records string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read max-records ", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-files-per-keystore";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: filesper keystore string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read files per keystore", (Throwable)e);
        }
        try {
            key = "iplanet-am-logging-token-class";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: token provider string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read Token Generation Class name");
        }
        try {
            key = "iplanet-am-logging-secure-timestamp-generator";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: timestamp generator string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read Token Generation Class name");
        }
        try {
            key = "iplanet-am-logging-verifier-action-class";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: verifier actionclass string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read verifier output Class name");
        }
        try {
            key = "iplanet-am-logging-filter-class-name";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: filter class name string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read filter class");
        }
        try {
            key = "iplanet-am-logging-debug-class";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.error("LogConfigReader: debug implclass string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read debug Impl Class name");
        }
        try {
            key = "iplanet-am-logging-buffer-size";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: buffer size string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read buf size");
        }
        try {
            key = "sun-am-logging-db-max-in-mem";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Max DB mem buffer size string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read max db mem buf size");
        }
        try {
            key = "iplanet-am-logging-buffer-time-in-seconds";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: buffer time string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read buf time");
        }
        try {
            key = "iplanet-am-logging-time-buffering-status";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: time buffering status string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read time buffering status ");
        }
        try {
            key = "sun-am-logging-oradbdata-fieldtype";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read ORA DB data type");
        }
        try {
            key = "sun-am-logging-mysqldbdata-fieldtype";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read MYSQL DB data type");
        }
        try {
            key = "sun-am-logging-ora-dbdate-format";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read Oracle DB date/time format");
        }
        try {
            key = "sun-am-logging-mysql-dbdate-format";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read MySQl DB date/time format");
        }
        try {
            key = "logstatus";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader:reading from SystemProperties");
                value = SystemProperties.get("com.iplanet.am.logstatus");
                if (debug.messageEnabled()) {
                    debug.message("####### SystemProperties logStatus is: " + value);
                }
                if (value == null || value.length() == 0) {
                    value = "ACTIVE";
                }
            }
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read Log Status attribute");
        }
        try {
            key = "sun-am-log-level";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key, (String)"INFO");
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader:Could not read Logging Level");
        }
        try {
            platformAttributes = smsPlatformSchema.getAttributeDefaults();
            key = "iplanet-am-platform-locale";
            value = CollectionHelper.getMapAttr((Map)platformAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: locale string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Could not read platform ", (Throwable)e);
        }
        try {
            namingAttributes = smsNamingSchema.getAttributeDefaults();
            key = "iplanet-am-naming-logging-url";
            value = CollectionHelper.getMapAttr((Map)namingAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: loggins service url string is null");
            } else {
                sbuffer.append(key).append("=").append(value).append("\r\n");
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: could not get from DS", (Throwable)e);
        }
        try {
            key = "resolveHostName";
            value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key);
            if (value == null || value.length() == 0) {
                debug.warning("LogConfigReader: Log Resolve Hostname attribute is null");
                value = SystemProperties.get("com.sun.identity.log.resolveHostName");
                if (debug.messageEnabled()) {
                    debug.message("####### SystemProperties resolveHostName is: " + value);
                }
                if (value == null || value.length() == 0) {
                    value = "false";
                }
            }
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
        catch (Exception e) {
            debug.error("LogConfigReader: could not get from DS", (Throwable)e);
        }
        return sbuffer.toString();
    }

    private void getLoggingDirectory(boolean fileBackend, String basedir, String famuri, StringBuffer sbuffer) {
        String value;
        String key = "iplanet-am-logging-location";
        String logDir = SystemProperties.get("com.sun.identity.log.dir");
        if (logDir != null && logDir.trim().length() > 0) {
            logDir = logDir.replace('\\', '/');
            logDir = logDir + "/";
            sbuffer.append(key).append("=").append(logDir).append("\r\n");
            return;
        }
        String locSubdir = null;
        if (fileBackend && (locSubdir = SystemProperties.get("com.sun.identity.log.logSubdir")) != null && locSubdir.trim().length() > 0 && !locSubdir.endsWith("/")) {
            locSubdir = locSubdir + "/";
        }
        if ((value = CollectionHelper.getMapAttr((Map)logAttributes, (String)key)) == null || value.length() == 0) {
            debug.warning("LogConfigReader: LogLocation string is null");
        } else {
            if ((value = value.replace('\\', '/')).contains("%BASE_DIR%") || value.contains("%SERVER_URI%")) {
                value = value.replaceAll("%BASE_DIR%", basedir);
                value = value.replaceAll("%SERVER_URI%", famuri);
            }
            if (fileBackend && !value.endsWith("/")) {
                value = value + "/";
            }
            if (locSubdir != null && locSubdir.trim().length() > 0) {
                value = value + locSubdir;
            }
            sbuffer.append(key).append("=").append(value).append("\r\n");
        }
    }

    private void getDefaultAttributes(SSOToken ssoToken) throws SMSException, SSOException {
        ServiceSchemaManager schemaManager = new ServiceSchemaManager("iPlanetAMLoggingService", ssoToken);
        smsLogSchema = schemaManager.getGlobalSchema();
        if (!isRegisteredForDSEvents) {
            schemaManager.addListener(this);
        }
        schemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
        if (!isRegisteredForDSEvents) {
            schemaManager.addListener(this);
        }
        smsPlatformSchema = schemaManager.getGlobalSchema();
        schemaManager = new ServiceSchemaManager("iPlanetAMNamingService", ssoToken);
        if (!isRegisteredForDSEvents) {
            schemaManager.addListener(this);
            isRegisteredForDSEvents = true;
        }
        smsNamingSchema = schemaManager.getGlobalSchema();
        logAttributes = smsLogSchema.getAttributeDefaults();
        platformAttributes = smsPlatformSchema.getAttributeDefaults();
        namingAttributes = smsNamingSchema.getAttributeDefaults();
    }

    private SSOToken getSSOToken() throws SSOException {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private void setLocalFlag() {
        if (debug.messageEnabled()) {
            debug.message("LogConfigReader: logserviceID is" + localLogServiceID);
        }
        try {
            String urlString = this.manager.getProperty("iplanet-am-naming-logging-url");
            String logHost = null;
            logHost = urlString.indexOf("%") == -1 ? urlString : localLogServiceID;
            if (localLogServiceID != null && logHost != null) {
                LogManager.isLocal = logHost.startsWith(localLogServiceID);
            }
        }
        catch (Exception e) {
            debug.error("LogConfigReader: Error setting localFlag: ", (Throwable)e);
        }
    }

    public void globalConfigChanged(String servName, String ver, String frpName, String servComp, int type) {
        debug.message("Global config change");
    }

    public void organizationConfigChanged(String servName, String ver, String orgName, String grpName, String servComp, int type) {
        debug.message("Org config change");
    }

    public void schemaChanged(String servName, String ver) {
        if (debug.messageEnabled()) {
            debug.message("LogService schemaChanged(): ver = " + ver);
        }
        try {
            this.manager.readConfiguration();
        }
        catch (Exception e) {
            debug.error("Error in readConfiguration()", (Throwable)e);
        }
    }

    static {
        smsLogSchema = null;
        smsPlatformSchema = null;
        smsNamingSchema = null;
        logAttributes = null;
        platformAttributes = null;
        namingAttributes = null;
        localLogServiceID = null;
        isRegisteredForDSEvents = false;
    }
}

