/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.UnknownPropertyNameException;
import com.sun.identity.sm.SMSException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CreateServer
extends ServerConfigBase {
    private static final String SERVER_CONFIG_XML_FILE = "serverconfigxml";

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String serverName = this.getStringOptionValue("servername");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        String serverconfigxml = CLIUtil.getFileContent(this.getCommandManager(), this.getStringOptionValue(SERVER_CONFIG_XML_FILE));
        String[] params = new String[]{serverName};
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_SERVER", params);
            if (!ServerConfiguration.isServerInstanceExist(adminSSOToken, serverName)) {
                try {
                    ServerConfiguration.createServerInstance(adminSSOToken, serverName, attributeValues, serverconfigxml);
                }
                catch (UnknownPropertyNameException ex) {
                    outputWriter.printlnMessage(ex.getMessage());
                    outputWriter.printlnMessage("");
                }
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("create-server-config-succeeded"), params));
            } else {
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("create-server-config-already-exists"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_SERVER", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (IOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_SERVER", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_CREATE_SERVER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("CreateServer.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_SERVER", args);
            throw new CLIException(e, 127);
        }
    }
}

