/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.property;

import com.iplanet.sso.SSOException;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.console.agentconfig.AgentTabManager;
import com.sun.identity.console.agentconfig.AgentsViewBean;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AgentPropertyXMLBuilder
extends PropertyXMLBuilderBase {
    private String agentType;
    private boolean bGroup;
    private boolean olderAgentType;
    private String tabName;
    private static final String DUMMY_SECTION = "blank.header";
    private static final String ATTR_NAME_PWD = "userpassword";
    private static final String ATTR_LOC_CONFIG = "com.sun.identity.agents.config.repository.location";
    private static final String GROUP_XML = "<property><label name=\"lblagentgroup\" defaultValue=\"label.agentgroup\" labelFor=\"agentgroup\" /><cc name=\"agentgroup\" tagclass=\"com.sun.web.ui.taglib.html.CCDropDownMenuTag\" /></property>";

    public AgentPropertyXMLBuilder(String agentType, boolean bGroup, boolean olderAgentType, String tab, AMModel model) throws SMSException, SSOException {
        this.model = model;
        this.agentType = agentType;
        this.bGroup = bGroup;
        this.olderAgentType = olderAgentType;
        this.tabName = tab;
        if (tab == null) {
            AgentTabManager mgr = AgentTabManager.getInstance();
            this.tabName = mgr.getDefaultTab(agentType);
        } else {
            this.tabName = tab;
        }
        this.serviceName = "AgentService";
        this.svcSchemaManager = new ServiceSchemaManager(this.serviceName, model.getUserSSOToken());
        this.getServiceResourceBundle();
        if (this.serviceBundle != null) {
            this.getAttributeSchemas(this.serviceName, olderAgentType);
        }
    }

    public String getXML(Set readonly, String choice) throws SMSException, SSOException, AMConsoleException {
        boolean bLocal;
        StringBuffer xml = new StringBuffer(1000);
        xml.append(AgentPropertyXMLBuilder.getXMLDefinitionHeader()).append("<propertysheet>\n");
        AgentTabManager tabMgr = AgentTabManager.getInstance();
        List order = tabMgr.getSectionOrder(this.agentType, this.tabName);
        boolean bl = bLocal = choice != null && choice.equals("local");
        if (bLocal || order == null || order.isEmpty()) {
            Set attrSchemas = (Set)this.mapTypeToAttributeSchema.get(DUMMY_SECTION);
            if (bLocal) {
                Iterator i = attrSchemas.iterator();
                while (i.hasNext()) {
                    AttributeSchema as = (AttributeSchema)i.next();
                    if (!as.getName().equals(AgentsViewBean.DESCRIPTION)) continue;
                    i.remove();
                }
            }
            String display = this.model.getLocalizedString(DUMMY_SECTION);
            this.buildSchemaTypeXML(display, attrSchemas, xml, this.model, this.serviceBundle, readonly);
        } else {
            for (String sectionName : order) {
                Set attributeSchema = (Set)this.mapTypeToAttributeSchema.get(sectionName);
                String display = this.model.getLocalizedString("section.label." + this.agentType + "." + this.tabName + "." + sectionName);
                this.buildSchemaTypeXML(display, attributeSchema, xml, this.model, this.serviceBundle, readonly);
            }
        }
        xml.append("</propertysheet>\n");
        if (!this.bGroup && !this.olderAgentType && tabMgr.isFirstTab(this.agentType, this.tabName)) {
            String buff = xml.toString();
            int idx = buff.indexOf("<property ");
            return buff.substring(0, idx) + GROUP_XML + buff.substring(idx);
        }
        return xml.toString();
    }

    private void getAttributeSchemas(String serviceName, boolean localized) throws SMSException, SSOException {
        this.mapTypeToAttributeSchema = new HashMap();
        Set localProperty = null;
        if (localized && !this.bGroup) {
            localProperty = AgentConfiguration.getLocalPropertyNames(this.agentType);
        }
        Set attrSchemas = AgentConfiguration.getAgentAttributeSchemas(this.agentType);
        Iterator i = attrSchemas.iterator();
        while (i.hasNext()) {
            AttributeSchema as = (AttributeSchema)i.next();
            String i18nKey = as.getI18NKey();
            if (i18nKey == null || i18nKey.trim().length() == 0) {
                i.remove();
                continue;
            }
            if (this.bGroup) {
                if (!as.getName().equals(ATTR_NAME_PWD) && !as.getName().equals(ATTR_LOC_CONFIG)) continue;
                i.remove();
                continue;
            }
            if (localProperty == null || localProperty.contains(as.getName())) continue;
            i.remove();
        }
        AgentTabManager mgr = AgentTabManager.getInstance();
        Map secToAttrNames = null;
        if (!localized) {
            Map map = secToAttrNames = this.tabName == null ? mgr.getAttributeNames(this.agentType, -1) : mgr.getAttributeNames(this.agentType, mgr.getTabId(this.agentType, this.tabName));
        }
        if (secToAttrNames == null || secToAttrNames.isEmpty()) {
            this.mapTypeToAttributeSchema.put(DUMMY_SECTION, attrSchemas);
        } else {
            for (String sectionName : secToAttrNames.keySet()) {
                Set attrNames = (Set)secToAttrNames.get(sectionName);
                Set set = this.getAttributeSchemas(attrSchemas, attrNames);
                if (set == null || set.isEmpty()) continue;
                this.mapTypeToAttributeSchema.put(sectionName, set);
            }
        }
    }

    public Set getAttributeSchemas() {
        HashSet set = new HashSet();
        for (String key : this.mapTypeToAttributeSchema.keySet()) {
            set.addAll((Set)this.mapTypeToAttributeSchema.get(key));
        }
        return set;
    }

    private Set getAttributeSchemas(Set attrSchemas, Set selectable) {
        HashSet<AttributeSchema> results = new HashSet<AttributeSchema>(selectable.size() * 2);
        if (attrSchemas != null && !attrSchemas.isEmpty()) {
            for (AttributeSchema as : attrSchemas) {
                String i18nKey;
                String name = as.getName();
                if (!selectable.contains(name) || (i18nKey = as.getI18NKey()) == null || i18nKey.trim().length() <= 0) continue;
                results.add(as);
            }
        }
        return results;
    }
}

