/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class OrganizationConfigManagerImpl
implements SMSObjectListener {
    private String orgDN;
    private CachedSubEntries subEntries;
    private CachedSMSEntry smsEntry;
    private Map listenerObjects = Collections.synchronizedMap(new HashMap());
    private String listenerId;
    private String orgNotificationSearchString;
    private static Map configMgrImpls = Collections.synchronizedMap(new HashMap());
    private static Map userPrincipals = Collections.synchronizedMap(new HashMap());
    private static Debug debug = SMSEntry.debug;

    private OrganizationConfigManagerImpl(CachedSMSEntry entry, String orgDN, SSOToken token) throws SMSException {
        this.smsEntry = entry;
        this.orgDN = orgDN;
        this.listenerId = SMSNotificationManager.getInstance().registerCallbackHandler(this);
        if (!orgDN.startsWith("ou=services")) {
            DN notifyDN = new DN("ou=services," + orgDN);
            this.orgNotificationSearchString = notifyDN.toRFCString().toLowerCase();
        } else {
            this.orgNotificationSearchString = orgDN;
        }
    }

    String getOrgDN() {
        return this.orgDN;
    }

    Set getAssignedServices(SSOToken token) throws SMSException {
        try {
            HashSet<String> answer = new HashSet<String>();
            CachedSubEntries se = null;
            se = this.orgDN.equals(DNMapper.serviceDN) ? CachedSubEntries.getInstance(token, this.orgDN) : CachedSubEntries.getInstance(token, "ou=services," + this.orgDN);
            for (String serviceName : se.getSubEntries(token)) {
                ServiceConfigManagerImpl scmi = ServiceManager.isCoexistenceMode() ? ServiceConfigManagerImpl.getInstance(token, serviceName, ServiceManager.serviceDefaultVersion(token, serviceName)) : ServiceConfigManagerImpl.getInstance(token, serviceName, ServiceManager.getVersion(serviceName));
                try {
                    ServiceConfigImpl sci = scmi.getOrganizationConfig(token, this.orgDN, null);
                    if (sci == null || sci.isNewEntry()) continue;
                    answer.add(serviceName);
                }
                catch (SMSException smse) {
                    if (smse.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) continue;
                    throw smse;
                }
            }
            return answer;
        }
        catch (SSOException ssoe) {
            debug.error("OrganizationConfigManagerImpl.getAssignedServices Unable to get assigned services", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    Set getSubOrganizationNames(SSOToken token) throws SMSException {
        return this.getSubOrganizationNames(token, "*", false);
    }

    Set getSubOrganizationNames(SSOToken token, String pattern, boolean recursive) throws SMSException {
        try {
            if (this.subEntries == null) {
                this.subEntries = CachedSubEntries.getInstance(token, this.orgDN);
            }
            return this.subEntries.searchSubOrgNames(token, pattern, recursive);
        }
        catch (SSOException ssoe) {
            debug.error("OrganizationConfigManagerImpl: Unable to get sub organization names", (Throwable)((Object)ssoe));
            throw new SMSException(SMSEntry.bundle.getString("sms-INVALID_SSO_TOKEN"), "sms-INVALID_SSO_TOKEN");
        }
    }

    synchronized String addListener(ServiceListener listener) {
        String id = SMSUtils.getUniqueID();
        this.listenerObjects.put(id, listener);
        return id;
    }

    public void removeListener(String listenerID) {
        this.listenerObjects.remove(listenerID);
        if (listenerID != null && this.listenerObjects.isEmpty()) {
            SMSNotificationManager.getInstance().removeCallbackHandler(listenerID);
        }
    }

    public void allObjectsChanged() {
    }

    public void objectChanged(String dn, int type) {
        if (this.listenerObjects.size() == 0) {
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("OrgConfigMgrImpl::entryChanged No listeners registered: " + dn + "\norgNotificationSearchString: " + this.orgNotificationSearchString);
            }
            return;
        }
        int index = 0;
        int orgIndex = 0;
        if (SMSEntry.eventDebug.messageEnabled()) {
            SMSEntry.eventDebug.message("OrgConfigMgrImpl::entryChanged  DN: " + dn + "\norgNotificationSearchString: " + this.orgNotificationSearchString);
        }
        if ((index = dn.indexOf(this.orgNotificationSearchString)) != -1) {
            orgIndex = "ou=services".length();
            String serviceName = "";
            String version = "";
            String groupName = "";
            String compName = "";
            if (index != 0) {
                int size;
                String ndn = dn.substring(0, index - 1);
                String[] rdns = LDAPDN.explodeDN((String)ndn, (boolean)false);
                int n = size = rdns == null ? 0 : rdns.length;
                if (size != 0 && rdns[size - 1].startsWith("o=")) {
                    if (SMSEntry.eventDebug.messageEnabled()) {
                        SMSEntry.eventDebug.message("OrgConfigMgrImpl::entryChanged  Notification not sent since realms names donot match. \nDN: " + dn + " And orgNotificationSearchString: " + this.orgNotificationSearchString);
                    }
                    return;
                }
                rdns = LDAPDN.explodeDN((String)ndn, (boolean)true);
                if (size > 0) {
                    serviceName = rdns[size - 1];
                }
                if (size > 1) {
                    version = rdns[size - 2];
                }
                if (size >= 4) {
                    groupName = rdns[size - 4];
                }
                if (size >= 5) {
                    StringBuffer sbr = new StringBuffer();
                    for (int i = size - 4; i >= 0; --i) {
                        sbr.append('/').append(rdns[i]);
                    }
                    compName = sbr.toString();
                } else {
                    compName = "/";
                }
            }
            switch (type) {
                case 0: {
                    type = 1;
                    break;
                }
                case 1: {
                    type = 2;
                    break;
                }
                default: {
                    type = 4;
                }
            }
            String orgName = dn.substring(index + orgIndex + 1);
            if (SMSEntry.eventDebug.messageEnabled()) {
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() serviceName " + serviceName);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() version " + version);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() orgName " + orgName);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() groupName " + groupName);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() compName " + compName);
                SMSEntry.eventDebug.message("OrganizationConfigManagerImpl:entryChanged() type " + type);
            }
            this.notifyOrgConfigChange(serviceName, version, orgName, groupName, compName, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOrgConfigChange(String serviceName, String version, String orgName, String groupName, String comp, int type) {
        Map map = this.listenerObjects;
        synchronized (map) {
            for (ServiceListener sl : this.listenerObjects.values()) {
                try {
                    sl.organizationConfigChanged(serviceName, version, orgName, groupName, comp, type);
                }
                catch (Throwable t) {
                    SMSEntry.eventDebug.error("OrganizationConfigManagerImpl:notifyOrgConfigChange Error sending notify to" + sl.getClass().getName(), t);
                }
            }
        }
    }

    void clear() {
        if (this.listenerId != null && (this.listenerObjects == null || this.listenerObjects.isEmpty())) {
            SMSNotificationManager.getInstance().removeCallbackHandler(this.listenerId);
        }
        if (this.smsEntry.isValid()) {
            this.smsEntry.clear();
        }
    }

    boolean isValid() throws SMSException {
        if (this.smsEntry.isValid() && this.smsEntry.isDirty() || ServiceManager.isCoexistenceMode()) {
            this.smsEntry.refresh();
        }
        if (this.smsEntry.isNewEntry()) {
            if (debug.messageEnabled()) {
                debug.message("OrganizationConfigManagerImpl::isValid Organization deleted: " + this.orgDN);
            }
            Object[] args = new String[]{this.orgDN};
            throw new SMSException("amSDK", "sms-REALM_NAME_NOT_FOUND", args);
        }
        if (!this.smsEntry.isValid()) {
            configMgrImpls.remove(this.orgDN);
        }
        return this.smsEntry.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static OrganizationConfigManagerImpl getInstance(SSOToken token, String orgName) throws SMSException, SSOException {
        OrganizationConfigManagerImpl answer;
        String orgDN = DNMapper.orgNameToDN(orgName);
        if (orgDN.equalsIgnoreCase(SMSEntry.baseDN)) {
            orgDN = DNMapper.serviceDN;
        }
        if (debug.messageEnabled()) {
            debug.message("OrganizationConfigMgrImpl::getInstance: called: (" + orgName + ")=" + orgDN);
        }
        if ((answer = OrganizationConfigManagerImpl.getFromCache(orgDN, token)) != null && ServiceManager.isRealmEnabled()) {
            if (ServiceManager.isCoexistenceMode()) {
                answer.smsEntry.refresh();
            }
        } else {
            Map map = configMgrImpls;
            synchronized (map) {
                answer = OrganizationConfigManagerImpl.getFromCache(orgDN, null);
                if (answer == null) {
                    CachedSMSEntry cEntry = OrganizationConfigManagerImpl.checkAndUpdatePermission(orgDN, token);
                    if (ServiceManager.isCoexistenceMode()) {
                        cEntry.update();
                    }
                    answer = new OrganizationConfigManagerImpl(cEntry, orgDN, token);
                    configMgrImpls.put(orgDN, answer);
                }
            }
        }
        answer.isValid();
        if (debug.messageEnabled()) {
            debug.message("OrganizationConfigMgrImpl::getInstance: success: " + orgDN);
        }
        return answer;
    }

    private static OrganizationConfigManagerImpl getFromCache(String cacheName, SSOToken t) throws SMSException, SSOException {
        OrganizationConfigManagerImpl answer = (OrganizationConfigManagerImpl)configMgrImpls.get(cacheName);
        if (answer != null && t != null) {
            if (!answer.isValid()) {
                configMgrImpls.remove(cacheName);
                answer = null;
            } else {
                Set principals = (Set)userPrincipals.get(cacheName);
                if (principals == null || !principals.contains(((Object)t.getTokenID()).toString())) {
                    OrganizationConfigManagerImpl.checkAndUpdatePermission(cacheName, t);
                }
            }
        }
        return answer;
    }

    private static CachedSMSEntry checkAndUpdatePermission(String cacheName, SSOToken t) throws SSOException, SMSException {
        CachedSMSEntry answer = CachedSMSEntry.getInstance(t, cacheName);
        Set<String> sudoPrincipals = (Set<String>)userPrincipals.get(cacheName);
        if (sudoPrincipals == null) {
            sudoPrincipals = Collections.synchronizedSet(new HashSet(2));
            userPrincipals.put(cacheName, sudoPrincipals);
        }
        sudoPrincipals.add(((Object)t.getTokenID()).toString());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCache() {
        Map map = configMgrImpls;
        synchronized (map) {
            for (OrganizationConfigManagerImpl ocm : configMgrImpls.values()) {
                ocm.clear();
            }
            configMgrImpls.clear();
        }
    }
}

