/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.config;

import com.sun.identity.tune.base.WebContainerConfigInfoBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class WS7ContainerConfigInfo
extends WebContainerConfigInfoBase {
    private String wsAdminDir;
    private String wsAdminCmd;
    private String wsAdminHost;
    private String wsAdminUser;
    private String wsAdminPort;
    private boolean isAdminPortSecure;
    private String wsAdminConfig;
    private String wsAdminHttpListener;
    private String adminPassFile;
    private String wsadmCommonParamsNoConfig;
    private String wsAdminCommonParams;
    private Map cfgMap;
    private String tempFile;
    private String wsAdminPass;
    private String passWordStr;

    public WS7ContainerConfigInfo(ResourceBundle confRbl, String passFilePath) throws AMTuneException {
        try {
            this.setWebContainer("WS7");
            this.adminPassFile = AMTuneUtil.TMP_DIR + "wsadminpass";
            this.tempFile = AMTuneUtil.TMP_DIR + "cmdoutput";
            this.setContainerInstanceDir(confRbl.getString("CONTAINER_INSTANCE_DIR"));
            this.setWSAdminDir(confRbl.getString("WSADMIN_DIR"));
            this.setWSAdminCmd();
            this.setWSAdminUser(confRbl.getString("WSADMIN_USER"));
            FileHandler pHdl = new FileHandler(passFilePath);
            String reqLine = pHdl.getLine("WADM_PASSWORD");
            if (reqLine == null || reqLine != null && reqLine.trim().length() < "WADM_PASSWORD".length() + 1) {
                this.mWriter.writelnLocaleMsg("pt-cannot-proceed");
                this.mWriter.writelnLocaleMsg("pt-ws-password-not-found-msg");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ws-password-not-found"));
            }
            this.setWsAdminPass(AMTuneUtil.getLastToken(reqLine, "="));
            this.passWordStr = "wadm_password=" + this.getWsAdminPass();
            this.setWSAdminHost(confRbl.getString("WSADMIN_HOST"));
            this.setWSAdminPort(confRbl.getString("WSADMIN_PORT"));
            this.setWSAdminSecure(confRbl.getString("WSADMIN_SECURE"));
            this.setWSAdminConfig(confRbl.getString("WSADMIN_CONFIG"));
            this.setWSAdminHTTPListener(confRbl.getString("WSADMIN_HTTPLISTENER"));
            this.wsadmCommonParamsNoConfig = " --user=" + this.getWSAdminUser() + " --password-file=" + this.adminPassFile + " --host=" + this.getWSAdminHost() + " --port=" + this.getWSAdminPort() + " --ssl=" + this.isAdminPortSecure;
            this.wsAdminCommonParams = this.wsadmCommonParamsNoConfig + " --config=" + this.getWSAdminConfig();
            this.validateWSConfig();
            this.validateWSHttpListener();
            this.checkWebContainer64BitEnabled();
            this.fillCfgMap();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "WS7ContainerConfigInfo", "Failed to set webserver configuration information. ");
            throw new AMTuneException(ex.getMessage());
        }
        finally {
            AMTuneUtil.deleteFile(this.tempFile);
            this.deletePasswordFile();
        }
    }

    protected void deletePasswordFile() {
        AMTuneUtil.deleteFile(this.getWSAdminPassFilePath());
    }

    private void setWsAdminPass(String wsAdminPass) throws AMTuneException {
        if (wsAdminPass == null || wsAdminPass.trim().length() <= 0) {
            this.mWriter.writelnLocaleMsg("pt-ws-password-not-found-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ws-password-null"));
        }
        this.wsAdminPass = wsAdminPass.trim();
    }

    public String getWsAdminPass() {
        return this.wsAdminPass;
    }

    public String getWSAdminPassFilePath() {
        return this.adminPassFile;
    }

    private void setWSAdminDir(String wsAdminDir) throws AMTuneException {
        File wsDir = new File(wsAdminDir);
        if (wsAdminDir == null || !wsDir.isDirectory()) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("WSADMIN_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-wadm-tool-dir"));
        }
        this.wsAdminDir = wsAdminDir.trim();
    }

    public String getWSAdminDir() {
        return this.wsAdminDir;
    }

    private void setWSAdminCmd() throws AMTuneException {
        this.wsAdminCmd = AMTuneUtil.isWindows() ? this.wsAdminDir + "/" + "wadm.bat " : this.wsAdminDir + "/" + "wadm ";
        File cmdFile = new File(this.wsAdminCmd.trim());
        if (cmdFile != null && !cmdFile.isFile()) {
            this.mWriter.write(this.wsAdminCmd);
            this.mWriter.writeLocaleMsg("pt-tool-not-found");
            this.mWriter.writeLocaleMsg("pt-cannot-proceed");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-tool-not-found"));
        }
    }

    public String getWSAdminCmd() {
        return this.wsAdminCmd;
    }

    private void setWSAdminHost(String wsAdminHost) throws AMTuneException {
        if (wsAdminHost == null || wsAdminHost.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("WSADMIN_HOST");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ws-host-name"));
        }
        this.wsAdminHost = wsAdminHost.trim();
    }

    public String getWSAdminHost() {
        return this.wsAdminHost;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setWSAdminSecure(String wsAdminSecure) throws AMTuneException {
        if (wsAdminSecure != null && wsAdminSecure.trim().length() > 0) {
            if (wsAdminSecure.equals("--ssl=true")) {
                this.isAdminPortSecure = true;
                return;
            }
            if (wsAdminSecure.equals("--ssl=false")) {
                this.isAdminPortSecure = false;
                return;
            }
            AMTuneUtil.printErrorMsg("WSADMIN_SECURE");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ws-secure-prop"));
        }
        this.mWriter.writeLocaleMsg("pt-not-configured");
        AMTuneUtil.printErrorMsg("WSADMIN_SECURE");
        throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ws-admin-secure"));
    }

    public boolean isAdminPortSecure() {
        return this.isAdminPortSecure;
    }

    private void setWSAdminConfig(String wsAdminConfig) throws AMTuneException {
        if (wsAdminConfig == null || wsAdminConfig.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("WSADMIN_CONFIG");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ws-config-name"));
        }
        this.wsAdminConfig = wsAdminConfig.trim();
    }

    public String getWSAdminConfig() {
        return this.wsAdminConfig;
    }

    private void setWSAdminHTTPListener(String wsAdminHTTPListener) throws AMTuneException {
        if (wsAdminHTTPListener == null || wsAdminHTTPListener.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("WSADMIN_HTTPLISTENER");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ws-http-listener"));
        }
        this.wsAdminHttpListener = wsAdminHTTPListener.trim();
    }

    public String getWSAdminHttpListener() {
        return this.wsAdminHttpListener;
    }

    private void validateWSConfig() throws AMTuneException {
        String resultCmd = this.getWSAdminCmd() + "list-configs" + this.wsadmCommonParamsNoConfig;
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(resultCmd, this.passWordStr, this.adminPassFile, resultBuffer);
        if (resultBuffer.indexOf("Unable to connect to admin-server") != -1) {
            this.mWriter.writelnLocaleMsg("pt-web-not-running-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-unable-to-connect-to-asadmin-srv"));
        }
        if (resultBuffer.toString().indexOf("Invalid user or password") != -1) {
            this.mWriter.writelnLocaleMsg("pt-error-ws-check-user-password-msg");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ws-invalid-user-password"));
        }
        if (resultBuffer.toString().indexOf("Unknown host :") != -1) {
            AMTuneUtil.printErrorMsg("WSADMIN_HOST");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-unknow-host"));
        }
        if (resultBuffer.toString().indexOf("Invalid value for ssl") != -1) {
            AMTuneUtil.printErrorMsg("WSADMIN_SECURE");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ws-ssl"));
        }
        if (resultBuffer.toString().indexOf("The server requires an SSL connection") != -1) {
            this.mWriter.writelnLocaleMsg("pt-error-ws-port-ssl-msg");
            AMTuneUtil.printErrorMsg("WSADMIN_SECURE");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ws-ssl"));
        }
        boolean valid = false;
        if (retVal == 0) {
            StringTokenizer str = new StringTokenizer(resultBuffer.toString(), "\n");
            while (str.hasMoreTokens()) {
                String token = str.nextToken();
                if (token.indexOf(this.getWSAdminConfig()) == -1) continue;
                StringTokenizer str2 = new StringTokenizer(token, " ");
                while (str2.hasMoreTokens()) {
                    if (!str2.nextToken().trim().equalsIgnoreCase(this.getWSAdminConfig())) continue;
                    valid = true;
                }
            }
            if (!valid) {
                this.mWriter.writeLocaleMsg("pt-web-cur-wadm-settings");
                this.mWriter.writeln(this.getWSAdminConfig());
                this.mWriter.writeLocaleMsg("pt-web-cur-configs");
                this.mWriter.writeln(resultBuffer.toString());
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("WSADMIN_CONFIG");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ws-config-name"));
            }
        } else {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-web-wadm-conf-error"));
        }
        this.pLogger.log(Level.INFO, "validateWSConfig", "Validated WS config " + resultBuffer.toString());
    }

    private void validateWSHttpListener() throws AMTuneException {
        String resultCmd = this.getWSAdminCmd() + "list-http-listeners" + this.wsAdminCommonParams;
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(resultCmd, this.passWordStr, this.adminPassFile, resultBuffer);
        boolean valid = false;
        if (retVal == 0) {
            StringTokenizer str = new StringTokenizer(resultBuffer.toString(), "\n");
            while (str.hasMoreTokens()) {
                String token = str.nextToken();
                if (token.indexOf(this.getWSAdminHttpListener()) == -1) continue;
                StringTokenizer str2 = new StringTokenizer(token, " ");
                while (str2.hasMoreTokens()) {
                    if (!str2.nextToken().trim().equalsIgnoreCase(this.getWSAdminHttpListener())) continue;
                    valid = true;
                }
            }
            if (!valid) {
                this.mWriter.writeLocaleMsg("pt-web-cur-http-listener-msg");
                this.mWriter.writeln(this.getWSAdminHttpListener());
                this.mWriter.writeLocaleMsg("pt-web-cur-listeners");
                this.mWriter.writeln(resultBuffer.toString());
                this.mWriter.writeLocaleMsg("pt-conf-parm-cust-msg");
                this.mWriter.writeln("WSADMIN_HTTPLISTENER");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-ws-http-listener"));
            }
        } else {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-web-wadm-httplistener-error"));
        }
        this.pLogger.log(Level.INFO, "validateWSHttpListener", "Validated WS httplistener " + this.getWSAdminHttpListener());
    }

    private void checkWebContainer64BitEnabled() throws AMTuneException {
        this.mWriter.writelnLocaleMsg("pt-web-check-jvmbits");
        String jvmcmd = this.getWSAdminCmd() + "get-config-prop" + this.wsAdminCommonParams + " platform";
        StringBuffer resultBuffer = new StringBuffer();
        int retVal = AMTuneUtil.executeCommand(jvmcmd, this.passWordStr, this.adminPassFile, resultBuffer);
        if (retVal == 0) {
            if (resultBuffer.toString().indexOf("64") == -1) {
                this.setJVM64BitEnabled(false);
            } else {
                this.setJVM64BitEnabled(true);
            }
        } else {
            this.pLogger.log(Level.SEVERE, "checkWebContainer64BitEnabled", "Error checking jvm bits so using 32 bit. ");
            this.setJVM64BitEnabled(false);
        }
    }

    private void fillCfgMap() throws AMTuneException {
        try {
            this.pLogger.log(Level.INFO, "filCfgMap", "Getting server configuration information.");
            String propCmd = this.getWSAdminCmd() + "get-thread-pool-prop" + this.wsAdminCommonParams;
            String httpPropCmd = this.getWSAdminCmd() + "get-http-listener-prop" + this.wsAdminCommonParams + " --http-listener=" + this.getWSAdminHttpListener();
            String statsPropCmd = this.getWSAdminCmd() + "get-stats-prop" + this.wsAdminCommonParams;
            String listJvmOptions = this.getWSAdminCmd() + "list-jvm-options" + this.wsAdminCommonParams;
            StringBuffer resultBuffer = new StringBuffer();
            String reqLine = "";
            this.cfgMap = new HashMap();
            int retVal = AMTuneUtil.executeCommand(propCmd, this.passWordStr, this.adminPassFile, resultBuffer);
            if (retVal != 0) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting get-thread-pool-prop configuration information. ");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-getting-thread-pool-prop"));
            }
            AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
            FileHandler cfgF = new FileHandler(this.tempFile);
            reqLine = cfgF.getLine("min-threads");
            this.cfgMap.put("min-threads", AMTuneUtil.getLastToken(reqLine, "="));
            reqLine = cfgF.getLine("max-threads");
            this.cfgMap.put("max-threads", AMTuneUtil.getLastToken(reqLine, "="));
            reqLine = cfgF.getLine("queue-size");
            this.cfgMap.put("queue-size", AMTuneUtil.getLastToken(reqLine, "="));
            reqLine = cfgF.getLine("stack-size");
            this.cfgMap.put("stack-size", AMTuneUtil.getLastToken(reqLine, "="));
            cfgF.close();
            resultBuffer.setLength(0);
            retVal = AMTuneUtil.executeCommand(httpPropCmd, this.passWordStr, this.adminPassFile, resultBuffer);
            if (retVal != 0) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting get-http-listener-prop configuration information. ");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-getting-http-list-prop"));
            }
            AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
            cfgF = new FileHandler(this.tempFile);
            reqLine = cfgF.getLine("acceptor-threads");
            this.cfgMap.put("acceptor-threads", AMTuneUtil.getLastToken(reqLine, "="));
            cfgF.close();
            resultBuffer.setLength(0);
            retVal = AMTuneUtil.executeCommand(statsPropCmd, this.passWordStr, this.adminPassFile, resultBuffer);
            if (retVal != 0) {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting get-stats-prop configuration information. ");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-getting-stats-prop"));
            }
            AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
            cfgF = new FileHandler(this.tempFile);
            reqLine = cfgF.getLine("enabled");
            this.cfgMap.put("enabled", AMTuneUtil.getLastToken(reqLine, "="));
            cfgF.close();
            resultBuffer.setLength(0);
            retVal = AMTuneUtil.executeCommand(listJvmOptions, this.passWordStr, this.adminPassFile, resultBuffer);
            if (retVal == 0) {
                AMTuneUtil.writeResultBufferToTempFile(resultBuffer, this.tempFile);
                cfgF = new FileHandler(this.tempFile);
                reqLine = cfgF.getLine("-Xms");
                StringTokenizer st = new StringTokenizer(reqLine, " ");
                st.hasMoreElements();
                this.cfgMap.put("-Xms", st.nextToken());
                st.hasMoreTokens();
                this.cfgMap.put("-Xmx", st.nextToken());
                reqLine = this.checkJVMOpt(cfgF.getLine("-Xloggc"));
                this.cfgMap.put("-Xloggc", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-server"));
                this.cfgMap.put("-server", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-Xss"));
                this.cfgMap.put("-Xss", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:NewSize"));
                this.cfgMap.put("-XX:NewSize", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:MaxNewSize"));
                this.cfgMap.put("-XX:MaxNewSize", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:+DisableExplicitGC".replace("-XX:+", "")));
                this.cfgMap.put("-XX:+DisableExplicitGC", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:+UseParNewGC".replace("-XX:+", "")));
                this.cfgMap.put("-XX:+UseParNewGC", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:+PrintClassHistogram".replace("-XX:+", "")));
                this.cfgMap.put("-XX:+PrintClassHistogram", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:+PrintGCTimeStamps".replace("-XX:+", "")));
                this.cfgMap.put("-XX:+PrintGCTimeStamps", reqLine);
                reqLine = this.checkJVMOpt(cfgF.getLine("-XX:+UseConcMarkSweepGC".replace("-XX:+", "")));
                this.cfgMap.put("-XX:+UseConcMarkSweepGC", reqLine);
                if (AMTuneUtil.isNiagara()) {
                    reqLine = this.checkJVMOpt(cfgF.getLine("-XX:ParallelGCThreads"));
                    this.cfgMap.put("-XX:ParallelGCThreads", AMTuneUtil.getLastToken(reqLine, "="));
                }
            } else {
                this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting list-jvm-options configuration information. ");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-getting-jvm-options"));
            }
            cfgF.close();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "fillCfgMap", "Error getting server config information.");
            throw new AMTuneException(ex.getMessage());
        }
    }

    public String getWSAdmCommonParamsNoConfig() {
        return this.wsadmCommonParamsNoConfig;
    }

    public String getWSAdminCommonParams() {
        return this.wsAdminCommonParams;
    }

    public Map getServerCfgMap() {
        return this.cfgMap;
    }

    private void setWSAdminPort(String wsAdminPort) throws AMTuneException {
        if (wsAdminPort != null && wsAdminPort.trim().length() > 0) {
            try {
                Integer.parseInt(wsAdminPort.trim());
            }
            catch (NumberFormatException ne) {
                AMTuneUtil.printErrorMsg("WSADMIN_PORT");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-invalid-port-no"));
            }
        } else {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("WSADMIN_PORT");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ws-admin-port"));
        }
        this.wsAdminPort = wsAdminPort.trim();
    }

    public String getWSAdminPort() {
        return this.wsAdminPort;
    }

    private void setWSAdminUser(String wsAdminUser) throws AMTuneException {
        if (wsAdminUser == null || wsAdminUser.trim().length() <= 0) {
            this.mWriter.writeLocaleMsg("pt-not-configured");
            AMTuneUtil.printErrorMsg("WSADMIN_USER");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-null-ws-admin-user"));
        }
        this.wsAdminUser = wsAdminUser.trim();
    }

    public String getWSAdminUser() {
        return this.wsAdminUser;
    }

    private String checkJVMOpt(String val) {
        if (val == null || val != null && val.trim().length() <= 0) {
            return "<No value set>";
        }
        return val.trim();
    }
}

