/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private AuthSubject subject;
    private CallbackHandler cbHandler;
    private String organization;
    private LoginModule module;
    private HashMap sharedState = new HashMap();
    public static final String LDAP_AUTH_URL = "ldap://";
    public static final String LDAPS_AUTH_URL = "ldaps://";
    public static final String ORGNAME = "ORGANIZATION";
    public static final String PASSWORD = "PASSWORD";
    public static final String AUTH_MODULES = "admin.auth.classname";
    public static final String DONOT_INCLUDE_SMS_MODULE = "admin.auth.donotIncludeSMSModule";
    private static final String LDAP_LOGIN_MODULE = "com.sun.identity.authentication.internal.server.LocalLdapAuthModule";
    private static final String SMS_LOGIN_MODULE = "com.sun.identity.authentication.internal.server.SMSAuthModule";

    protected LoginContext(String name, CallbackHandler handler) throws LoginException {
        this.organization = name;
        this.subject = new AuthSubject();
        this.cbHandler = handler;
    }

    protected LoginContext(String name, AuthSubject subject, CallbackHandler handler) throws LoginException {
        this.organization = name;
        this.subject = subject;
        this.cbHandler = handler;
    }

    protected AuthSubject getSubject() {
        return this.subject;
    }

    protected void login() throws LoginException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.organization != null) {
            map.put(ORGNAME, this.organization);
        }
        this.module = null;
        LoginModule[] modules = null;
        try {
            modules = this.getLoginModules();
        }
        catch (Exception e) {
            if (AuthContext.authDebug.warningEnabled()) {
                AuthContext.authDebug.warning("LoginContext::login() Got exception while getting auth module", (Throwable)e);
                AuthContext.authDebug.warning("LoginContext::login() Using default auth modules");
            }
            try {
                modules = this.getDefaultLoginModules();
            }
            catch (Exception ee) {
                throw new LoginException(e.getMessage() + "\n" + ee.getMessage());
            }
        }
        LoginException loginException = null;
        boolean success = false;
        for (int i = 0; i < modules.length; ++i) {
            this.module = modules[i];
            this.module.initialize(this.subject, this.cbHandler, this.sharedState, map);
            success = false;
            try {
                success = this.module.login();
            }
            catch (LoginException le) {
                loginException = le;
            }
            if (success) {
                this.module.commit();
                break;
            }
            this.module.abort();
        }
        if (!success && loginException != null) {
            throw loginException;
        }
    }

    void updateSharedState(Callback[] callbacks) {
        for (int i = 0; callbacks != null && i < callbacks.length; ++i) {
            char[] passwd;
            if (callbacks[i] instanceof NameCallback) {
                String username = ((NameCallback)callbacks[i]).getName();
                if (username == null) continue;
                this.sharedState.put("javax.security.auth.login.name", username);
                continue;
            }
            if (!(callbacks[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)callbacks[i]).getPassword()) == null) continue;
            this.sharedState.put("javax.security.auth.login.password", new String(passwd));
        }
    }

    void updateSharedState(String username, char[] passwd) {
        this.sharedState.put("javax.security.auth.login.name", username);
        this.sharedState.put("javax.security.auth.login.password", new String(passwd));
    }

    protected LoginModule[] getLoginModules() throws Exception {
        LoginModule[] answer = null;
        String modules = SystemProperties.get(AUTH_MODULES);
        if (modules == null) {
            answer = this.getDefaultLoginModules();
            if (AuthContext.authDebug.messageEnabled()) {
                AuthContext.authDebug.message("LoginContext:getLoginModules() Using default modules");
            }
        } else {
            StringTokenizer st = new StringTokenizer(modules, "|");
            String donotIncludeSMSModule = SystemProperties.get(DONOT_INCLUDE_SMS_MODULE);
            if (donotIncludeSMSModule != null && donotIncludeSMSModule.equalsIgnoreCase("true")) {
                answer = new LoginModule[st.countTokens()];
            } else {
                answer = new LoginModule[st.countTokens() + 1];
                answer[answer.length - 1] = (LoginModule)Class.forName(SMS_LOGIN_MODULE).newInstance();
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                String moduleClass = st.nextToken();
                answer[i] = (LoginModule)Class.forName(moduleClass).newInstance();
                if (AuthContext.authDebug.messageEnabled()) {
                    AuthContext.authDebug.message("LoginContext:getLoginModules() Adding module: " + moduleClass);
                }
                ++i;
            }
        }
        return answer;
    }

    protected LoginModule[] getDefaultLoginModules() throws Exception {
        LoginModule[] answer = new LoginModule[]{(LoginModule)Class.forName(SMS_LOGIN_MODULE).newInstance(), (LoginModule)Class.forName(LDAP_LOGIN_MODULE).newInstance()};
        return answer;
    }

    protected void logout() throws LoginException {
        this.module.logout();
    }
}

