/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.common.ShutdownPriority;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProviderBase;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import java.io.IOException;
import java.security.AccessController;
import java.util.Enumeration;

public class LogManagerUtil {
    private static LogManager lmgr;
    private static boolean isAMLog;
    static String oldcclass;
    static String newcclass;
    static String oldcfile;
    static String newcfile;

    public static LogManager getLogManager() {
        return lmgr;
    }

    public static boolean isAMLoggingMode() {
        return isAMLog;
    }

    public static void setupEnv() {
        if (lmgr != null) {
            oldcclass = SystemProperties.get("java.util.logging.config.class");
            newcclass = SystemProperties.get("s1is.java.util.logging.config.class");
            oldcfile = SystemProperties.get("java.util.logging.config.file");
            newcfile = SystemProperties.get("s1is.java.util.logging.config.file");
            try {
                if (newcclass != null) {
                    System.setProperty("java.util.logging.config.class", newcclass);
                }
                if (newcfile != null) {
                    System.setProperty("java.util.logging.config.file", newcfile);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void resetEnv() {
        if (lmgr != null) {
            if (oldcclass != null) {
                System.setProperty("java.util.logging.config.class", oldcclass);
            }
            if (oldcfile != null) {
                System.setProperty("java.util.logging.config.file", oldcfile);
            }
        }
    }

    protected static SSOToken getLoggingSSOToken() {
        SSOToken st = null;
        try {
            st = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return st;
    }

    public static void logEndRecords() {
        if (lmgr != null) {
            try {
                SSOToken ssot = LogManagerUtil.getLoggingSSOToken();
                LogMessageProviderBase provider = (LogMessageProviderBase)MessageProviderFactory.getProvider("Logging");
                String[] s = new String[1];
                Enumeration<String> e = lmgr.getLoggerNames();
                LogRecord lr = null;
                while (e.hasMoreElements()) {
                    String logger = e.nextElement();
                    if (logger.length() == 0 || logger.equals("global")) continue;
                    Logger result = (Logger)Logger.getLogger(logger);
                    s[0] = logger;
                    lr = provider.createLogRecord("LOG_END", s, ssot);
                    result.log(lr, ssot);
                    result.flush();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ShutdownManager shutdownMan;
        lmgr = null;
        String compatMode = SystemProperties.get("LOG_COMPATMODE", "Off");
        isAMLog = compatMode.trim().equalsIgnoreCase("Off") || SystemProperties.isServerMode();
        lmgr = new LogManager();
        if (SystemProperties.isServerMode() && (shutdownMan = ShutdownManager.getInstance()).acquireValidLock()) {
            try {
                shutdownMan.addShutdownListener(new ShutdownListener(){

                    public void shutdown() {
                        LogManagerUtil.logEndRecords();
                    }
                }, ShutdownPriority.LOWEST);
            }
            finally {
                shutdownMan.releaseLockAndNotify();
            }
        }
        oldcclass = null;
        newcclass = null;
        oldcfile = null;
        newcfile = null;
    }
}

