/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class GetServiceAttributes
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        String serviceName = this.getStringOptionValue("servicename");
        IdType idType = this.convert2IdType(type);
        String[] params = new String[]{realm, type, idName, serviceName};
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set set = amir.getAllowedIdOperations(idType);
            if (!set.contains(IdOperation.SERVICE)) {
                throw new CLIException(MessageFormat.format(this.getResourceString("realm-does-not-support-service"), params), 127);
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_GET_SERVICE_ATTRIBUTES", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            Map values = amid.getServiceAttributes(serviceName);
            if (values != null && !values.isEmpty()) {
                String msg = this.getResourceString("idrepo-service-attribute-result");
                String[] arg = new String[]{"", ""};
                for (String attrName : values.keySet()) {
                    Set attrValues = (Set)values.get(attrName);
                    arg[0] = attrName;
                    arg[1] = this.tokenize(attrValues);
                    outputWriter.printlnMessage(MessageFormat.format(msg, arg));
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("idrepo-no-service-attributes"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_GET_SERVICE_ATTRIBUTES", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, serviceName, e.getMessage()};
            this.debugError("GetServiceAttributes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_SERVICE_ATTRIBUTES", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, serviceName, e.getMessage()};
            this.debugError("GetServiceAttributes.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_GET_SERVICE_ATTRIBUTES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

