/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.IterEnumeration;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;

public class AttrSet
implements Serializable,
Cloneable {
    private ArrayList _attrs = new ArrayList();
    public static final AttrSet EMPTY_ATTR_SET = new AttrSet();

    public AttrSet() {
    }

    public AttrSet(Attr[] attrs) {
        int size = attrs.length;
        this._attrs = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this._attrs.add(attrs[i]);
        }
    }

    public AttrSet(Attr attr) {
        this.add(attr);
    }

    public AttrSet(LDAPAttributeSet ldapAttrSet) {
        int size = ldapAttrSet.size();
        this._attrs = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this._attrs.add(new Attr(ldapAttrSet.elementAt(i)));
        }
    }

    public void add(Attr attr) {
        if (attr == null) {
            return;
        }
        Attr attr1 = this.findAttribute(attr.getName());
        if (attr1 == null) {
            this._attrs.add(attr);
        } else {
            attr1.addValues(attr.getStringValues());
        }
    }

    public void addBinaryAttr(Attr attr) {
        Attr attr1 = this.findAttribute(attr.getName());
        if (attr1 == null) {
            this._attrs.add(attr);
        } else {
            attr1.addValues(attr.getByteValues());
        }
    }

    public void remove(String name) {
        int index = this.indexOf(name);
        if (index != -1) {
            this._attrs.remove(index);
        }
    }

    public void remove(String attrName, String delValue) {
        int index = this.indexOf(attrName);
        if (index != -1) {
            Attr attr = (Attr)this._attrs.get(index);
            attr.removeValue(delValue);
            if (attr.size() == 0) {
                this._attrs.remove(index);
            }
        }
    }

    public void replace(Attr attr) {
        int index = this.indexOf(attr.getName());
        if (index != -1) {
            this._attrs.set(index, attr);
        } else {
            this._attrs.add(attr);
        }
    }

    public String[] getAttributeNames() {
        int size = this.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = ((Attr)this._attrs.get(i)).getName();
        }
        return names;
    }

    public Attr getAttribute(String name) {
        return this.findAttribute(name);
    }

    public Enumeration getAttributes() {
        return new IterEnumeration(this._attrs.iterator());
    }

    public String getValue(String attrName) {
        String value = null;
        Attr attr = this.findAttribute(attrName);
        if (attr != null) {
            value = attr.getValue();
        }
        return value;
    }

    public boolean contains(String attrName) {
        boolean containsTheValue = false;
        int index = this.indexOf(attrName);
        if (index != -1) {
            containsTheValue = true;
        }
        return containsTheValue;
    }

    public boolean contains(String attrName, String value) {
        boolean containsTheValue = false;
        Attr attr = this.findAttribute(attrName);
        if (attr != null) {
            containsTheValue = attr.contains(value);
        }
        return containsTheValue;
    }

    public int size() {
        return this._attrs.size();
    }

    public Attr elementAt(int index) {
        return (Attr)this._attrs.get(index);
    }

    public int indexOf(String attrName) {
        attrName = attrName.toLowerCase();
        int index = -1;
        int size = this._attrs.size();
        for (int i = 0; i < size; ++i) {
            if (!attrName.equals(((Attr)this._attrs.get(i)).getName())) continue;
            index = i;
            break;
        }
        return index;
    }

    private Attr findAttribute(String name) {
        name = name.toLowerCase();
        Attr attr = null;
        if (this._attrs != null) {
            int size = this._attrs.size();
            for (int i = 0; i < size; ++i) {
                Attr attr1 = (Attr)this._attrs.get(i);
                if (!attr1.getName().equals(name)) continue;
                attr = attr1;
                break;
            }
        }
        return attr;
    }

    public Object clone() {
        AttrSet attrSet = new AttrSet();
        int size = this._attrs.size();
        for (int i = 0; i < size; ++i) {
            attrSet.add((Attr)((Attr)this._attrs.get(i)).clone());
        }
        return attrSet;
    }

    public LDAPAttributeSet toLDAPAttributeSet() {
        LDAPAttributeSet ldapAttrSet = new LDAPAttributeSet();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)this._attrs.get(i);
            if (attr.size() <= 0) continue;
            ldapAttrSet.add(attr.toLDAPAttribute());
        }
        return ldapAttrSet;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AttrSet: ");
        int size = this._attrs.size();
        for (int i = 0; i < size; ++i) {
            sb.append(this._attrs.get(i).toString() + "\n");
        }
        return sb.toString();
    }
}

