/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.ConditionDecision;
import com.sun.identity.entitlement.EntitlementCondition;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.ldap.LDAPDN;
import java.security.AccessController;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaOneDemoAccountCondition
implements EntitlementCondition {
    @Override
    public void setState(String state) {
    }

    @Override
    public String getState() {
        return "";
    }

    @Override
    public ConditionDecision evaluate(String realm, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        try {
            String uuid;
            String accountNumber = this.getAccountNumber(resourceName);
            if (accountNumber == null) {
                return new ConditionDecision(false, Collections.EMPTY_MAP);
            }
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentity amid = new AMIdentity(adminToken, uuid = JavaOneDemoAccountCondition.getUUID(subject), IdType.USER, "/", null);
            Set setHoH = amid.getAttribute("head_of_household");
            if (setHoH == null || !setHoH.contains("1")) {
                return new ConditionDecision(false, Collections.EMPTY_MAP);
            }
            Set account = amid.getAttribute("account_number");
            if (account == null || !account.contains(accountNumber)) {
                return new ConditionDecision(false, Collections.EMPTY_MAP);
            }
            return new ConditionDecision(true, Collections.EMPTY_MAP);
        }
        catch (IdRepoException ex) {
            return new ConditionDecision(false, Collections.EMPTY_MAP);
        }
        catch (SSOException ex) {
            return new ConditionDecision(false, Collections.EMPTY_MAP);
        }
    }

    private String getAccountNumber(String resourceName) {
        String prefix = "/resources/accounts/";
        int start = resourceName.indexOf(prefix) + prefix.length();
        if (start >= resourceName.length()) {
            return null;
        }
        int end = resourceName.indexOf("/", start);
        String accountNumber = end == -1 ? resourceName.substring(start) : resourceName.substring(start, end);
        return accountNumber;
    }

    public static String getUUID(Subject subject) {
        Set<Principal> userPrincipals = subject.getPrincipals();
        String uid = userPrincipals != null && !userPrincipals.isEmpty() ? userPrincipals.iterator().next().getName() : null;
        String[] x = LDAPDN.explodeDN(uid, (boolean)true);
        return x[0];
    }
}

