/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.plugins;

import com.sun.identity.idm.AMIdentity;
import com.sun.identity.password.plugins.PasswordGenerator;
import com.sun.identity.password.ui.model.PWResetException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class RandomPasswordGenerator
implements PasswordGenerator {
    private static SecureRandom rnd = new SecureRandom();
    private static final int NUM_OF_LETTERS = 26;
    private static final int NUMBERS_RANGE = 10;
    private static final int LOWER_A = 97;
    private static final int UPPER_A = 65;
    private static final int PASSWORD_LENGTH = 8;
    private static final int SIZE = 62;
    private static List values = new ArrayList(62);

    public RandomPasswordGenerator() {
        if (values == null || values.isEmpty()) {
            RandomPasswordGenerator.initialize();
        }
    }

    private static void initialize() {
        RandomPasswordGenerator.addItemsToList(0, 10);
        RandomPasswordGenerator.addItemsToList(65, 91);
        RandomPasswordGenerator.addItemsToList(97, 123);
    }

    private static void addItemsToList(int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            values.add(new Integer(i));
        }
    }

    public String generatePassword(AMIdentity user) throws PWResetException {
        StringBuffer buf = new StringBuffer(8);
        for (int i = 0; i < 8; ++i) {
            int nextNum = rnd.nextInt(62);
            Integer value = (Integer)values.get(nextNum);
            int num = value;
            if (num < 10) {
                buf.append(String.valueOf(num));
                continue;
            }
            char c = (char)num;
            buf.append(String.valueOf(c));
        }
        return buf.toString();
    }
}

