/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.sdk.AMCallBack;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMPostCallBackException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSEntry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SubjectReferentialIntegrityPlugin
extends AMCallBack {
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void postProcessDelete(SSOToken token, String entryDN, Map attributes, boolean softDeleteEnabled, int objectType) throws AMPostCallBackException {
        try {
            if (debug.messageEnabled()) {
                debug.message("ReferentialIntegrityPlugin.postProcessDelete()");
            }
            HashSet<Integer> objectTypes = new HashSet<Integer>();
            objectTypes.add(new Integer(1));
            objectTypes.add(new Integer(6));
            objectTypes.add(new Integer(2));
            objectTypes.add(new Integer(9));
            objectTypes.add(new Integer(12));
            objectTypes.add(new Integer(11));
            objectTypes.add(new Integer(8));
            if (objectTypes.contains(new Integer(objectType))) {
                DN entryDName = new DN(entryDN);
                AMStoreConnection dpStore = new AMStoreConnection(token);
                DN rootDN = new DN(SMSEntry.getRootSuffix());
                if (debug.messageEnabled()) {
                    debug.message("Searching for all policies from root DN: " + rootDN.toString());
                }
                PolicyManager pm = new PolicyManager(token, rootDN.toString());
                String org = pm.getOrganizationName();
                Map configParams = PolicyConfig.getPolicyConfig(org);
                String ldapServer = ((String)configParams.get("iplanet-am-policy-config-ldap-server")).toLowerCase();
                boolean localDS = PolicyUtils.isLocalDS(ldapServer);
                if (objectType == 6) {
                    localDS = true;
                }
                if (localDS) {
                    AMOrganization rootOrg = dpStore.getOrganization(org);
                    Set subOrgs = null;
                    subOrgs = rootOrg.searchSubOrganizations("*", 2);
                    for (String subOrg : subOrgs) {
                        if (debug.messageEnabled()) {
                            debug.message("Visiting suborg: " + subOrg);
                        }
                        PolicyManager pmSubOrg = new PolicyManager(token, subOrg);
                        Set policies = pmSubOrg.getPolicyNames();
                        for (String policyName : policies) {
                            Policy policy;
                            if (debug.messageEnabled()) {
                                debug.message("policyName: " + policyName);
                            }
                            if ((policy = pmSubOrg.getPolicy(policyName)).isReferralPolicy()) continue;
                            boolean replacePolicy = false;
                            Set subjectsInPolicy = policy.getSubjectNames();
                            HashSet subjects = new HashSet();
                            subjects.addAll(subjectsInPolicy);
                            block6: for (String subjectName : subjects) {
                                if (debug.messageEnabled()) {
                                    debug.message("subjectName: " + subjectName);
                                }
                                Subject subject = policy.getSubject(subjectName);
                                Set set = subject.getValues();
                                Iterator ite = set.iterator();
                                String str = null;
                                DN strDN = null;
                                while (ite.hasNext()) {
                                    str = (String)ite.next();
                                    strDN = new DN(str);
                                    if (!entryDName.equals(strDN)) continue;
                                    replacePolicy = true;
                                    if (debug.messageEnabled()) {
                                        debug.message("DNs match, str:" + str + "entryDN:" + entryDN);
                                    }
                                    set.remove(str);
                                    if (set.isEmpty()) {
                                        policy.removeSubject(subjectName);
                                        if (!debug.messageEnabled()) continue block6;
                                        debug.message("subjectDeleted:" + subjectName);
                                        continue block6;
                                    }
                                    subject.setValues(set);
                                    continue block6;
                                }
                            }
                            if (!replacePolicy) continue;
                            pmSubOrg.replacePolicy(policy);
                        }
                    }
                }
            }
        }
        catch (PolicyException pe) {
            debug.error("ReferentialIntegrityPlugin.postProcessDelete():", (Throwable)pe);
        }
        catch (SSOException sse) {
            debug.error("ReferentialIntegrityPlugin.postProcessDelete():", (Throwable)((Object)sse));
        }
        catch (Exception e) {
            debug.error("ReferentialIntegrityPlugin.postProcessDelete():", (Throwable)e);
        }
    }
}

