/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcClient;
import com.sun.identity.liberty.ws.authnsvc.AuthnSvcException;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLRequest;
import com.sun.identity.liberty.ws.authnsvc.protocol.SASLResponse;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.logging.LogUtil;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.STSConfig;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.AssertionTokenSpec;
import com.sun.identity.wss.security.KerberosTokenSpec;
import com.sun.identity.wss.security.PasswordCredential;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenSpec;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.SecurityTokenFactory;
import com.sun.identity.wss.security.UserNameTokenSpec;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.X509TokenSpec;
import com.sun.identity.wss.security.handler.MessageAuthenticator;
import com.sun.identity.wss.security.handler.MessageProcessor;
import com.sun.identity.wss.security.handler.SOAPRequestHandlerInterface;
import com.sun.identity.wss.security.handler.SecureSOAPMessage;
import com.sun.identity.wss.security.handler.ThreadLocalService;
import com.sun.identity.wss.security.handler.WSSCache;
import com.sun.identity.wss.security.handler.WSSCacheRepository;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.TrustAuthorityClient;
import com.sun.identity.wss.sts.config.STSRemoteConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SOAPRequestHandler
implements SOAPRequestHandlerInterface {
    private String providerName = null;
    private String PROVIDER_NAME = "providername";
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static String BACK_SLASH = "\\";
    private static String FORWARD_SLASH = "/";
    private static MessageAuthenticator authenticator = null;
    private static final String WSS_AUTHENTICATOR = "com.sun.identity.wss.security.authenticator";
    private static final String LIBERTY_AUTHN_URL = "com.sun.identity.liberty.authnsvc.url";
    private static final String MECHANISM_SSOTOKEN = "SSOTOKEN";
    private static final String ASSERTION_ISSUER = "com.sun.identity.wss.security.samlassertion.issuer";

    public void init(Map config) throws SecurityException {
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.Init map:");
        }
        this.providerName = (String)config.get(this.PROVIDER_NAME);
    }

    public Object validateRequest(SOAPMessage soapRequest, Subject subject, Map sharedState, HttpServletRequest request, HttpServletResponse response) throws SecurityException {
        Boolean isTrustMessage;
        boolean isSTS;
        ProviderConfig config = null;
        STSRemoteConfig stsConfig = null;
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateRequest: Before validation: " + WSSUtils.print((Node)soapRequest.getSOAPPart()));
        }
        if (LogUtil.isLogEnabled()) {
            String[] data = new String[]{WSSUtils.print((Node)soapRequest.getSOAPPart())};
            LogUtil.access(Level.FINE, "REQUEST_TO_BE_VALIDATED", data, null);
        }
        boolean bl = isSTS = (isTrustMessage = (Boolean)sharedState.get("IS_TRUST_MSG")) != null ? isTrustMessage : false;
        if (isSTS) {
            debug.message("ValidateRequest: This is WS-Trust Request");
            stsConfig = new STSRemoteConfig();
            config = this.getSTSProviderConfig(stsConfig);
        } else {
            config = this.getWSPConfig();
        }
        if (this.isLibertyMessage(soapRequest)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.validateRequest:: Incoming SOAPMessage is of liberty message type.");
            }
            MessageProcessor processor = new MessageProcessor(config);
            try {
                processor.validateRequest(soapRequest, subject, sharedState, request);
                this.removeValidatedHeaders(config, soapRequest);
                return subject;
            }
            catch (SOAPBindingException sbe) {
                debug.error("SOAPRequestHandler.validateRequest:: SOAPBindingException:: ", (Throwable)sbe);
                throw new SecurityException(sbe.getMessage());
            }
        }
        SecureSOAPMessage secureMsg = new SecureSOAPMessage(soapRequest, false);
        if (config != null && (config.isRequestEncryptEnabled() || config.isRequestHeaderEncryptEnabled())) {
            secureMsg.decrypt(config.getKeyAlias(), config.isRequestEncryptEnabled(), config.isRequestHeaderEncryptEnabled());
            soapRequest = secureMsg.getSOAPMessage();
            secureMsg = new SecureSOAPMessage(soapRequest, false);
        }
        secureMsg.parseSecurityHeader(secureMsg.getSecurityHeaderElement());
        String msgID = secureMsg.getMessageID();
        if (msgID != null && config.isMessageReplayDetectionEnabled() && this.checkForReplay(msgID, config.getProviderName())) {
            throw new SecurityException(bundle.getString("replayAttackDetected"));
        }
        SecurityMechanism securityMechanism = secureMsg.getSecurityMechanism();
        String uri = securityMechanism.getURI();
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateRequest: soap message security mechanism: ");
        }
        if (config != null && config.isRequestSignEnabled() && !uri.equals("urn:sun:wss:security:null:KerberosToken")) {
            if (!secureMsg.verifySignature(config.getPublicKeyAlias())) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAPRequestHandler.validateRequest:: Signature verification failed.");
                }
                throw new SecurityException(bundle.getString("signatureValidationFailed"));
            }
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.validateRequest: Signature verification successful");
            }
        }
        List list = null;
        if (config != null) {
            list = config.getSecurityMechanisms();
        }
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateRequest: list of accepted SecurityMechanisms : " + list);
        }
        if (!list.contains(uri)) {
            if (!(list.contains("urn:sun:wss:security:null:Anonymous") || list.contains("urn:sun:wss:security:TLS:Anonymous") || list.contains("urn:sun:wss:security:ClientTLS:Anonymous"))) {
                if (debug.warningEnabled()) {
                    debug.warning("SOAPRequestHandler.validateRequest: unsupported security mechanism");
                }
                throw new SecurityException(bundle.getString("unsupportedSecurityMechanism"));
            }
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.validateRequest:: provider is not configured for the incoming message  level type but allows anonymous");
            }
            return subject;
        }
        if ("urn:sun:wss:security:null:Anonymous".equals(uri) || "urn:sun:wss:security:TLS:Anonymous".equals(uri) || "urn:sun:wss:security:ClientTLS:Anonymous".equals(uri)) {
            return subject;
        }
        subject = (Subject)SOAPRequestHandler.getAuthenticator().authenticate(subject, secureMsg.getSecurityMechanism(), secureMsg.getSecurityToken(), config, secureMsg, false);
        if (msgID == null && config.isMessageReplayDetectionEnabled() && this.checkForReplay(subject, secureMsg.getMessageTimestamp(), config.getProviderName())) {
            throw new SecurityException(bundle.getString("replayAttackDeteced"));
        }
        if (uri.equals("urn:sun:wss:security:null:KerberosToken") && config.isValidateKerberosSignature()) {
            Key secretKey = null;
            for (Object obj : subject.getPublicCredentials()) {
                if (!(obj instanceof Key)) continue;
                secretKey = (Key)obj;
                break;
            }
            if (!secureMsg.verifyKerberosTokenSignature(secretKey)) {
                debug.error("SOAPRequestHandler.validateRequest::Signatureverification failed.");
                throw new SecurityException(bundle.getString("signatureValidationFailed"));
            }
        }
        this.removeValidatedHeaders(config, soapRequest);
        if (!isSTS) {
            ThreadLocalService.setSubject(subject);
        }
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateRequest:** SOAP message at the end of Validate request **");
            debug.message(WSSUtils.print((Node)soapRequest.getSOAPPart()));
        }
        if (LogUtil.isLogEnabled()) {
            String[] data2 = new String[]{this.providerName, uri};
            LogUtil.access(Level.INFO, "SUCCESS_VALIDATE_REQUEST", data2, null);
        }
        return subject;
    }

    public SOAPMessage secureResponse(SOAPMessage soapMessage, Map sharedState) throws SecurityException {
        boolean isSTS;
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.secureResponse - Input SOAP message : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        if (LogUtil.isLogEnabled()) {
            String[] data = new String[]{WSSUtils.print((Node)soapMessage.getSOAPPart())};
            LogUtil.access(Level.FINE, "RESPONSE_TO_BE_SECURED", data, null);
        }
        ProviderConfig config = null;
        STSRemoteConfig stsConfig = null;
        Boolean isTrustMessage = (Boolean)sharedState.get("IS_TRUST_MSG");
        boolean bl = isSTS = isTrustMessage != null ? isTrustMessage : false;
        if (isSTS) {
            debug.message("SecureResponse: This is WS-Trust Response");
            stsConfig = new STSRemoteConfig();
            config = this.getSTSProviderConfig(stsConfig);
        } else {
            ThreadLocalService.removeSubject();
            config = this.getWSPConfig();
        }
        Object req = sharedState.get("LibertyRequest");
        if (req != null) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.secureResponse: liberty req:");
            }
            MessageProcessor processor = new MessageProcessor(config);
            try {
                return processor.secureResponse(soapMessage, sharedState);
            }
            catch (SOAPBindingException sbe) {
                debug.error("SOAPRequestHandler.secureResponse:: SOAPBindingException.", (Throwable)sbe);
                throw new SecurityException(sbe.getMessage());
            }
        }
        SecureSOAPMessage secureMessage = new SecureSOAPMessage(soapMessage, true);
        try {
            secureMessage.getSOAPMessage().saveChanges();
        }
        catch (SOAPException se) {
            throw new SecurityException(se.getMessage());
        }
        if (config != null && !config.isResponseSignEnabled() && !config.isResponseEncryptEnabled()) {
            return soapMessage;
        }
        SSOToken token = WSSUtils.getAdminToken();
        SecurityTokenFactory factory = SecurityTokenFactory.getInstance(token);
        String keyAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
        String publicKeyAlias = null;
        if (config != null) {
            keyAlias = config.getKeyAlias();
            publicKeyAlias = config.getPublicKeyAlias();
        } else if (stsConfig != null) {
            keyAlias = stsConfig.getPrivateKeyAlias();
            publicKeyAlias = stsConfig.getPublicKeyAlias();
        }
        String[] certAlias = new String[]{keyAlias};
        X509TokenSpec tokenSpec = new X509TokenSpec(certAlias, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        SecurityToken securityToken = factory.getSecurityToken(tokenSpec);
        secureMessage.setSecurityToken(securityToken);
        secureMessage.setSecurityMechanism(SecurityMechanism.WSS_NULL_X509_TOKEN);
        if (config != null && config.isResponseSignEnabled()) {
            secureMessage.sign(keyAlias, config.getSigningRefType());
        }
        if (config != null && config.isResponseEncryptEnabled()) {
            secureMessage.encrypt(publicKeyAlias, config.getEncryptionAlgorithm(), config.getEncryptionStrength(), true, false);
        }
        soapMessage = secureMessage.getSOAPMessage();
        if (LogUtil.isLogEnabled()) {
            String[] data2 = new String[]{this.providerName};
            LogUtil.access(Level.INFO, "SUCCESS_SECURE_RESPONSE", data2, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.secureResponse - Secured SOAP response : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        return soapMessage;
    }

    public SOAPMessage secureRequest(SOAPMessage soapMessage, Subject subject, Map sharedState) throws SecurityException {
        ProviderConfig config;
        if (LogUtil.isLogEnabled()) {
            String[] data = new String[]{WSSUtils.print((Node)soapMessage.getSOAPPart())};
            LogUtil.access(Level.FINE, "REQUEST_TO_BE_SECURED", data, null);
        }
        if ((config = this.getProviderConfig(sharedState)) == null) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SOAPRequestHandler.secureRequest: Provider configuration from shared map is null");
            }
            config = this.getWSCConfig();
        }
        SecurityToken securityToken = null;
        List secMechs = config.getSecurityMechanisms();
        if (secMechs == null || secMechs.isEmpty()) {
            throw new SecurityException(bundle.getString("securityMechNotConfigured"));
        }
        String sechMech = (String)secMechs.iterator().next();
        SecurityMechanism securityMechanism = SecurityMechanism.getSecurityMechanism(sechMech);
        SecureSOAPMessage secureMessage = null;
        String uri = securityMechanism.getURI();
        if ("urn:sun:wss:security:null:Anonymous".equals(uri) || "urn:sun:wss:security:TLS:Anonymous".equals(uri) || "urn:sun:wss:security:ClientTLS:Anonymous".equals(uri)) {
            secureMessage = new SecureSOAPMessage(soapMessage, true);
        } else {
            if (securityMechanism.isTALookupRequired()) {
                Subject authnSubj;
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.secureRequest :using STS for security tokens");
                }
                if (config.usePassThroughSecurityToken() && (authnSubj = this.getAuthenticatedSubject()) != null) {
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.secureRequest : using the authenticated subject");
                    }
                    subject = authnSubj;
                }
                SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                SSOToken ssoToken = subjectSecurity.ssoToken;
                if (ssoToken == null) {
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.secureRequest:: using thread local for SSOToken");
                    }
                    ssoToken = (SSOToken)ThreadLocalService.getSSOToken();
                }
                if (debug.messageEnabled() && ssoToken != null) {
                    debug.message("SOAPequestHandler.secureRequest: ssoToken is available. ");
                }
                if (securityMechanism.getURI().equals("urn:sun:liberty:discovery:security")) {
                    if (ssoToken == null) {
                        throw new SecurityException(bundle.getString("invalidSSOToken"));
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.secureRequest:  using liberty security");
                    }
                    return this.getSecureMessageFromLiberty(ssoToken, subject, soapMessage, sharedState, config);
                }
                try {
                    Object customToken;
                    TrustAuthorityClient client = new TrustAuthorityClient();
                    TrustAuthorityConfig taconfig = config.getTrustAuthorityConfig();
                    String taName = taconfig.getName();
                    if (taName != null) {
                        ThreadLocalService.setServiceName(taName);
                    }
                    if ((customToken = this.getCustomCredential(subject)) == null) {
                        if (debug.messageEnabled()) {
                            debug.message("SOAPRequestHandler.secureRequest: using sso token as OBOToken");
                        }
                        securityToken = client.getSecurityToken(config, ssoToken);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.secureRequest: using custom token as OBOToken");
                    }
                    securityToken = client.getSecurityToken(config, customToken);
                }
                catch (FAMSTSException stsEx) {
                    debug.error("SOAPRequestHandler.secureRequest: exceptionin obtaining STS Token", (Throwable)stsEx);
                    throw new SecurityException(stsEx.getMessage());
                }
            } else {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.secureRequest:  Generate security tokens locally");
                }
                securityToken = this.getSecurityToken(securityMechanism, config, subject);
            }
            secureMessage = new SecureSOAPMessage(soapMessage, true);
            String refType = config.getSigningRefType();
            if (!securityMechanism.getURI().equals("urn:sun:wss:security:null:X509Token") || refType == null || "DirectReference".equals(refType)) {
                secureMessage.setSecurityToken(securityToken);
            }
        }
        secureMessage.setSecurityMechanism(securityMechanism);
        String keyAlias = config.getKeyAlias();
        if (keyAlias == null) {
            keyAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
        }
        if (config.isRequestSignEnabled()) {
            secureMessage.sign(keyAlias, config.getSigningRefType());
        }
        if (config.isRequestEncryptEnabled() || config.isRequestHeaderEncryptEnabled()) {
            secureMessage.encrypt(config.getPublicKeyAlias(), config.getEncryptionAlgorithm(), config.getEncryptionStrength(), config.isRequestEncryptEnabled(), config.isRequestHeaderEncryptEnabled());
        }
        soapMessage = secureMessage.getSOAPMessage();
        if (LogUtil.isLogEnabled()) {
            String[] data2 = new String[]{this.providerName, uri};
            LogUtil.access(Level.INFO, "SUCCESS_SECURE_REQUEST", data2, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.secureRequest:  SOAP message after securing: " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        return soapMessage;
    }

    public void validateResponse(SOAPMessage soapMessage, Map sharedState) throws SecurityException {
        ProviderConfig config;
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateResponse - Input SOAP message : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
        if (LogUtil.isLogEnabled()) {
            String[] data = new String[]{WSSUtils.print((Node)soapMessage.getSOAPPart())};
            LogUtil.access(Level.FINE, "RESPONSE_TO_BE_VALIDATED", data, null);
        }
        if ((config = this.getProviderConfig(sharedState)) == null) {
            if (WSSUtils.debug.messageEnabled()) {
                WSSUtils.debug.message("SOAPRequestHandler.validateResponse: Provider configuration from shared map is null");
            }
            config = this.getWSCConfig();
        }
        if (this.isLibertyMessage(soapMessage)) {
            MessageProcessor processor = new MessageProcessor(config);
            try {
                processor.validateResponse(soapMessage, sharedState);
                this.removeValidatedHeaders(config, soapMessage);
                return;
            }
            catch (SOAPBindingException sbe) {
                debug.error("SOAPRequestHandler.validateResponse:: SOAPBindingException. ", (Throwable)sbe);
                throw new SecurityException(sbe.getMessage());
            }
        }
        if (config.isResponseEncryptEnabled() || config.isResponseSignEnabled()) {
            SecureSOAPMessage secureMessage = new SecureSOAPMessage(soapMessage, false);
            if (config.isResponseEncryptEnabled()) {
                secureMessage.decrypt(config.getKeyAlias(), config.isResponseEncryptEnabled(), false);
                soapMessage = secureMessage.getSOAPMessage();
            }
            secureMessage.parseSecurityHeader(secureMessage.getSecurityHeaderElement());
            if (config.isResponseSignEnabled() && !secureMessage.verifySignature(config.getPublicKeyAlias())) {
                debug.error("SOAPRequestHandler.validateResponse:: Signature Verification failed");
                throw new SecurityException(bundle.getString("signatureValidationFailed"));
            }
        }
        this.removeValidatedHeaders(config, soapMessage);
        if (LogUtil.isLogEnabled()) {
            String[] data2 = new String[]{this.providerName};
            LogUtil.access(Level.INFO, "SUCCESS_VALIDATE_RESPONSE", data2, null);
        }
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.validateResponse - SOAP message after validation : " + WSSUtils.print((Node)soapMessage.getSOAPPart()));
        }
    }

    private void initializeSystemProperties(ProviderConfig config) throws IOException {
        String keyStoreFile = config.getKeyStoreFile();
        String ksPasswd = config.getKeyStoreEncryptedPasswd();
        String keyPasswd = config.getKeyEncryptedPassword();
        String certAlias = config.getKeyAlias();
        if (keyStoreFile == null || ksPasswd == null) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.initSystemProperties:: Provider config does not have keystore information. Will fallback to the default configuration in AMConfig.");
            }
            return;
        }
        if (keyStoreFile.indexOf(BACK_SLASH) != -1) {
            keyStoreFile.replaceAll(BACK_SLASH, FORWARD_SLASH);
        }
        int index = keyStoreFile.lastIndexOf(FORWARD_SLASH);
        String storePassFile = keyStoreFile.substring(0, index) + "/.storepassfile";
        String keyPassFile = keyStoreFile.substring(0, index) + "/.keypassfile";
        if (debug.messageEnabled()) {
            debug.message("SOAPRequestHandler.initSystemProperties:: \nKeyStoreFile: " + keyStoreFile + "\n" + "Encrypted keystore password: " + ksPasswd + "\n" + "Encrypted key password: " + keyPasswd + "\n" + "Location of the store encrypted password: " + storePassFile + "\n" + "Location of the key encrypted password: " + keyPassFile);
        }
        if (keyPasswd == null) {
            keyPasswd = ksPasswd;
        }
        FileOutputStream out = new FileOutputStream(new File(keyPassFile));
        out.write(keyPasswd.getBytes());
        out.flush();
        FileOutputStream out1 = new FileOutputStream(new File(storePassFile));
        out1.write(ksPasswd.getBytes());
        out1.flush();
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.keystore", (String)keyStoreFile);
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.storepass", (String)storePassFile);
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.keypass", (String)keyPassFile);
        SystemProperties.initializeProperties((String)"com.sun.identity.saml.xmlsig.certalias", (String)certAlias);
    }

    private ProviderConfig getWSPConfig() throws SecurityException {
        ProviderConfig config = null;
        if (this.providerName == null || this.providerName.length() == 0) {
            this.providerName = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.provider.defaultWSP", (String)"wsp");
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getWSPConfig: default provider name:" + this.providerName);
            }
        }
        try {
            if (!ProviderConfig.isProviderExists(this.providerName, "WSPAgent")) {
                config = ProviderConfig.getProviderByEndpoint(this.providerName, "WSPAgent");
                if (!ProviderConfig.isProviderExists(this.providerName, "WSPAgent", true)) {
                    this.providerName = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.provider.defaultWSP", (String)"wsp");
                    config = ProviderConfig.getProvider(this.providerName, "WSPAgent");
                }
            } else {
                config = ProviderConfig.getProvider(this.providerName, "WSPAgent");
            }
            if (!config.useDefaultKeyStore()) {
                this.initializeSystemProperties(config);
            }
        }
        catch (ProviderException pe) {
            debug.error("SOAPRequestHandler.getWSPConfig:: Provider configuration read failure", (Throwable)pe);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        catch (IOException ie) {
            debug.error("SOAPRequestHandler.getWSPConfig:: Provider configuration read failure", (Throwable)ie);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        return config;
    }

    private ProviderConfig getWSCConfig() throws SecurityException {
        ProviderConfig config = null;
        try {
            if (!ProviderConfig.isProviderExists(this.providerName, "WSCAgent")) {
                this.providerName = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.provider.defaultWSC", (String)"wsc");
                config = ProviderConfig.getProvider(this.providerName, "WSCAgent");
            } else {
                config = ProviderConfig.getProvider(this.providerName, "WSCAgent");
            }
            if (!config.useDefaultKeyStore()) {
                this.initializeSystemProperties(config);
            }
        }
        catch (ProviderException pe) {
            debug.error("SOAPRequestHandler.getWSCConfig:: Provider configuration read failure", (Throwable)pe);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        catch (IOException ie) {
            debug.error("SOAPRequestHandler.getWSCConfig:: Provider configuration read failure", (Throwable)ie);
            throw new SecurityException(bundle.getString("cannotInitializeProvider"));
        }
        return config;
    }

    private SecurityToken getSecurityToken(SecurityMechanism secMech, ProviderConfig config, Subject subject) throws SecurityException {
        String uri = secMech.getURI();
        String certAlias = SystemConfigurationUtil.getProperty((String)"com.sun.identity.saml.xmlsig.certalias");
        if (!config.useDefaultKeyStore()) {
            certAlias = config.getKeyAlias();
        }
        SecurityToken securityToken = null;
        if (debug.messageEnabled()) {
            debug.message("getSecurityToken: SecurityMechanism URI : " + uri);
        }
        SSOToken token = WSSUtils.getAdminToken();
        SecurityTokenFactory factory = SecurityTokenFactory.getInstance(token);
        if ("urn:sun:wss:security:null:X509Token".equals(uri) || "urn:sun:wss:security:TLS:X509Token".equals(uri) || "urn:sun:wss:security:ClientTLS:X509Token".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating X509 token");
            }
            String[] aliases = new String[]{certAlias};
            X509TokenSpec tokenSpec = new X509TokenSpec(aliases, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:null:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-SV".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating SAML token");
            }
            if (config.usePassThroughSecurityToken()) {
                securityToken = this.getSecurityTokenFromSubject(subject);
            }
            if (securityToken != null) {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getSecurityToken::security token from subject is not null");
                }
                return securityToken;
            }
            String issuer = SystemConfigurationUtil.getProperty((String)ASSERTION_ISSUER);
            NameIdentifier ni = null;
            HashMap<QName, List<String>> samlAttributes = new HashMap<QName, List<String>>();
            try {
                SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                SSOToken userToken = subjectSecurity.ssoToken;
                if (userToken == null) {
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.getSecurityToken:: using thread local for SSOToken");
                    }
                    userToken = (SSOToken)ThreadLocalService.getSSOToken();
                }
                if (userToken != null) {
                    Map<QName, List<String>> memberships;
                    String subjectName = userToken.getPrincipal().getName();
                    String nameIDImpl = config.getNameIDMapper();
                    ni = nameIDImpl == null || nameIDImpl.length() == 0 ? new NameIdentifier(subjectName) : new NameIdentifier(WSSUtils.getUserPseduoName(subjectName, nameIDImpl));
                    Map<QName, List<String>> attributes = WSSUtils.getSAMLAttributes(subjectName, config.getSAMLAttributeMapping(), config.getSAMLAttributeNamespace(), userToken);
                    if (attributes != null) {
                        samlAttributes.putAll(attributes);
                    }
                    if (config.shouldIncludeMemberships() && (memberships = WSSUtils.getMembershipAttributes(subjectName, config.getSAMLAttributeNamespace())) != null) {
                        samlAttributes.putAll(memberships);
                    }
                } else {
                    ni = issuer != null && issuer.length() != 0 ? new NameIdentifier(issuer) : new NameIdentifier(SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host"));
                }
            }
            catch (Exception ex) {
                debug.error("SOAPRequestHandler.getSecurityToken: Failed in creating SAML tokens", (Throwable)ex);
                throw new SecurityException(ex.getMessage());
            }
            AssertionTokenSpec tokenSpec = new AssertionTokenSpec(ni, secMech, certAlias);
            if (issuer != null && issuer.length() != 0) {
                tokenSpec.setIssuer(issuer);
            }
            if (!samlAttributes.isEmpty()) {
                tokenSpec.setClaimedAttributes(samlAttributes);
            }
            tokenSpec.setSigningAlias(certAlias);
            String appliesTo = config.getWSPEndpoint();
            if (appliesTo != null) {
                tokenSpec.setAppliesTo(appliesTo);
            }
            tokenSpec.setAssertionID(SAMLUtilsCommon.generateID());
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:UserNameToken".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken".equals(uri) || "urn:sun:wss:security:null:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken-Plain".equals(uri)) {
            List creds;
            block56: {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getSecurityToken:: creating UserName token");
                }
                creds = null;
                try {
                    SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                    SSOToken ssoToken = subjectSecurity.ssoToken;
                    creds = this.getUserCredentialsFromSSOToken(ssoToken);
                    if (creds == null || creds.isEmpty()) {
                        creds = subjectSecurity.userCredentials;
                    }
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) break block56;
                    debug.message("SOAPRequestHandler.getSecurityToken:: getSubjectSecurity error :" + ex.getMessage());
                }
            }
            if (creds == null || creds.isEmpty()) {
                creds = config.getUsers();
            }
            if (creds == null || creds.isEmpty()) {
                debug.error("SOAPRequestHandler.getSecurityToken:: No users  are configured.");
                throw new SecurityException(bundle.getString("nousers"));
            }
            PasswordCredential credential = (PasswordCredential)creds.iterator().next();
            UserNameTokenSpec tokenSpec = new UserNameTokenSpec();
            if ("urn:sun:wss:security:null:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken-Plain".equals(uri)) {
                tokenSpec.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
            } else {
                tokenSpec.setNonce(true);
                tokenSpec.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
            }
            tokenSpec.setCreateTimeStamp(true);
            tokenSpec.setUserName(credential.getUserName());
            tokenSpec.setPassword(credential.getPassword());
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:null:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-SV".equals(uri)) {
            String appliesTo;
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating SAML2 token");
            }
            if (config.usePassThroughSecurityToken()) {
                securityToken = this.getSecurityTokenFromSubject(subject);
            }
            if (securityToken != null) {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getSecurityToken::security token from subject is not null");
                }
                return securityToken;
            }
            String issuer = SystemConfigurationUtil.getProperty((String)ASSERTION_ISSUER);
            NameID ni = null;
            HashMap<QName, List<String>> samlAttributes = new HashMap<QName, List<String>>();
            try {
                AssertionFactory assertionFactory = AssertionFactory.getInstance();
                ni = assertionFactory.createNameID();
                SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
                SSOToken userToken = subjectSecurity.ssoToken;
                if (userToken == null) {
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.getSecurityToken:: using thread local for SSOToken");
                    }
                    userToken = (SSOToken)ThreadLocalService.getSSOToken();
                }
                if (userToken != null) {
                    Map<QName, List<String>> memberships;
                    String subjectName = userToken.getPrincipal().getName();
                    String nameIDMapper = config.getNameIDMapper();
                    if (nameIDMapper == null) {
                        ni.setValue(subjectName);
                    } else {
                        ni.setValue(WSSUtils.getUserPseduoName(subjectName, nameIDMapper));
                    }
                    Map<QName, List<String>> attributes = WSSUtils.getSAMLAttributes(subjectName, config.getSAMLAttributeMapping(), config.getSAMLAttributeNamespace(), userToken);
                    if (attributes != null) {
                        samlAttributes.putAll(attributes);
                    }
                    if ((memberships = WSSUtils.getMembershipAttributes(subjectName, config.getSAMLAttributeNamespace())) != null) {
                        samlAttributes.putAll(memberships);
                    }
                } else if (issuer != null && issuer.length() != 0) {
                    ni.setValue(issuer);
                } else {
                    ni.setValue(SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host"));
                }
            }
            catch (Exception ex) {
                throw new SecurityException(ex.getMessage());
            }
            SAML2TokenSpec tokenSpec = new SAML2TokenSpec(ni, secMech, certAlias);
            if (issuer != null && issuer.length() != 0) {
                tokenSpec.setIssuer(issuer);
            }
            if (!samlAttributes.isEmpty()) {
                tokenSpec.setClaimedAttributes(samlAttributes);
            }
            if ((appliesTo = config.getWSPEndpoint()) != null) {
                tokenSpec.setAppliesTo(appliesTo);
            }
            tokenSpec.setSigningAlias(certAlias);
            tokenSpec.setAssertionID(SAMLUtilsCommon.generateID());
            securityToken = factory.getSecurityToken(tokenSpec);
        } else if ("urn:sun:wss:security:null:KerberosToken".equals(uri) || "urn:sun:wss:security:TLS:KerberosToken".equals(uri) || "urn:sun:wss:security:ClientTLS:KerberosToken".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecurityToken:: creating Kerberos token");
            }
            KerberosTokenSpec tokenSpec = new KerberosTokenSpec();
            tokenSpec.setKDCDomain(config.getKDCDomain());
            tokenSpec.setKDCServer(config.getKDCServer());
            tokenSpec.setServicePrincipal(config.getKerberosServicePrincipal());
            tokenSpec.setTicketCacheDir(config.getKerberosTicketCacheDir());
            securityToken = factory.getSecurityToken(tokenSpec);
        } else {
            throw new SecurityException(bundle.getString("unsupportedSecurityMechanism"));
        }
        return securityToken;
    }

    private SubjectSecurity getSubjectSecurity(Subject subject) {
        final SubjectSecurity subjectSecurity = new SubjectSecurity();
        final Subject sub = subject;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<Object> creds = sub.getPrivateCredentials();
                if (creds == null || creds.isEmpty()) {
                    return null;
                }
                for (Object credObj : creds) {
                    List list;
                    if (credObj instanceof SSOToken) {
                        subjectSecurity.ssoToken = (SSOToken)credObj;
                        continue;
                    }
                    if (credObj instanceof ResourceOffering) {
                        subjectSecurity.discoRO = (ResourceOffering)credObj;
                        continue;
                    }
                    if (!(credObj instanceof List) || (list = (List)credObj) == null || list.size() <= 0) continue;
                    if (list.get(0) instanceof SecurityAssertion) {
                        subjectSecurity.discoCredentials = list;
                        continue;
                    }
                    if (!(list.get(0) instanceof PasswordCredential)) continue;
                    subjectSecurity.userCredentials = list;
                }
                return null;
            }
        });
        return subjectSecurity;
    }

    public static MessageAuthenticator getAuthenticator() throws SecurityException {
        if (authenticator != null) {
            return authenticator;
        }
        String classImpl = SystemConfigurationUtil.getProperty((String)WSS_AUTHENTICATOR, (String)"com.sun.identity.wss.security.handler.DefaultAuthenticator");
        try {
            Class<?> authnClass = Class.forName(classImpl);
            authenticator = (MessageAuthenticator)authnClass.newInstance();
        }
        catch (Exception ex) {
            debug.error("SOAPRequestHandler.getAuthenticator:: Unable to get the authenticator", (Throwable)ex);
            throw new SecurityException(bundle.getString("authenticatorNotFound"));
        }
        return authenticator;
    }

    private SOAPMessage getSecureMessageFromLiberty(SSOToken ssoToken, Subject subject, SOAPMessage soapMessage, Map sharedData, ProviderConfig providerConfig) throws SecurityException {
        try {
            SSOTokenManager.getInstance().validateToken(ssoToken);
            ResourceOffering discoRO = this.getDiscoveryResourceOffering(subject, ssoToken);
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getSecureMessageFromLiberty:: Discovery service resource offering. " + discoRO.toString());
            }
            List credentials = this.getDiscoveryCredentials(subject);
            MessageProcessor processor = new MessageProcessor(providerConfig);
            return processor.secureRequest(discoRO, credentials, providerConfig.getServiceType(), soapMessage, sharedData);
        }
        catch (SSOException se) {
            debug.error("SOAPRequestHandler.getSecureMessageFromLiberty:: Invalid sso token", (Throwable)se);
            throw new SecurityException(bundle.getString("invalidSSOToken"));
        }
        catch (SOAPBindingException sbe) {
            debug.error("SOAPRequestHandler.getSecureMessageFromLiberty::  SOAPBinding exception", (Throwable)sbe);
            throw new SecurityException(sbe.getMessage());
        }
    }

    private ResourceOffering getDiscoveryResourceOffering(Subject subject, SSOToken ssoToken) throws SecurityException {
        SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
        if (subjectSecurity.discoRO != null) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getDiscoveryResourceOffering:: subject contains resource offering.");
            }
            return subjectSecurity.discoRO;
        }
        SASLResponse saslResponse = this.getSASLResponse(ssoToken);
        if (saslResponse == null) {
            debug.error("SOAPRequestHandler.getDiscoveryResourceOffering:: SASL Response is null");
            throw new SecurityException(bundle.getString("SASLFailure"));
        }
        final ResourceOffering discoRO = saslResponse.getResourceOffering();
        if (discoRO == null) {
            throw new SecurityException(bundle.getString("resourceOfferingMissing"));
        }
        final List credentials = saslResponse.getCredentials();
        final Subject sub = subject;
        if (discoRO != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    sub.getPrivateCredentials().add(discoRO);
                    if (credentials != null) {
                        sub.getPrivateCredentials().add(credentials);
                    }
                    return null;
                }
            });
        }
        return discoRO;
    }

    private List getDiscoveryCredentials(Subject subject) {
        SubjectSecurity subjectSecurity = this.getSubjectSecurity(subject);
        return subjectSecurity.discoCredentials;
    }

    private SASLResponse getSASLResponse(SSOToken ssoToken) throws SecurityException {
        SASLRequest saslReq = new SASLRequest(MECHANISM_SSOTOKEN);
        try {
            String authURL = SystemConfigurationUtil.getProperty((String)LIBERTY_AUTHN_URL);
            if (authURL == null) {
                debug.error("SOAPRequestHandler.getSASLResponse:: AuthnURL  not present in the configuration.");
                throw new SecurityException(bundle.getString("authnURLMissing"));
            }
            SASLResponse saslResp = AuthnSvcClient.sendRequest((SASLRequest)saslReq, (String)authURL);
            if (!saslResp.getStatusCode().equals("continue")) {
                debug.error("SOAPRequestHandler.getSASLResponse:: ABORT");
                throw new SecurityException(bundle.getString("SASLFailure"));
            }
            String serverMechanism = saslResp.getServerMechanism();
            saslReq = new SASLRequest(serverMechanism);
            saslReq.setData(ssoToken.getTokenID().toString().getBytes("UTF-8"));
            saslReq.setRefToMessageID(saslResp.getMessageID());
            saslResp = AuthnSvcClient.sendRequest((SASLRequest)saslReq, (String)authURL);
            if (!saslResp.getStatusCode().equals("OK")) {
                debug.error("SOAPRequestHandler.getSASLResponse:: SASL Failure");
                throw new SecurityException(bundle.getString("SASLFailure"));
            }
            return saslResp;
        }
        catch (AuthnSvcException ae) {
            debug.error("SOAPRequestHandler.getSASLResponse:: Exception", (Throwable)ae);
            throw new SecurityException(bundle.getString("SASLFailure"));
        }
        catch (UnsupportedEncodingException uae) {
            debug.error("SOAPRequestHandler.getSASLResponse:: Exception", (Throwable)uae);
            throw new SecurityException(bundle.getString("SASLFailure"));
        }
    }

    private boolean isLibertyMessage(SOAPMessage soapMessage) throws SecurityException {
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            if (soapHeader == null) {
                return false;
            }
            NodeList headerChildNodes = soapHeader.getChildNodes();
            if (headerChildNodes == null || headerChildNodes.getLength() == 0) {
                return false;
            }
            for (int i = 0; i < headerChildNodes.getLength(); ++i) {
                Node currentNode = headerChildNodes.item(i);
                if (currentNode.getNodeType() != 1 || !"Correlation".equals(currentNode.getLocalName()) || !"urn:liberty:sb:2003-08".equals(currentNode.getNamespaceURI())) continue;
                return true;
            }
            return false;
        }
        catch (SOAPException se) {
            debug.error("SOAPRequest.isLibertyRequest:: SOAPException", (Throwable)se);
            throw new SecurityException(se.getMessage());
        }
    }

    private ProviderConfig getProviderConfig(Map sharedMap) {
        if (sharedMap == null || sharedMap.isEmpty()) {
            return null;
        }
        try {
            String serviceName = ThreadLocalService.getServiceName();
            if (serviceName == null) {
                serviceName = this.getServiceName(sharedMap);
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getServiceName: Service Name from javax.xml.ws.wsdl.service : " + serviceName);
                }
            } else {
                if (debug.messageEnabled()) {
                    debug.message("SOAPRequestHandler.getProviderConfig: Service Name found in thread local" + serviceName);
                }
                ThreadLocalService.removeServiceName(serviceName);
                STSConfig stsConfig = (STSConfig)TrustAuthorityConfig.getConfig(serviceName, "STSAgent");
                ProviderConfig pc = ProviderConfig.getProvider(serviceName, "WSCAgent");
                pc.setSecurityMechanisms(stsConfig.getSecurityMech());
                pc.setRequestSignEnabled(stsConfig.isRequestSignEnabled());
                pc.setRequestEncryptEnabled(stsConfig.isRequestEncryptEnabled());
                pc.setDefaultKeyStore(true);
                pc.setUsers(stsConfig.getUsers());
                pc.setWSPEndpoint(stsConfig.getEndpoint());
                pc.setKDCDomain(stsConfig.getKDCDomain());
                pc.setKDCServer(stsConfig.getKDCServer());
                pc.setKerberosServicePrincipal(pc.getKerberosServicePrincipal());
                pc.setKerberosTicketCacheDir(stsConfig.getKerberosTicketCacheDir());
                pc.setEncryptionAlgorithm(stsConfig.getEncryptionAlgorithm());
                pc.setEncryptionStrength(stsConfig.getEncryptionStrength());
                pc.setSigningRefType(stsConfig.getSigningRefType());
                pc.setSAMLAttributeMapping(stsConfig.getSAMLAttributeMapping());
                pc.setSAMLAttributeNamespace(stsConfig.getSAMLAttributeNamespace());
                pc.setIncludeMemberships(stsConfig.shouldIncludeMemberships());
                pc.setNameIDMapper(stsConfig.getNameIDMapper());
                return pc;
            }
            if (!ProviderConfig.isProviderExists(serviceName, "WSCAgent")) {
                return null;
            }
            ProviderConfig config = ProviderConfig.getProvider(serviceName, "WSCAgent");
            if (!config.useDefaultKeyStore()) {
                this.initializeSystemProperties(config);
            }
            return config;
        }
        catch (ProviderException pe) {
            WSSUtils.debug.error("SOAPRequestHandler.getProviderConfig: fromshared map: Exception", (Throwable)pe);
            return null;
        }
        catch (IOException ie) {
            WSSUtils.debug.error("SOAPRequestHandler.getProviderConfig: fromshared map: IOException", (Throwable)ie);
            return null;
        }
    }

    private String getServiceName(Map sharedMap) {
        if (sharedMap == null || sharedMap.isEmpty()) {
            return null;
        }
        QName service = (QName)sharedMap.get("javax.xml.ws.wsdl.service");
        if (service == null) {
            return null;
        }
        return service.getLocalPart();
    }

    public String print(Node node) {
        return WSSUtils.print(node);
    }

    private void removeValidatedHeaders(ProviderConfig config, SOAPMessage soapMessage) {
        SOAPHeader header = null;
        try {
            header = soapMessage.getSOAPPart().getEnvelope().getHeader();
        }
        catch (SOAPException se) {
            WSSUtils.debug.error("SOAPRequestHandler.removeValidateHeaders: Failed to read the SOAP Header.");
        }
        if (header != null) {
            Iterator iter = header.examineAllHeaderElements();
            while (iter.hasNext()) {
                SOAPHeaderElement headerElement = (SOAPHeaderElement)iter.next();
                if ((config == null || !config.preserveSecurityHeader()) && "Security".equalsIgnoreCase(headerElement.getElementName().getLocalName())) {
                    headerElement.detachNode();
                }
                if (!"Correlation".equalsIgnoreCase(headerElement.getElementName().getLocalName())) continue;
                headerElement.detachNode();
            }
        }
    }

    private ProviderConfig getSTSProviderConfig(STSRemoteConfig stsConfig) throws SecurityException {
        if (stsConfig == null) {
            return null;
        }
        try {
            ProviderConfig pc = ProviderConfig.getProvider(stsConfig.getIssuer(), "WSPAgent", false);
            pc.setKDCDomain(stsConfig.getKDCDomain());
            pc.setKDCServer(stsConfig.getKDCServer());
            pc.setKerberosServicePrincipal(stsConfig.getKerberosServicePrincipal());
            pc.setKeyTabFile(stsConfig.getKeyTabFile());
            pc.setValidateKerberosSignature(stsConfig.isValidateKerberosSignature());
            pc.setSecurityMechanisms(stsConfig.getSecurityMechanisms());
            pc.setUsers(stsConfig.getUsers());
            pc.setRequestEncryptEnabled(stsConfig.isRequestEncryptEnabled());
            pc.setRequestHeaderEncryptEnabled(stsConfig.isRequestHeaderEncryptEnabled());
            pc.setRequestSignEnabled(stsConfig.isRequestSignEnabled());
            pc.setResponseEncryptEnabled(stsConfig.isResponseEncryptEnabled());
            pc.setResponseSignEnabled(stsConfig.isResponseSignEnabled());
            pc.setPreserveSecurityHeader(false);
            pc.setPublicKeyAlias(stsConfig.getPublicKeyAlias());
            pc.setKeyAlias(stsConfig.getPrivateKeyAlias());
            pc.setEncryptionAlgorithm(stsConfig.getEncryptionAlgorithm());
            pc.setEncryptionStrength(stsConfig.getEncryptionStrength());
            pc.setSigningRefType(stsConfig.getSigningRefType());
            pc.setAuthenticationChain(stsConfig.getAuthenticationChain());
            pc.setDetectUserTokenReplay(stsConfig.isUserTokenDetectReplayEnabled());
            pc.setMessageReplayDetection(stsConfig.isMessageReplayDetectionEnabled());
            return pc;
        }
        catch (ProviderException pe) {
            throw new SecurityException(pe.getMessage());
        }
    }

    private SecurityToken getSecurityTokenFromSubject(Subject subj) throws SecurityException {
        Object obj;
        SecurityToken securityToken = null;
        Subject subject = subj;
        if (subject.getPublicCredentials().isEmpty() && (obj = ThreadLocalService.getSubject()) != null) {
            subject = (Subject)obj;
        }
        for (Object obj2 : subject.getPublicCredentials()) {
            String ns;
            Element tokenE;
            if (!(obj2 instanceof Element) || !(tokenE = (Element)obj2).getLocalName().equals("Assertion") || (ns = tokenE.getNamespaceURI()) == null) continue;
            try {
                if (ns.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    securityToken = new AssertionToken(tokenE);
                    continue;
                }
                if (!ns.equals("urn:oasis:names:tc:SAML:2.0:assertion")) continue;
                securityToken = new SAML2Token(tokenE);
            }
            catch (Exception ex) {
                WSSUtils.debug.error("SOAPRequestHandler.getSecurityTokenFromSubject:: exception", (Throwable)ex);
                throw new SecurityException(ex.getMessage());
            }
        }
        return securityToken;
    }

    private Subject getAuthenticatedSubject() {
        Subject subject = (Subject)ThreadLocalService.getSubject();
        if (subject == null) {
            return null;
        }
        if (!subject.getPrivateCredentials().isEmpty()) {
            return subject;
        }
        return null;
    }

    private Object getCustomCredential(Subject subject) {
        Set<Object> creds = subject.getPublicCredentials();
        if (creds == null || creds.isEmpty()) {
            return null;
        }
        for (Object obj : creds) {
            Map map;
            if (!(obj instanceof Map) || !(map = (Map)obj).containsKey("CustomToken")) continue;
            return map.get("CustomToken");
        }
        return null;
    }

    private List getUserCredentialsFromSSOToken(SSOToken ssoToken) {
        if (ssoToken == null) {
            if (debug.messageEnabled()) {
                debug.message("SOAPRequestHandler.getUserCredentialsFromSSOToken. ssotoken is null");
            }
            return null;
        }
        try {
            if (SSOTokenManager.getInstance().isValidToken(ssoToken)) {
                String password = null;
                boolean useHashedPassword = Boolean.valueOf(SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.security.useHashedPassword", (String)"true"));
                if (useHashedPassword) {
                    password = ssoToken.getProperty("HashedUserPassword");
                } else {
                    String encryptedPassword = ssoToken.getProperty("EncryptedUserPassword");
                    if (encryptedPassword == null) {
                        if (debug.messageEnabled()) {
                            debug.message("SOAPRequestHandler.getUserCredentialsFromSSOToken. encrypted password is null");
                        }
                        return null;
                    }
                    password = Crypt.decrypt((String)encryptedPassword);
                }
                if (password == null) {
                    if (debug.messageEnabled()) {
                        debug.message("SOAPRequestHandler.getUserCredentialsFromSSOToken. password is null");
                    }
                    return null;
                }
                String userId = ssoToken.getProperty("UserId");
                ArrayList<PasswordCredential> list = new ArrayList<PasswordCredential>();
                PasswordCredential pc = new PasswordCredential(userId, password);
                list.add(pc);
                return list;
            }
        }
        catch (SSOException se) {
            if (debug.warningEnabled()) {
                debug.warning("SOAPRequestHandler.getUserCredentialsFromSSOToken. ssoexception", (Throwable)se);
            }
            return null;
        }
        return null;
    }

    private boolean checkForReplay(String msgID, String wsp) {
        if (msgID == null) {
            return false;
        }
        PeriodicCleanUpMap messageIDMap = WSSCache.messageIDMap;
        long stale_limit = WSSCache.cacheTimeoutInterval * 1000;
        WSSCacheRepository cacheRepo = WSSUtils.getWSSCacheRepository();
        Long prevMsgIDTime = (Long)messageIDMap.get(msgID);
        if (prevMsgIDTime == null && cacheRepo != null) {
            prevMsgIDTime = cacheRepo.retrieveMessageTimestamp(msgID, wsp);
        }
        long currentTime = System.currentTimeMillis();
        if (prevMsgIDTime != null && currentTime - prevMsgIDTime < stale_limit) {
            if (WSSUtils.debug.warningEnabled()) {
                WSSUtils.debug.warning("SOAPRequestHandler.checkForReplay: replay attack detected");
            }
            return true;
        }
        messageIDMap.put(msgID, new Long(currentTime));
        if (cacheRepo != null) {
            cacheRepo.saveMessageTimestamp(msgID, new Long(currentTime), wsp);
        }
        return false;
    }

    private boolean checkForReplay(Subject subject, long msgTimestamp, String wsp) {
        Iterator<Principal> iter = subject.getPrincipals().iterator();
        Principal principal = iter.next();
        String replayIndexStr = principal.getName() + new Long(msgTimestamp).toString();
        return this.checkForReplay(replayIndexStr, wsp);
    }

    private class SubjectSecurity {
        SSOToken ssoToken = null;
        ResourceOffering discoRO = null;
        List discoCredentials = null;
        List userCredentials = null;

        private SubjectSecurity() {
        }
    }
}

