/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.Logger;
import com.sun.identity.log.messageid.LogMessageProvider;
import com.sun.identity.log.messageid.MessageProviderFactory;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.logging.Level;

public class LogWriter {
    private static final String LOG_MSG_XML = "CLI";
    public static final int LOG_ACCESS = 0;
    public static final int LOG_ERROR = 1;

    private LogWriter() {
    }

    public static void log(CommandManager mgr, int type, Level level, String msgid, String[] msgdata, SSOToken ssoToken) throws CLIException {
        if (!mgr.isLogOff()) {
            Logger logger = null;
            String logName = mgr.getLogName();
            switch (type) {
                case 1: {
                    logger = (Logger)Logger.getLogger(logName + ".error");
                    break;
                }
                default: {
                    logger = (Logger)Logger.getLogger(logName + ".access");
                }
            }
            if (logger.isLoggable(level)) {
                try {
                    LogRecord logRec;
                    LogMessageProvider msgProvider = MessageProviderFactory.getProvider(LOG_MSG_XML);
                    SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    if (ssoToken == null) {
                        ssoToken = adminSSOToken;
                    }
                    if ((logRec = msgProvider.createLogRecord(msgid, msgdata, ssoToken)) != null) {
                        logger.log(logRec, adminSSOToken);
                    }
                }
                catch (Exception e) {
                    throw new CLIException(e, 25);
                }
            }
        }
    }
}

