/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Set;
import java.util.logging.Level;

public class GetSupportedDataTypes
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        this.writeLog(0, Level.INFO, "ATTEMPT_GET_SUPPORTED_DATA_TYPES", null);
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager("sunIdentityRepositoryService", adminSSOToken);
            ServiceSchema orgSchema = scm.getOrganizationSchema();
            Set names = orgSchema.getSubSchemaNames();
            if (names != null && !names.isEmpty()) {
                for (String name : names) {
                    outputWriter.printlnMessage(name);
                }
            } else {
                outputWriter.printlnMessage(this.getResourceString("get-supported-no-supported-datatype"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_GET_SUPPORTED_DATA_TYPES", null);
        }
        catch (SSOException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("GetSupportedDataTypes.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_GET_SUPPORTED_DATA_TYPES", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{e.getMessage()};
            this.debugError("GetSupportedDataTypes.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_GET_SUPPORTED_DATA_TYPES", args);
            throw new CLIException(e, 127);
        }
    }
}

