/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.KeyIdentifier;
import com.sun.identity.wss.security.Reference;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.keys.content.X509Data;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xpath.internal.XPathAPI;
import java.util.ResourceBundle;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityTokenReference {
    public static final String KEYIDENTIFIER_REFERENCE = "KeyIdentifierRef";
    public static final String DIRECT_REFERENCE = "DirectReference";
    public static final String X509DATA_REFERENCE = "X509IssuerSerialRef";
    private Reference reference;
    private KeyIdentifier keyIdentifier;
    private X509Data x509Data;
    private String referenceType;
    private String id = null;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static Debug debug = WSSUtils.debug;

    public SecurityTokenReference() {
        this.id = SAMLUtils.generateID();
    }

    public SecurityTokenReference(Element element) throws SecurityException {
        if (element == null) {
            throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
        }
        if (!"SecurityTokenReference".equals(element.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(element.getNamespaceURI())) {
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        NodeList childs = element.getChildNodes();
        if (childs == null || childs.getLength() == 0) {
            debug.error("SecurityTokenReference.No references found");
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        for (int i = 0; i < childs.getLength(); ++i) {
            Node child = childs.item(i);
            if (child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if ("Reference".equals(childName)) {
                this.reference = new Reference((Element)child);
                this.referenceType = DIRECT_REFERENCE;
                continue;
            }
            if ("KeyIdentifier".equals(childName)) {
                this.keyIdentifier = new KeyIdentifier((Element)child);
                this.referenceType = KEYIDENTIFIER_REFERENCE;
                continue;
            }
            if (!"X509Data".equals(childName)) continue;
            try {
                this.x509Data = new X509Data((Element)child, null);
            }
            catch (XMLSecurityException xe) {
                debug.error("SecurityTokenReference. invalid x509 data", (Throwable)xe);
                throw new SecurityException(bundle.getString("invalidElement"));
            }
            this.referenceType = X509DATA_REFERENCE;
        }
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
        this.referenceType = DIRECT_REFERENCE;
    }

    public void setKeyIdentifier(KeyIdentifier keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        this.referenceType = KEYIDENTIFIER_REFERENCE;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public X509Data getX509IssuerSerial() {
        return this.x509Data;
    }

    public void setX509IssuerSerial(X509Data x509Data) {
        this.x509Data = x509Data;
        this.referenceType = X509DATA_REFERENCE;
    }

    public Element getTokenElement(Document doc) throws SecurityException {
        Reference ref = this.getReference();
        String uri = ref.getURI();
        if (uri.length() == 0 || uri.charAt(0) != '#') {
            return null;
        }
        uri = uri.substring(1);
        Element tokenElement = null;
        String valueType = ref.getValueType();
        try {
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID".equals(valueType)) {
                tokenElement = (Element)XPathAPI.selectSingleNode(doc, "//*[@AssertionID=\"" + uri + "\"]");
            } else if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID".equals(valueType)) {
                tokenElement = (Element)XPathAPI.selectSingleNode(doc, "//*[@ID=\"" + uri + "\"]");
            } else {
                Element nscontext = XMLUtils.createDSctx((Document)doc, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                tokenElement = (Element)XPathAPI.selectSingleNode(doc, "//*[@wsu:Id=\"" + uri + "\"]");
            }
            return tokenElement;
        }
        catch (TransformerException te) {
            debug.error("SecurityTokenReference.getTokenElement: XPath exception.", (Throwable)te);
            throw new SecurityException(te.getMessage());
        }
    }

    public void addToParent(Element parent) throws SecurityException {
        try {
            if (parent == null) {
                throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
            }
            Document doc = parent.getOwnerDocument();
            Element securityTokenRef = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
            securityTokenRef.setPrefix("wsse");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            securityTokenRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            securityTokenRef.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", this.id);
            if (this.reference != null) {
                this.reference.addToParent(securityTokenRef);
            }
            if (this.keyIdentifier != null) {
                this.keyIdentifier.addToParent(securityTokenRef);
            }
            parent.appendChild(securityTokenRef);
        }
        catch (Exception ex) {
            debug.error("SecurityTokenReference.addToParent::can not add to parent", (Throwable)ex);
            throw new SecurityException(bundle.getString("cannotAddElement"));
        }
    }
}

