/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.sun.identity.common.PeriodicCleanUpMap;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.wss.security.WSSUtils;
import java.util.Date;

public class WSSCache {
    static int cacheTimeoutInterval;
    static int cacheCleanupInterval;
    static PeriodicCleanUpMap messageIDMap;
    static PeriodicCleanUpMap nonceCache;

    static {
        block4: {
            cacheTimeoutInterval = 300;
            cacheCleanupInterval = 60;
            messageIDMap = null;
            nonceCache = null;
            String intervalStr = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.security.cache.cleanup.interval");
            String tmpStr = SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.security.cache.timeout.interval");
            try {
                if (intervalStr != null && intervalStr.length() != 0) {
                    cacheCleanupInterval = Integer.parseInt(intervalStr);
                }
                if (tmpStr != null && tmpStr.length() != 0) {
                    cacheTimeoutInterval = Integer.parseInt(tmpStr);
                }
            }
            catch (NumberFormatException e) {
                if (!WSSUtils.debug.messageEnabled()) break block4;
                WSSUtils.debug.message("WSSCache static: invalid cleanup interval. Using default.");
            }
        }
        nonceCache = new PeriodicCleanUpMap((long)(cacheCleanupInterval * 1000), (long)(cacheTimeoutInterval * 1000));
        messageIDMap = new PeriodicCleanUpMap((long)(cacheCleanupInterval * 1000), (long)(cacheTimeoutInterval * 1000));
        SystemTimerPool.getTimerPool().schedule((TaskRunnable)nonceCache, new Date(System.currentTimeMillis() + (long)cacheCleanupInterval));
        SystemTimerPool.getTimerPool().schedule((TaskRunnable)messageIDMap, new Date(System.currentTimeMillis() + (long)cacheCleanupInterval));
    }
}

