/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.cdm;

import com.iplanet.am.util.QCharset;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ICDMConstants;
import com.iplanet.services.cdm.clientschema.AMClientCapData;
import com.iplanet.services.cdm.clientschema.AMClientCapException;
import com.iplanet.services.cdm.clientschema.AMClientDataListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;

public class G11NSettings
implements ServiceListener,
ICDMConstants,
AMClientDataListener {
    private Map rawServiceData = null;
    private static G11NSettings currInstance = null;
    private static Debug debug = null;
    private ServiceSchemaManager serviceSchemaManager = null;
    private Map localeCharset = new TreeMap();
    private Map charsetAlias = new TreeMap();
    private Map charsetCache = new HashMap();
    private static AMClientCapData intCapInstance = null;
    private static AMClientCapData extCapInstance = null;

    public static G11NSettings getInstance() {
        return currInstance;
    }

    public String getDefaultCharsetForLocale(Locale loc) {
        List result = this.getCharsetForLocale(loc.toString());
        if (result != null && !result.isEmpty()) {
            return result.iterator().next().toString();
        }
        String lang = loc.getLanguage();
        String country = loc.getCountry();
        if (country != null && country.length() > 0 && (result = this.getCharsetForLocale(lang + "_" + country)) != null && !result.isEmpty()) {
            return result.iterator().next().toString();
        }
        if (lang != null && lang.length() > 0 && (result = this.getCharsetForLocale(lang)) != null && !result.isEmpty()) {
            return result.iterator().next().toString();
        }
        return "UTF-8";
    }

    public List getCharsetForLocale(String loc) {
        if (debug.messageEnabled()) {
            debug.message("G11NSettings::Getcharsetforlocale" + loc);
            debug.message("returns " + this.localeCharset.get(loc));
        }
        return (List)this.localeCharset.get(loc);
    }

    public Map getCharsetAliasTable(String mimeCharset) {
        return (Map)this.charsetAlias.get(mimeCharset);
    }

    public String getJavaCharset(String mimeCharset) {
        Map charMap = (Map)this.charsetAlias.get(mimeCharset);
        if (charMap == null) {
            return mimeCharset;
        }
        String val = (String)charMap.get("javaname");
        if (val == null || val.length() == 0) {
            if (debug.messageEnabled()) {
                debug.message("Unable to find java charset for " + mimeCharset);
            }
            return mimeCharset;
        }
        if (debug.messageEnabled()) {
            debug.message("javacharset(" + mimeCharset + ")=" + val);
        }
        return val;
    }

    public void schemaChanged(String serviceName, String version) {
        if (debug.messageEnabled()) {
            debug.message("Schema change serviceName = " + serviceName + "\tversion = " + version + "\tinitializing ...");
        }
        if (serviceName.equals("iPlanetG11NSettings")) {
            this.localeCharset.clear();
            this.charsetAlias.clear();
            this.charsetCache.clear();
            this.initializeService();
        }
        if (debug.messageEnabled()) {
            debug.message("G11NSettings init  complete");
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    public String getCharset(String clientType, Locale loc) throws ClientException {
        Client client = Client.getInstance(clientType);
        String result = this.fetchCharsetFromCache(client, loc);
        if (result != null && result.length() > 0) {
            return result;
        }
        result = this.fetchCharset(client, loc);
        HashMap<Locale, String> cCache = (HashMap<Locale, String>)this.charsetCache.get(client.getClientType());
        if (cCache == null) {
            cCache = new HashMap<Locale, String>(3);
            this.charsetCache.put(clientType, cCache);
        }
        if (debug.messageEnabled()) {
            debug.message("getCharset() for clientType = " + clientType + "\tlocale=" + loc + "\tcharset = " + result);
        }
        cCache.put(loc, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientChanged(String clientType, int dbType, int opType) {
        if (debug.messageEnabled()) {
            debug.message("G11nSettings::clientChanged() NOTIFICATION: clientType = " + clientType + " :DB = " + dbType + " : Op = " + opType);
        }
        if (clientType == null || clientType.length() == 0) {
            return;
        }
        Map map = this.charsetCache;
        synchronized (map) {
            switch (opType) {
                case 2: {
                    Iterator it = this.charsetCache.keySet().iterator();
                    while (it.hasNext()) {
                        String ctype = (String)it.next();
                        if (!ctype.equalsIgnoreCase(clientType)) continue;
                        it.remove();
                        break;
                    }
                    return;
                }
                case 1: {
                    return;
                }
                case 4: {
                    this.charsetCache.remove(clientType);
                    return;
                }
            }
            debug.error("ClientSchema modification unknown opType" + opType);
        }
    }

    private G11NSettings() {
        this.initializeService();
        if (this.serviceSchemaManager != null) {
            this.serviceSchemaManager.addListener(this);
        }
        if (ServiceManager.isAMSDKEnabled()) {
            try {
                intCapInstance = AMClientCapData.getInternalInstance();
                intCapInstance.addListener(this);
                extCapInstance = AMClientCapData.getExternalInstance();
                extCapInstance.addListener(this);
            }
            catch (AMClientCapException ce) {
                debug.error("Unable to get an instance Of ClientData in G11Nsettings", (Throwable)ce);
            }
        }
    }

    private void initializeService() {
        try {
            int i;
            this.readServiceConfig();
            Object[] cTypes = ((Set)this.rawServiceData.get("sun-identity-g11n-settings-locale-charset-mapping")).toArray();
            for (i = 0; i < cTypes.length; ++i) {
                this.createLocaleEntry((String)cTypes[i]);
            }
            cTypes = ((Set)this.rawServiceData.get("sun-identity-g11n-settings-charset-alias-mapping")).toArray();
            for (i = 0; i < cTypes.length; ++i) {
                this.createCharsetAliasEntry((String)cTypes[i]);
            }
        }
        catch (SSOException ex) {
            debug.error("Unable to get internal SSOToken for locale attribute ", (Throwable)((Object)ex));
        }
        catch (SMSException ex) {
            debug.error("Unable to get  locale attribute value", (Throwable)ex);
        }
    }

    private void readServiceConfig() throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("G11Settings::ReadServiceConfig");
        }
        SSOToken internalToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        this.serviceSchemaManager = new ServiceSchemaManager("iPlanetG11NSettings", internalToken);
        ServiceSchema gsc = this.serviceSchemaManager.getGlobalSchema();
        this.rawServiceData = gsc.getAttributeDefaults();
    }

    private void createCharsetAliasEntry(String val) {
        StringTokenizer tok1 = new StringTokenizer(val, "|");
        String mimeCharsetName = null;
        HashMap<String, String> charsetNameList = new HashMap<String, String>();
        while (tok1.hasMoreElements()) {
            String element = tok1.nextToken();
            StringTokenizer pairTok = new StringTokenizer(element, "=");
            if (pairTok.countTokens() != 2) continue;
            String key = pairTok.nextToken();
            key = key.trim();
            String value = pairTok.nextToken().trim();
            if (key.equalsIgnoreCase("mimeName")) {
                mimeCharsetName = value.toUpperCase();
                continue;
            }
            charsetNameList.put(key.toLowerCase(), value.toUpperCase());
        }
        if (mimeCharsetName != null) {
            this.charsetAlias.put(mimeCharsetName, charsetNameList);
            if (debug.messageEnabled()) {
                debug.message("Building alias name for " + mimeCharsetName);
                Set keys = charsetNameList.keySet();
                for (String x : keys) {
                    debug.message("name = " + x + " value = " + charsetNameList.get(x));
                }
            }
        }
    }

    private void createLocaleEntry(String val) {
        StringTokenizer tok1 = new StringTokenizer(val, "|");
        String localeValue = null;
        LinkedList<String> charsetList = null;
        while (tok1.hasMoreElements()) {
            String element = tok1.nextToken();
            StringTokenizer pairTok = new StringTokenizer(element, "=");
            if (pairTok.countTokens() != 2) continue;
            String key = pairTok.nextToken();
            key = key.trim();
            String value = pairTok.nextToken();
            if (key.equalsIgnoreCase("locale")) {
                localeValue = value.toLowerCase();
            }
            int charsetCount = 0;
            if (!key.equalsIgnoreCase("charset")) continue;
            charsetList = new LinkedList<String>();
            StringTokenizer charsetTokenizer = new StringTokenizer(value, ";");
            while (charsetTokenizer.hasMoreElements()) {
                String charsetVal = charsetTokenizer.nextToken();
                charsetList.add(charsetVal);
                ++charsetCount;
            }
        }
        if (charsetList != null && localeValue != null) {
            this.localeCharset.put(localeValue, charsetList);
            if (debug.messageEnabled()) {
                debug.message("G11NSettings Locale = " + localeValue + "\tAllowed charset are " + charsetList);
            }
        }
    }

    private String fetchCharsetFromCache(Client client, Locale loc) {
        Map cCache = (Map)this.charsetCache.get(client.getClientType());
        String val = null;
        if (cCache != null) {
            val = (String)cCache.get(loc);
        }
        return val;
    }

    private synchronized String fetchCharset(Client client, Locale loc) {
        String result = null;
        result = this.fetchCharsetFromCache(client, loc);
        if (result != null && result.length() > 0) {
            return result;
        }
        Set charsets = client.getProperties("CcppAccept-Charset");
        if (charsets == null && (result = this.getCharsetLegacy(client, loc)) != null && result.length() > 0) {
            return result;
        }
        TreeSet<QCharset> sortedCharset = new TreeSet<QCharset>();
        if (charsets != null) {
            for (String charsetName : charsets) {
                if (charsetName.indexOf(";") >= 0) {
                    StringTokenizer tok1 = new StringTokenizer(charsetName, ";");
                    if (tok1.countTokens() != 2) {
                        debug.error("G11NSettings::fetchcharSet () Unable toparse charset entry " + charsetName);
                        break;
                    }
                    String cname = tok1.nextToken();
                    String qval = tok1.nextToken();
                    StringTokenizer tok2 = new StringTokenizer(qval, "=");
                    if (tok2.countTokens() != 2) {
                        debug.error("G11NSettings::fetchcharSet ()Unable to parse qvalue of charset entry " + qval);
                        break;
                    }
                    String tname = tok2.nextToken();
                    if (tname.length() > 1 || !tname.equalsIgnoreCase("q")) {
                        debug.error("G11NSettings::Fetchcharset() Unable toparse  charset entry invalid Q " + tname);
                        break;
                    }
                    String tval = tok2.nextToken();
                    try {
                        float fval = Float.parseFloat(tval);
                        sortedCharset.add(new QCharset(cname, fval));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        debug.error("G11NSettings::fetchcharSet () unableto parse q factor", (Throwable)ex);
                        break;
                    }
                }
                sortedCharset.add(new QCharset(charsetName));
            }
            if (debug.messageEnabled()) {
                Iterator it = sortedCharset.iterator();
                while (it.hasNext()) {
                    debug.message("G11NSettings.fetchCharset()ccpp-accept-charset order = " + it.next().toString());
                }
            }
        }
        String lang = loc.getLanguage();
        String country = loc.getCountry();
        String variant = loc.getVariant();
        String key = lang.toLowerCase();
        if (country != null && country.length() != 0) {
            key = key + "_" + country.toLowerCase();
        }
        if (variant != null && variant.length() != 0) {
            key = key + "_" + variant.toLowerCase();
        }
        if ((result = this.locateCharset(key, sortedCharset)) != null && result.length() > 0) {
            return result;
        }
        if (country != null && country.length() != 0 && (result = this.locateCharset(lang + "_" + country, sortedCharset)) != null) {
            if (debug.messageEnabled()) {
                debug.message("charset located for " + lang + "_" + country);
            }
            return result;
        }
        if (lang != null && lang.length() != 0 && (result = this.locateCharset(lang, sortedCharset)) != null) {
            if (debug.messageEnabled()) {
                debug.message("charset located for " + lang);
            }
            return result;
        }
        if (debug.messageEnabled()) {
            debug.message("unable to locate charset for " + loc);
        }
        return "ISO-8859-1";
    }

    private String locateCharset(String key, Set charsets) {
        if (charsets == null) {
            return null;
        }
        String res = null;
        List supCharset = this.getCharsetForLocale(key);
        if (supCharset == null) {
            return null;
        }
        for (QCharset idc : charsets) {
            String id = idc.getName();
            if (id.equals("*")) {
                res = (String)supCharset.get(0);
                break;
            }
            for (String cname : supCharset) {
                if (!cname.equalsIgnoreCase(id)) continue;
                res = id;
                break;
            }
            if (res == null) continue;
            break;
        }
        return res;
    }

    private String getCharsetLegacy(Client client, Locale loc) {
        StringBuffer key = new StringBuffer("charset_");
        int locLen = key.length();
        String lang = loc.getLanguage();
        String country = loc.getCountry();
        if (country == null || country.length() == 0) {
            key.append(lang);
        } else {
            key.append(lang).append('_').append(country);
        }
        String result = client.getProperty(key.toString());
        if (result != null) {
            return result;
        }
        key.setLength(locLen);
        key.append(lang);
        result = client.getProperty(key.toString());
        if (result != null) {
            return result;
        }
        key.setLength(locLen - 1);
        result = client.getProperty(key.toString());
        return result;
    }

    static {
        debug = Debug.getInstance((String)"amClientDetection");
        currInstance = new G11NSettings();
    }
}

