/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceNotFoundException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;

public class AuthServiceListener
implements ServiceListener {
    static Debug debug = Debug.getInstance((String)"amAuth");
    protected static final String AUTHCONFIG_SERVICE = "iPlanetAMAuthConfiguration";
    private static Map serviceAttributeCache = new HashMap();
    private static AuthServiceListener serviceListener = new AuthServiceListener();

    private AuthServiceListener() {
    }

    public static Map getServiceAttributeCache(String orgDN, String serviceName) {
        Map retVal = (Map)serviceAttributeCache.get(serviceName + "," + orgDN);
        if (debug.messageEnabled()) {
            debug.message("AuthServiceListener.getServiceAttributeCache(): Returning from cache = " + retVal + ", orgDN=" + orgDN);
        }
        return retVal;
    }

    public static void setServiceAttributeCache(String orgDN, String serviceName, Map serviceAttributes) {
        serviceAttributeCache.put(serviceName + "," + orgDN, serviceAttributes);
        if (debug.messageEnabled()) {
            debug.message("AuthServiceListener.setServiceAttributeCache(): Cache after add= " + serviceAttributeCache + ", orgDN=" + orgDN);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String goupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AuthServiceListener.organizationConfigChanged : Config changed for Org=" + orgName + "Service = " + serviceName + " Change type = " + type);
        }
        if (type != 1) {
            serviceAttributeCache.remove(serviceName + "," + orgName);
        }
    }

    static {
        SSOToken ssot = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        try {
            ServiceConfigManager scm = new ServiceConfigManager(AUTHCONFIG_SERVICE, ssot);
            scm.addListener(serviceListener);
            debug.message("AuthServiceListener: Listener added.");
        }
        catch (ServiceNotFoundException exp) {
            debug.error("AuthServiceListener: Can not register Listener", (Throwable)exp);
        }
        catch (SMSException smsExp) {
            debug.error("AuthServiceListener: Can not register Listener", (Throwable)smsExp);
        }
        catch (SSOException ssoExp) {
            debug.error("AuthServiceListener: Can not register Listener", (Throwable)((Object)ssoExp));
        }
    }
}

