/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.idm;

import com.iplanet.am.util.Locale;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.idm.EntityServicesViewBean;
import com.sun.identity.console.idm.ServicesAddViewBean;
import com.sun.identity.console.idm.model.EntitiesModel;
import com.sun.identity.console.idm.model.EntitiesModelImpl;
import com.sun.identity.console.service.model.SCUtils;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServicesSelectViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/idm/ServicesSelect.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String ATTR_SERVICE_LIST = "cbServiceList";
    private CCPageTitleModel ptModel;
    private AMPropertySheetModel propertySheetModel;
    private boolean submitCycle;

    public ServicesSelectViewBean() {
        super("ServicesSelect");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createPropertyModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.next");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        this.propertySheetModel = new AMPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyEntityServicesSelect.xml"));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new EntitiesModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.disableButton("button1", true);
        CCRadioButton rb = (CCRadioButton)this.getChild(ATTR_SERVICE_LIST);
        this.setRadioButtons(rb);
    }

    private void setRadioButtons(CCRadioButton rb) {
        try {
            EntitiesModel model = (EntitiesModel)this.getModel();
            String universalId = (String)this.getPageSessionAttribute("universalId");
            Map assigned = model.getAssignedServiceNames(universalId);
            Map assignables = model.getAssignableServiceNames(universalId);
            Iterator i = assigned.keySet().iterator();
            while (i.hasNext()) {
                assignables.remove(i.next());
            }
            if (!assignables.isEmpty()) {
                OptionList optList = AMFormatUtils.getSortedOptionList(assignables, model.getUserLocale());
                rb.setOptions(optList);
                if (!this.submitCycle) {
                    rb.setValue((Object)optList.getValue(0));
                }
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.forwardToEntityServiceViewBean();
    }

    private void forwardToEntityServiceViewBean() {
        EntityServicesViewBean vb = (EntityServicesViewBean)this.getViewBean(EntityServicesViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        String serviceName = (String)this.getDisplayFieldValue(ATTR_SERVICE_LIST);
        String universalId = (String)this.getPageSessionAttribute("universalId");
        EntitiesModel model = (EntitiesModel)this.getModel();
        if (model.hasUserAttributeSchema(serviceName)) {
            this.unlockPageTrailForSwapping();
            this.fowardToAddServiceViewBean(model, universalId, serviceName);
        } else {
            try {
                model.assignService(universalId, serviceName, Collections.EMPTY_MAP);
                this.forwardToEntityServiceViewBean();
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        }
    }

    private void fowardToAddServiceViewBean(EntitiesModel model, String universalId, String serviceName) {
        SCUtils utils = new SCUtils(serviceName, model);
        String propertiesViewBeanURL = utils.getServiceDisplayURL();
        String type = (String)this.getPageSessionAttribute("entityTypeName");
        String realm = (String)this.getPageSessionAttribute("currentRealm");
        if (realm == null) {
            realm = "/";
        }
        if (serviceName.equals("iPlanetAMAuthConfiguration")) {
            propertiesViewBeanURL = null;
        }
        if (propertiesViewBeanURL != null && propertiesViewBeanURL.trim().length() > 0) {
            try {
                String charset = this.getCharset(model);
                propertiesViewBeanURL = propertiesViewBeanURL + "?ServiceName=" + serviceName + "&type=" + Locale.URLEncodeField(type, charset) + "&realm=" + Locale.URLEncodeField(ServicesSelectViewBean.stringToHex(realm), charset) + "&User=" + Locale.URLEncodeField(ServicesSelectViewBean.stringToHex(universalId), charset) + "&Op=" + "add";
                HttpServletResponse response = this.getRequestContext().getResponse();
                response.sendRedirect(propertiesViewBeanURL);
            }
            catch (UnsupportedEncodingException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
            catch (IOException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            ServicesAddViewBean vb = (ServicesAddViewBean)this.getViewBean(ServicesAddViewBean.class);
            this.setPageSessionAttribute("serviceName", (Serializable)((Object)serviceName));
            this.passPgSessionMap((ViewBean)vb);
            vb.forwardTo(this.getRequestContext());
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.editentities.selectservice";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

