/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.DNUtils;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.SMServiceListener;
import com.sun.identity.delegation.interfaces.DelegationInterface;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DelegationEvaluator {
    static final Debug debug = DelegationManager.debug;
    private static AMIdentity privilegedUser;
    private static boolean installTime;
    static Set adminUserSet;
    static AMIdentity adminUserId;
    private DelegationInterface pluginInstance = null;

    public DelegationEvaluator() throws DelegationException {
        if (debug.messageEnabled()) {
            debug.message("Instantiated a DelegationEvaluator.");
        }
    }

    public boolean isAllowed(SSOToken token, DelegationPermission permission, Map envParameters) throws SSOException, DelegationException {
        boolean result = false;
        if (permission != null && token != null) {
            AMIdentity user = null;
            try {
                user = new AMIdentity(token);
                if (privilegedUser != null && user.equals(privilegedUser) || installTime && adminUserSet.contains(DNUtils.normalizeDN(token.getPrincipal().getName())) || user.equals(adminUserId)) {
                    result = true;
                } else {
                    if (this.pluginInstance == null) {
                        this.pluginInstance = DelegationManager.getDelegationPlugin();
                        if (this.pluginInstance == null) {
                            throw new DelegationException("amDelegation", "no_plugin_specified", null, null);
                        }
                    }
                    result = this.pluginInstance.isAllowed(token, permission, envParameters);
                }
            }
            catch (IdRepoException ide) {
                throw new DelegationException(ide.getMessage());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("isAllowed() returns " + result + " for user:token.getPrincipal().getName() " + token.getPrincipal().getName() + " for permission " + permission);
        }
        return result;
    }

    public Set getPermissions(SSOToken token, String orgName) throws SSOException, DelegationException {
        if (this.pluginInstance != null) {
            String name = DNMapper.orgNameToDN(orgName);
            return this.pluginInstance.getPermissions(token, name);
        }
        throw new DelegationException("amDelegation", "no_plugin_specified", null, null);
    }

    static {
        installTime = Boolean.valueOf(SystemProperties.get("com.sun.identity.security.amadmin", "false"));
        adminUserSet = new HashSet();
        try {
            String adminUser = SystemProperties.get("com.sun.identity.authentication.super.user");
            if (adminUser != null) {
                adminUserSet.add(DNUtils.normalizeDN(adminUser));
                adminUserId = new AMIdentity(DelegationManager.getAdminToken(), adminUser, IdType.USER, "/", null);
            }
        }
        catch (Exception e) {
            debug.error("DelegationEvaluator:", (Throwable)e);
        }
        SMServiceListener listener = SMServiceListener.getInstance();
        listener.registerForNotifications();
        try {
            privilegedUser = new AMIdentity(DelegationManager.getAdminToken());
        }
        catch (Exception e) {
            debug.error("DelegationEvaluator:", (Throwable)e);
        }
    }
}

