/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso.cli;

import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.opensso.cli.ApplicationImpl;
import com.sun.identity.log.Level;
import java.text.MessageFormat;
import java.util.List;
import javax.security.auth.Subject;

public class DeleteApplications
extends ApplicationImpl {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        String realm = this.getStringOptionValue("realm");
        List appNames = rc.getOption("names");
        String[] param = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_APPLICATIONS", param);
        Subject adminSubject = this.getAdminSubject();
        try {
            for (String a : appNames) {
                ApplicationManager.deleteApplication(adminSubject, "/", a);
            }
            IOutput writer = this.getOutputWriter();
            writer.printlnMessage(MessageFormat.format(this.getResourceString("delete-applications-succeeded"), param));
            this.writeLog(0, Level.INFO, "SUCCEEDED_DELETE_APPLICATIONS", param);
        }
        catch (EntitlementException e) {
            String[] params = new String[]{realm, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_DELETE_APPLICATIONS", params);
            throw new CLIException(e, 127);
        }
    }
}

