/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm;

import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.idm.IdServices;
import com.sun.identity.idm.IdServicesProvider;
import com.sun.identity.shared.debug.Debug;
import java.security.ProviderException;

public class IdServicesFactory {
    private static IdServices idServices;
    private static Debug debug;
    private static boolean isInitialized;
    private static final String CONFIGURED_SDK_PACKAGE_PROPERTY = "com.iplanet.am.sdk.package";
    private static final String SERVER_PACKAGE = "com.iplanet.am.sdk.ldap";
    private static final String REMOTE_PACKAGE = "com.iplanet.am.sdk.remote";
    private static final String SERVER_IDM_PACKAGE = "com.sun.identity.idm.server";
    private static final String REMOTE_IDM_PACKAGE = "com.sun.identity.idm.remote";
    private static final String ID_SERVICES_PROVIDER_CLASS = "IdServicesProviderImpl";
    private static final String REMOTE_SERVICES_PROVIDER_CLASS = "IdRemoteServicesProviderImpl";
    private static final String PACKAGE_SEPARATOR = ".";

    private static void initialize() {
        String configuredSDK = SystemProperties.get(CONFIGURED_SDK_PACKAGE_PROPERTY);
        boolean isCriticalErrorIfClassNotFound = true;
        if (configuredSDK == null || configuredSDK.equals(SERVER_PACKAGE)) {
            try {
                isCriticalErrorIfClassNotFound = false;
                IdServicesFactory.instantiateImpls(SERVER_IDM_PACKAGE, ID_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
            }
            catch (ProviderException pe) {
                if (debug.messageEnabled()) {
                    debug.message("IdServicesFactory.static{} - Initializing the server packages failed. Hence trying the remote client sdk pacakage");
                }
                isCriticalErrorIfClassNotFound = true;
                IdServicesFactory.instantiateImpls(REMOTE_IDM_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
            }
        } else if (configuredSDK.equals(REMOTE_PACKAGE)) {
            IdServicesFactory.instantiateImpls(REMOTE_IDM_PACKAGE, REMOTE_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
        } else {
            IdServicesFactory.instantiateImpls(SERVER_IDM_PACKAGE, ID_SERVICES_PROVIDER_CLASS, isCriticalErrorIfClassNotFound);
        }
        isInitialized = true;
    }

    private static void instantiateImpls(String packageName, String className, boolean isCriticalErrorIfClassNotFound) {
        String providerClass = packageName + PACKAGE_SEPARATOR + className;
        try {
            IdServicesProvider idServicesProvider = (IdServicesProvider)Class.forName(providerClass).newInstance();
            idServices = idServicesProvider.getProvider();
        }
        catch (InstantiationException e) {
            debug.error("IdServicesFactory.instantiateImpls()- Initializing Impls from package: " + packageName + " FAILED!", (Throwable)e);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (IllegalAccessException e) {
            debug.error("IdServicesFactory.instantiateImpls()- Initializing Impls from package: " + packageName + " FAILED!", (Throwable)e);
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        catch (ClassNotFoundException e) {
            String message = "IdServicesFactory.instantiateImpls()- Initializing Impls from package: " + packageName + " FAILED!";
            if (isCriticalErrorIfClassNotFound) {
                debug.error(message, (Throwable)e);
            } else {
                debug.warning(message, (Throwable)e);
            }
            throw new ProviderException(AMSDKBundle.getString("300"));
        }
        if (debug.messageEnabled()) {
            debug.message("IdServicesFactory.instantiateImpls() - Successfully initialized Impls Using Impl Package: " + packageName + " for accessing Directory Services");
        }
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    public static IdServices getDataStoreServices() {
        if (!IdServicesFactory.isInitialized()) {
            IdServicesFactory.initialize();
        }
        return idServices;
    }

    static {
        debug = Debug.getInstance((String)"amIdm");
        isInitialized = false;
    }
}

