/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.spi;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.Logger;
import com.sun.identity.log.handlers.SecureFileHandler;
import com.sun.identity.log.spi.Debug;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class Archiver {
    private static SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyyHHmmss");
    private static final String PREFIX = "_secure.";
    private int filesPerKeystoreCounter = 0;
    private static LogManager lmanager = LogManagerUtil.getLogManager();

    public Archiver() {
        String filesPerKeyStoreString = lmanager.getProperty("iplanet-am-logging-files-per-keystore");
        if (filesPerKeyStoreString == null || filesPerKeyStoreString.length() == 0) {
            Debug.error("Archiver:could not get the files per keystore string. Setting it to 1.");
            filesPerKeyStoreString = "1";
        }
    }

    public void archive(String fileName, String location) {
        if (fileName == null || fileName.length() == 0) {
            Debug.error("Archiver:archive:FileName is null");
            return;
        }
        if (location == null || location.length() == 0) {
            Debug.error("Archiver:archive:Location is null");
            return;
        }
        Logger logger = (Logger)Logger.getLogger(fileName);
        ++this.filesPerKeystoreCounter;
        Date d = new Date();
        String timestampedFileName = location + PREFIX + fileName + "." + sdf.format(d).toString();
        String completePath = location + PREFIX + fileName;
        File f = new File(completePath);
        f.renameTo(new File(timestampedFileName));
        SecureFileHandler.addToCurrentFileList(fileName, fileName + "." + sdf.format(d).toString(), fileName);
    }

    public int checkCount() {
        return this.filesPerKeystoreCounter;
    }

    public void incrementCount() {
        ++this.filesPerKeystoreCounter;
    }

    public void archiveKeyStore(String logName, String location) {
        Logger logger = (Logger)Logger.getLogger(logName);
        ArrayList al = SecureFileHandler.getCurrentFileList(logName);
        String ts = ((String)al.get(al.size() - 2)).substring(((String)al.get(al.size() - 2)).lastIndexOf("."));
        if (Debug.messageEnabled()) {
            Debug.message("Archive:archiveKeyStore:Keystore timestamp = " + ts);
        }
        String LogKeyStoreArchiveName = location + PREFIX + "log." + logName + ts;
        String VerKeyStoreArchiveName = location + PREFIX + "ver." + logName + ts;
        String logKeyStoreOldName = location + PREFIX + "log." + logName;
        String verKeyStoreOldName = location + PREFIX + "ver." + logName;
        File logKeystore = new File(logKeyStoreOldName);
        logKeystore.renameTo(new File(LogKeyStoreArchiveName));
        File verKeystore = new File(verKeyStoreOldName);
        verKeystore.renameTo(new File(VerKeyStoreArchiveName));
        this.filesPerKeystoreCounter = 0;
    }
}

