/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.jaas;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.service.SSOTokenPrincipal;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.PolicyEvaluatorFactory;
import com.sun.identity.policy.jaas.ISPermissionCollection;
import com.sun.identity.shared.debug.Debug;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;

public class ISPermission
extends Permission {
    private Subject subject;
    private CodeSource codesource;
    private ProtectionDomain protectionDomain;
    private String serviceName;
    private String resourceName;
    private String actions;
    private Set actionSet;
    private Map envParams = Collections.synchronizedMap(Collections.EMPTY_MAP);
    private PolicyEvaluatorFactory policyEvalFactory;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    protected ISPermission(ProtectionDomain pd) {
        super("ISPermission");
        if (debug.messageEnabled()) {
            debug.message("ISPermission(protectionDomain) constructor called ");
        }
        this.protectionDomain = pd;
    }

    public ISPermission(Subject subject, CodeSource codesource) {
        super("ISPermission");
        if (debug.messageEnabled()) {
            debug.message("ISPermission(subject,codesource) constructor called ");
        }
        this.subject = subject;
        this.codesource = codesource;
    }

    public ISPermission(CodeSource codesource) {
        super("ISPermission");
        if (debug.messageEnabled()) {
            debug.message("ISPermission(codesource) constructor called ");
        }
        this.codesource = codesource;
    }

    public ISPermission(String serviceName, String resourceName, String actions) {
        super("ISPermission");
        this.serviceName = serviceName;
        this.resourceName = resourceName;
        this.actions = actions;
        debug.message("ISPermission:: Constructor called");
    }

    public ISPermission(String serviceName, String resourceName, String actions, Map envParams) {
        super("ISPermission");
        this.serviceName = serviceName;
        this.resourceName = resourceName;
        this.actions = actions;
        this.envParams = envParams;
        debug.message("ISPermission:: Constructor called");
    }

    public String getServiceName() {
        debug.message("ISPermission: getServiceName called");
        return this.serviceName;
    }

    public String getResourceName() {
        debug.message("ISPermission: getResourceName called");
        return this.resourceName;
    }

    public Map getEnvParams() {
        return this.envParams;
    }

    public String getActions() {
        debug.message("ISPermission: getActions called");
        if (debug.messageEnabled()) {
            debug.message("returning actions:" + this.actions);
        }
        return this.actions;
    }

    private boolean actionEquals(String actions1, String actions2) {
        String action;
        StringTokenizer st;
        Set<String> actionSet1 = Collections.synchronizedSet(new HashSet());
        Set<String> actionSet2 = Collections.synchronizedSet(new HashSet());
        if (actions1 != null) {
            st = new StringTokenizer(actions1, ",");
            while (st.hasMoreTokens()) {
                action = st.nextToken().trim();
                actionSet1.add(action);
            }
        }
        if (actions2 != null) {
            st = new StringTokenizer(actions2, ",");
            while (st.hasMoreTokens()) {
                action = st.nextToken().trim();
                actionSet2.add(action);
            }
        }
        return ((Object)actionSet1).equals(actionSet2);
    }

    private Set actionsInSet(String actions) {
        if (this.actionSet != null) {
            return this.actionSet;
        }
        this.actionSet = Collections.synchronizedSet(new HashSet());
        if (actions != null) {
            StringTokenizer st = new StringTokenizer(actions, ",");
            while (st.hasMoreTokens()) {
                String action = st.nextToken();
                this.actionSet.add(action);
            }
        }
        return this.actionSet;
    }

    public Subject getSubject() {
        debug.message("ISPermission:: getSubject called ");
        return this.subject;
    }

    public CodeSource getCodeSource() {
        debug.message("ISPermission:: getCodeSource called ");
        return this.codesource;
    }

    public ProtectionDomain getProtectionDomain() {
        debug.message("ISPermission:: getProtectionDomain called ");
        return this.protectionDomain;
    }

    public boolean equals(Object obj) {
        boolean result = true;
        debug.message("ISPermission:: equals(Object) called ");
        if (obj == this) {
            if (debug.messageEnabled()) {
                debug.message("ISPermission::equals::this " + result);
            }
            return true;
        }
        if (obj instanceof ISPermission) {
            ISPermission perm = (ISPermission)obj;
            Subject subject = perm.getSubject();
            if (subject != null) {
                result = subject.equals(this.subject);
            } else if (this.subject != null) {
                result = false;
            }
            if (debug.messageEnabled()) {
                debug.message("ISPermission::subject equals:" + result);
            }
            if (result) {
                CodeSource codesource = perm.getCodeSource();
                if (codesource != null) {
                    result = codesource.equals(this.codesource);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::codesource equals:" + codesource.equals(this.codesource));
                    }
                } else if (this.codesource != null) {
                    result = false;
                }
            }
            if (result) {
                ProtectionDomain protectionDomain = perm.getProtectionDomain();
                if (protectionDomain != null) {
                    result = protectionDomain.equals(this.protectionDomain);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::protectionDomain equals:" + protectionDomain.equals(this.protectionDomain));
                    }
                } else if (this.protectionDomain != null) {
                    result = false;
                }
            }
            if (result) {
                String serviceName = perm.getServiceName();
                if (serviceName != null) {
                    result = serviceName.equals(this.serviceName);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::servicename equals:" + serviceName.equals(this.serviceName));
                    }
                } else if (this.serviceName != null) {
                    result = false;
                }
            }
            if (result) {
                String resourceName = perm.getResourceName();
                if (resourceName != null) {
                    result = resourceName.equals(this.resourceName);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::resourceName equals:" + resourceName.equals(this.resourceName));
                    }
                } else if (this.resourceName != null) {
                    result = false;
                }
            }
            if (result) {
                String actions = perm.getActions();
                if (actions != null) {
                    result = this.actionEquals(actions, this.actions);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::Actions equals:" + this.actionEquals(actions, this.actions));
                    }
                } else if (this.actions != null) {
                    result = false;
                }
            }
            if (result) {
                Map envParams = perm.getEnvParams();
                if (envParams != null && !envParams.isEmpty()) {
                    result = ((Object)envParams).equals(this.envParams);
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::equals::envMap" + ((Object)envParams).equals(this.envParams));
                    }
                } else if (this.envParams != null && !this.envParams.isEmpty()) {
                    result = false;
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ISPermission::equals::returning " + result);
        }
        return result;
    }

    public int hashCode() {
        int hash = 0;
        if (this.subject != null) {
            hash += this.subject.hashCode();
        }
        if (this.codesource != null) {
            hash += this.codesource.hashCode();
        }
        if (this.protectionDomain != null) {
            hash += this.protectionDomain.hashCode();
        }
        if (this.serviceName != null) {
            hash += this.serviceName.hashCode();
        }
        if (this.resourceName != null) {
            hash += this.resourceName.hashCode();
        }
        if (this.actions != null) {
            Set actionSet = this.actionsInSet(this.actions);
            hash += ((Object)actionSet).hashCode();
        }
        if (this.envParams != null) {
            hash += ((Object)this.envParams).hashCode();
        }
        if (debug.messageEnabled()) {
            debug.message("ISPermission::hashCode::" + hash);
        }
        return hash;
    }

    public boolean implies(Permission perm) {
        boolean allowed;
        block22: {
            debug.message("ISPermission: implies called");
            allowed = false;
            if (perm instanceof ISPermission) {
                debug.message("ISPermission:passed perm is of type ISPermission");
                if (this.protectionDomain != null) {
                    debug.message("ISPermission:implies:protectionDomain not null");
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission::implies: protectionDomain:" + this.protectionDomain.toString());
                    }
                    String serviceName = ((ISPermission)perm).getServiceName();
                    String resourceName = ((ISPermission)perm).getResourceName();
                    String actions = ((ISPermission)perm).getActions();
                    Map envParams = ((ISPermission)perm).getEnvParams();
                    if (debug.messageEnabled()) {
                        debug.message("ISPermission: resourceName=" + resourceName);
                        debug.message("ISPermission: serviceName=" + serviceName);
                        debug.message("ISPermission: actions=" + actions);
                    }
                    SSOTokenPrincipal tokenPrincipal = null;
                    try {
                        Principal[] principals = this.protectionDomain.getPrincipals();
                        Principal principal = principals[0];
                        if (principal.getName().equals("com.sun.identity.authentication.service.SSOTokenPrincipal")) {
                            if (debug.messageEnabled()) {
                                debug.message("ISPermission::implies:principals:" + ((Object)principal).toString());
                            }
                            tokenPrincipal = (SSOTokenPrincipal)principal;
                        }
                        if (tokenPrincipal == null) {
                            if (debug.messageEnabled()) {
                                debug.error("ISPermission::implies: Principal is null");
                            }
                        } else {
                            SSOTokenManager ssomgr = SSOTokenManager.getInstance();
                            SSOToken token = ssomgr.createSSOToken(tokenPrincipal.getName());
                            if (this.policyEvalFactory == null) {
                                this.policyEvalFactory = PolicyEvaluatorFactory.getInstance();
                            }
                            PolicyEvaluator policyEvaluator = this.policyEvalFactory.getPolicyEvaluator(serviceName);
                            if (debug.messageEnabled()) {
                                debug.message("ISPermission::implies::created PolicyEvaluator for " + serviceName);
                            }
                            if (actions != null) {
                                String action;
                                StringTokenizer st = new StringTokenizer(actions, ",");
                                while (st.hasMoreTokens() && (allowed = policyEvaluator.isAllowed(token, resourceName, action = st.nextToken(), envParams))) {
                                    if (!debug.messageEnabled()) continue;
                                    debug.message("ISPermission::result for " + action + " is :" + allowed);
                                }
                                if (debug.messageEnabled()) {
                                    debug.message("ISPermission::result for " + actions + " is :" + allowed);
                                }
                            } else if (debug.messageEnabled()) {
                                debug.message("ISPermission:: actions is null");
                            }
                        }
                        break block22;
                    }
                    catch (SSOException ssoe) {
                        if (debug.messageEnabled()) {
                            debug.error("ISPermission::SSOException:" + ssoe.getMessage());
                            ssoe.printStackTrace();
                        }
                        break block22;
                    }
                    catch (Exception e) {
                        if (debug.messageEnabled()) {
                            debug.error("ISPermission::Exception:" + e.getMessage());
                            e.printStackTrace();
                        }
                        break block22;
                    }
                }
                debug.message("ISPermission:: subject was null");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ISPermission: allowed::" + allowed);
        }
        return allowed;
    }

    public PermissionCollection newPermissionCollection() {
        debug.message("ISPermission:: newISPermissionCollection() called");
        return new ISPermissionCollection();
    }

    public String toString() {
        StringBuffer str = new StringBuffer(200);
        str = str.append("(").append(this.getClass().getName()).append("\n");
        String actions = this.getActions();
        if (this.subject != null) {
            str = str.append(this.subject.toString()).append("\n");
        }
        if (this.codesource != null) {
            str = str.append(this.codesource.toString()).append("\n");
        }
        if (this.serviceName != null && this.serviceName.length() != 0) {
            str = str.append("serviceName=").append(this.serviceName).append("\n");
        }
        if (this.resourceName != null && this.resourceName.length() != 0) {
            str = str.append("resourceName=").append(this.resourceName).append("\n");
        }
        if (actions != null && actions.length() != 0) {
            str = str.append("actions=").append(actions).append("\n");
        }
        if (this.envParams != null && !this.envParams.isEmpty()) {
            str = str.append("envParams=").append(this.envParams.values()).append("\n");
        }
        str.append(")");
        return str.toString();
    }
}

