/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.setup;

import com.sun.identity.setup.AMSetupServlet;
import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class AMSetupFilter
implements Filter {
    private FilterConfig config;
    private ServletContext servletCtx;
    private boolean initialized;
    private boolean passthrough;
    private static final String SETUPURI = "/config/options.htm";
    private static final String NOWRITE_PERMISSION = "/nowritewarning.jsp";
    private static String[] fList = new String[]{".htm", ".css", ".js", ".jpg", ".gif", ".png", ".JPG", "SMSObjectIF", "setSetupProgress"};

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            if (AMSetupServlet.isConfigured()) {
                String incomingURL = httpRequest.getRequestURI();
                if (incomingURL.endsWith("configurator.jsp") || incomingURL.endsWith(SETUPURI)) {
                    String url = httpRequest.getScheme() + "://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort() + httpRequest.getContextPath();
                    httpResponse.sendRedirect(url);
                } else {
                    filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            } else if (this.isPassthrough() && this.validateStream(httpRequest)) {
                filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            } else {
                String incomingURL = httpRequest.getRequestURI();
                if (incomingURL.endsWith("configurator")) {
                    filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                } else {
                    String url = httpRequest.getScheme() + "://" + httpRequest.getServerName() + ":" + httpRequest.getServerPort() + httpRequest.getContextPath();
                    url = new File(System.getProperty("user.home")).canWrite() ? url + SETUPURI : url + NOWRITE_PERMISSION;
                    httpResponse.sendRedirect(url);
                    this.markPassthrough();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServletException("AMSetupFilter.doFilter", (Throwable)ex);
        }
    }

    private boolean validateStream(HttpServletRequest httpRequest) {
        String uri = httpRequest.getRequestURI();
        boolean ok = false;
        for (int i = 0; i < fList.length && !ok; ++i) {
            ok = uri.indexOf(fList[i]) != -1;
        }
        return ok;
    }

    public void destroy() {
        this.config = null;
    }

    public void init(FilterConfig filterConfig) {
        this.setFilterConfig(filterConfig);
        this.servletCtx = filterConfig.getServletContext();
        this.initialized = AMSetupServlet.checkInitState(this.servletCtx);
        if (!this.initialized) {
            this.servletCtx.setAttribute("am.enc.pwd", (Object)AMSetupServlet.getRandomString());
        }
    }

    public void setFilterConfig(FilterConfig fconfig) {
        this.config = fconfig;
    }

    private boolean isPassthrough() {
        return this.passthrough;
    }

    private void markPassthrough() {
        this.passthrough = true;
    }
}

