/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.UserSubject;
import com.sun.identity.entitlement.opensso.OpenSSOSubjectAttributesCollector;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSOUserSubject
extends UserSubject {
    public OpenSSOUserSubject() {
    }

    public OpenSSOUserSubject(String user) {
        super(user);
    }

    public OpenSSOUserSubject(String user, String pSubjectName) {
        super(user, pSubjectName);
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        HashSet<String> set = new HashSet<String>();
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        String uuid = this.getID();
        try {
            AMIdentity amid = new AMIdentity(adminToken, uuid);
            set.add(OpenSSOSubjectAttributesCollector.getIDWithoutOrgName(amid));
        }
        catch (IdRepoException ex) {
            if (PrivilegeManager.debug.messageEnabled()) {
                PrivilegeManager.debug.message("UserSubject.getSearchIndexAttributes", (Throwable)ex);
            }
            set.add(uuid);
        }
        map.put("identity:", set);
        return map;
    }

    @Override
    protected boolean hasPrincipal(Subject subject, String uuid) {
        Set<Principal> userPrincipals = subject.getPrincipals();
        for (Principal p : userPrincipals) {
            String puuid = p.getName();
            if (puuid.equals(uuid)) {
                return true;
            }
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                AMIdentity pamid = new AMIdentity(adminToken, puuid);
                AMIdentity amid = new AMIdentity(adminToken, uuid);
                if (!pamid.equals(amid)) continue;
                return true;
            }
            catch (IdRepoException ex) {
                if (!PrivilegeManager.debug.messageEnabled()) continue;
                PrivilegeManager.debug.message("EntitlementSubjectImpl.hasPrincipal", (Throwable)ex);
            }
        }
        return false;
    }
}

