/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.sun.identity.sm.ServiceAttributeValidator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class EmailValidator
implements ServiceAttributeValidator {
    private static Vector inValidChars = new Vector();

    public boolean validate(Set values) {
        for (String value : values) {
            if (this.validate(value)) continue;
            return false;
        }
        return true;
    }

    public boolean validate(String value) {
        int index = value.indexOf(64);
        if (index == -1) {
            return false;
        }
        String name = value.substring(0, index);
        String domain = value.substring(index + 1, value.length());
        return this.validateName(name) && this.validateDomain(domain);
    }

    private boolean validateName(String name) {
        StringTokenizer tok = new StringTokenizer(name, ".");
        if (tok.countTokens() < 1) {
            return false;
        }
        while (tok.hasMoreTokens()) {
            if (this.isValidNamePart(tok.nextToken())) continue;
            return false;
        }
        return true;
    }

    private boolean isValidNamePart(String name) {
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch;
            char val = ch = name.charAt(i);
            Character character = new Character(ch);
            if (val >= '!' && val <= '~' && !inValidChars.contains(character.toString())) continue;
            return false;
        }
        return true;
    }

    private boolean validateDomain(String domain) {
        StringTokenizer tok = new StringTokenizer(domain, ".");
        if (tok.countTokens() <= 1) {
            return false;
        }
        while (tok.hasMoreTokens()) {
            if (this.isValidDomainPart(tok.nextToken())) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDomainPart(String domain) {
        int length = domain.length();
        if (domain.charAt(0) == '-' || domain.charAt(length - 1) == '-') {
            return false;
        }
        if (length > 63) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char ch = domain.charAt(i);
            if (Character.isLetter(ch) || Character.isDigit(ch) || ch == '-') continue;
            return false;
        }
        return true;
    }

    static {
        inValidChars.addElement("(");
        inValidChars.addElement(")");
        inValidChars.addElement("<");
        inValidChars.addElement(">");
        inValidChars.addElement("@");
        inValidChars.addElement(",");
        inValidChars.addElement(";");
        inValidChars.addElement(":");
        inValidChars.addElement("\\");
        inValidChars.addElement("\"");
        inValidChars.addElement(".");
        inValidChars.addElement("[");
        inValidChars.addElement("]");
    }
}

