/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.cli;

import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.cli.FederationManager;
import java.text.MessageFormat;
import java.util.logging.Level;

public class RemoveCircleOfTrustMembers
extends AuthenticatedCommand {
    private String realm;
    private String cot;
    private String entityID;
    private String spec;

    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        this.superAdminUserValidation();
        this.realm = this.getStringOptionValue("realm", "/");
        this.cot = this.getStringOptionValue("cot");
        this.entityID = this.getStringOptionValue("entityid");
        this.spec = FederationManager.getIDFFSubCommandSpecification(rc);
        String[] params = new String[]{this.realm, this.cot, this.entityID, this.spec};
        this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_COT_MEMBER", params);
        try {
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            cotManager.removeCircleOfTrustMember(this.realm, this.cot, this.spec, this.entityID);
            Object[] objs = new Object[]{this.cot, this.entityID, this.realm};
            this.getOutputWriter().printlnMessage(MessageFormat.format(this.getResourceString("remove-circle-of-trust-member-succeeded"), objs));
            this.writeLog(0, Level.INFO, "SUCCEEDED_REMOVE_COT_MEMBER", params);
        }
        catch (COTException e) {
            this.debugWarning("RemoveCircleOfTrustMembers.handleRequest", e);
            String[] args = new String[]{this.realm, this.cot, this.entityID, this.spec, e.getMessage()};
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_COT_MEMBER", args);
            throw new CLIException(e.getMessage(), 127);
        }
    }
}

