/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import com.iplanet.am.util.SecureRandomManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.UserNameTokenSpec;
import com.sun.identity.wss.security.WSSUtils;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import java.util.ResourceBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserNameToken
implements SecurityToken {
    private static final String USER_NAME_TOKEN = "UsernameToken";
    private static final String USER_NAME = "Username";
    private static final String PASSWORD = "Password";
    private static final String NONCE = "Nonce";
    private static final String CREATED = "Created";
    private String passwordType = null;
    private boolean setNonce = false;
    private boolean setTimeStamp = false;
    private String nonce = null;
    private String created = null;
    private String username = null;
    private String password = null;
    private String xmlString = null;
    private String id = null;
    private static Debug debug = WSSUtils.debug;
    private static ResourceBundle bundle = WSSUtils.bundle;

    public UserNameToken(UserNameTokenSpec tokenSpec) throws SecurityException {
        if (tokenSpec == null) {
            throw new SecurityException(bundle.getString("invalidTokenSpec"));
        }
        debug.message("UserNameToken.constructor:");
        this.username = tokenSpec.getUserName();
        if (this.username == null) {
            debug.error("UserNameToken:: username is null");
            throw new SecurityException(bundle.getString("invalidTokenSpec"));
        }
        this.username = this.username.trim();
        if (this.username.length() == 0) {
            debug.error("UserNameToken:: username is null");
            throw new SecurityException(bundle.getString("invalidTokenSpec"));
        }
        this.passwordType = tokenSpec.getPasswordType();
        this.setNonce = tokenSpec.isCreateNonce();
        this.setTimeStamp = tokenSpec.isCreateTimeStamp();
        if (this.setNonce) {
            this.createNonce();
        }
        if (this.setTimeStamp) {
            this.created = DateUtils.toUTCDateFormat((Date)new Date());
        }
        this.setPassword(tokenSpec.getPassword());
        this.id = SAMLUtils.generateID();
    }

    public UserNameToken(Element element) throws SecurityException {
        if (element == null) {
            throw new IllegalArgumentException(bundle.getString("nullInputParameter"));
        }
        if (!USER_NAME_TOKEN.equals(element.getLocalName()) || !"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(element.getNamespaceURI())) {
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        NodeList childNodes = element.getChildNodes();
        if (childNodes == null || childNodes.getLength() == 0) {
            throw new SecurityException(bundle.getString("invalidElement"));
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElem = (Element)child;
            if (USER_NAME.equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                this.username = child.getFirstChild().getNodeValue();
                continue;
            }
            if (PASSWORD.equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                this.password = child.getFirstChild().getNodeValue();
                Attr attr = childElem.getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type");
                if (attr != null) {
                    this.passwordType = attr.getNodeValue();
                    continue;
                }
                this.passwordType = childElem.getAttribute("Type");
                continue;
            }
            if (NONCE.equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd".equals(child.getNamespaceURI())) {
                this.nonce = child.getFirstChild().getNodeValue();
                continue;
            }
            if (CREATED.equals(child.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(child.getNamespaceURI())) {
                this.created = child.getFirstChild().getNodeValue();
                continue;
            }
            if (!debug.messageEnabled()) continue;
            debug.message("UserNameToken.constructor:: Invalid element " + child.getLocalName());
        }
        if (this.username == null || this.username.length() == 0) {
            debug.error("UserNameToken.constructor:: username is null");
            throw new SecurityException(bundle.getString("invalidElement"));
        }
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPassword(String passwd) throws SecurityException {
        if (passwd == null) {
            debug.error("UserNameToken.setPassword:: password is empty");
            throw new SecurityException(bundle.getString("invalidTokenSpec"));
        }
        this.password = this.passwordType != null && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType) ? UserNameToken.getPasswordDigest(passwd, this.nonce, this.created) : passwd;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getCreated() {
        return this.created;
    }

    public String getSigningId() {
        return this.id;
    }

    public String toString() {
        if (this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer sb = new StringBuffer(300);
        sb.append("<").append("wsse").append(":").append(USER_NAME_TOKEN).append(" ").append("xmlns:wsse").append("=\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd").append("\" ").append("xmlns:wsu").append("=\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd").append("\" ").append("wsu:Id").append("=\"").append(this.id).append("\">\n").append("<").append("wsse").append(":").append(USER_NAME).append(">").append(this.username).append("</").append("wsse").append(":").append(USER_NAME).append(">\n").append("<").append("wsse").append(":").append(PASSWORD);
        if (this.passwordType != null) {
            sb.append(" ").append("Type=").append("\"").append(this.passwordType).append("\"");
        }
        sb.append(">").append(this.password).append("</").append("wsse").append(":").append(PASSWORD).append(">\n");
        if (this.nonce != null) {
            sb.append("<").append("wsse").append(":").append(NONCE).append(" ").append("EncodingType=").append("\"").append("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary").append("\"").append(">").append(this.nonce).append("</").append("wsse").append(":").append(NONCE).append(">\n");
        }
        if (this.created != null) {
            sb.append("<").append("wsu").append(":").append(CREATED).append(">").append(this.created).append("</").append("wsu").append(":").append(CREATED).append(">\n");
        }
        sb.append("</").append("wsse").append(":").append(USER_NAME_TOKEN).append(">\n");
        this.xmlString = sb.toString();
        if (debug.messageEnabled()) {
            debug.message("UserNameToken.toString:: \n" + this.xmlString);
        }
        return this.xmlString;
    }

    public Element toDocumentElement() throws SecurityException {
        Document document = XMLUtils.toDOMDocument((String)this.toString(), (Debug)debug);
        if (document == null) {
            throw new SecurityException(bundle.getString("cannotConvertToDocument"));
        }
        return document.getDocumentElement();
    }

    public String getTokenType() {
        return "urn:sun:wss:usernametoken";
    }

    private void createNonce() throws SecurityException {
        byte[] nonceValue = new byte[18];
        try {
            SecureRandom secureRandom = SecureRandomManager.getSecureRandom();
            secureRandom.nextBytes(nonceValue);
            this.nonce = Base64.encode((byte[])nonceValue);
        }
        catch (Exception ex) {
            debug.error("UserNameToken.createNonce:: exception", (Throwable)ex);
            throw new SecurityException();
        }
    }

    public static String getPasswordDigest(String password, String nonce, String created) throws SecurityException {
        try {
            if (nonce == null || created == null || password == null) {
                debug.error("UserNameToken.getPasswordDigest:: nonce and created are required");
                throw new IllegalArgumentException("nullInputParams");
            }
            byte[] b1 = Base64.decode((String)nonce);
            byte[] b2 = created.getBytes("UTF-8");
            byte[] b3 = password.getBytes("UTF-8");
            byte[] b4 = new byte[b1.length + b2.length + b3.length];
            boolean i = false;
            int offset = 0;
            System.arraycopy(b1, 0, b4, offset, b1.length);
            System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
            System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            sha.update(b4);
            return Base64.encode((byte[])sha.digest());
        }
        catch (Exception ex) {
            debug.error("UserNameToken.getPasswordDigest:: password digest error.", (Throwable)ex);
            throw new SecurityException(bundle.getString("passwordDigestFailed"));
        }
    }
}

