/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.share;

import com.iplanet.services.comm.share.RequestSetParser;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ResponseSetParser {
    Document document;

    public ResponseSetParser(Document xmlDoc) {
        this.document = xmlDoc;
    }

    public ResponseSetParser(String xmlString) {
        this.document = XMLUtils.toDOMDocument((String)xmlString, (Debug)RequestSetParser.debug);
    }

    public ResponseSet parseXML() {
        if (this.document == null) {
            return null;
        }
        Element responseSetElem = this.document.getDocumentElement();
        ResponseSet responseSet = new ResponseSet();
        this.setResponseSetAttributes(responseSetElem, responseSet);
        NodeList responses = responseSetElem.getElementsByTagName("Response");
        if (responses == null) {
            return responseSet;
        }
        int nodeLen = responses.getLength();
        for (int i = 0; i < nodeLen; ++i) {
            responseSet.addResponse(this.parseResponseElement((Element)responses.item(i)));
        }
        return responseSet;
    }

    public void setResponseSetAttributes(Element elem, ResponseSet responseSet) {
        String temp = elem.getAttribute("vers");
        if (temp != null) {
            responseSet.setResponseSetVersion(temp);
        }
        if ((temp = elem.getAttribute("svcid")) != null) {
            responseSet.setServiceID(temp);
        }
        if ((temp = elem.getAttribute("reqid")) != null) {
            responseSet.setRequestSetID(temp);
        }
    }

    private Response parseResponseElement(Element elem) {
        Node text;
        Response response = new Response();
        String temp = elem.getAttribute("dtdid");
        if (temp != null) {
            response.setDtdID(temp);
        }
        if ((text = elem.getFirstChild()) != null) {
            response.setContent(text.getNodeValue());
        }
        return response;
    }
}

