/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.naming.service;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.Session;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.services.naming.share.NamingRequest;
import com.iplanet.services.naming.share.NamingResponse;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.common.FQDNUtils;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class NamingService
implements RequestHandler,
ServiceListener {
    public static final int SERVICE_REV_NUMBER_70 = 20;
    public static int serviceRevNumber;
    private static Debug namingDebug;
    public static final String NAMING_SERVICE = "com.iplanet.am.naming";
    private static Hashtable namingTable;
    private static Properties platformProperties;
    private static String server_proto;
    private static String server_host;
    private static String server_port;
    private static SSOToken sso;
    private static ServiceSchemaManager ssmNaming;
    private static ServiceSchemaManager ssmPlatform;
    private static ServiceConfigManager scmNaming;
    private static ServiceConfigManager scmPlatform;
    private static ServiceConfig sessionServiceConfig;
    private static Set sessionConfig;
    private static String delimiter;

    public static Hashtable getNamingTable(boolean forClient) throws SMSException {
        return NamingService.updateNamingTable(forClient);
    }

    public static Hashtable getNamingTable() throws SMSException {
        try {
            if (namingTable != null) {
                return namingTable;
            }
            NamingService.updateNamingTable();
        }
        catch (Exception ex) {
            throw new SMSException(ex.getMessage());
        }
        return namingTable;
    }

    private static void updateNamingTable() throws SMSException {
        namingTable = NamingService.updateNamingTable(false);
    }

    private static Hashtable updateNamingTable(boolean forClient) throws SMSException {
        Hashtable nametable = null;
        try {
            ServiceSchema sc = ssmNaming.getGlobalSchema();
            Map namingAttrs = sc.getAttributeDefaults();
            sc = ssmPlatform.getGlobalSchema();
            Map platformAttrs = sc.getAttributeDefaults();
            Set sites = NamingService.getSites(platformAttrs);
            Set servers = NamingService.getServers(platformAttrs, sites);
            if (sites != null && !sites.isEmpty()) {
                if (!forClient) {
                    NamingService.registFQDNMapping(sites);
                }
                sites.addAll(servers);
            } else {
                sites = servers;
            }
            if (forClient) {
                NamingService.storeServerListForClient(sites, namingAttrs);
            } else {
                NamingService.storeServerList(sites, namingAttrs);
            }
            nametable = NamingService.convertToHash(namingAttrs);
            if (forClient && namingTable != null) {
                String siteList = (String)namingTable.get("iplanet-am-platform-site-id-list");
                nametable.put("iplanet-am-platform-site-id-list", siteList);
            }
            NamingService.insertLBCookieValues(nametable);
        }
        catch (Exception ex) {
            namingDebug.error("Can't get naming table", (Throwable)ex);
            throw new SMSException(ex.getMessage());
        }
        return nametable;
    }

    static Hashtable convertToHash(Map m) {
        Hashtable<String, String> retHash = new Hashtable<String, String>();
        Set s = m.keySet();
        for (String key : s) {
            Set val = (Set)m.get(key);
            retHash.put(key, NamingService.setToString(val));
        }
        return retHash;
    }

    static void storeServerList(Set servers, Map namingAttrs) {
        HashSet<String> serverList = new HashSet<String>();
        HashSet<String> siteList = new HashSet<String>();
        for (String serverEntry : servers) {
            int index = serverEntry.indexOf(delimiter);
            if (index != -1) {
                String server = serverEntry.substring(0, index);
                String serverId = serverEntry.substring(index + 1, serverEntry.length());
                siteList.add(serverId);
                index = serverId.indexOf(delimiter);
                if (index != -1) {
                    serverId = serverId.substring(0, 2);
                }
                HashSet<String> serverSet = new HashSet<String>();
                serverSet.add(server);
                serverList.add(server);
                namingAttrs.put(serverId, serverSet);
                continue;
            }
            namingDebug.error("Platform Server List entry is invalid:" + serverEntry);
        }
        namingAttrs.put("iplanet-am-platform-server-list", serverList);
        namingAttrs.put("iplanet-am-platform-site-id-list", siteList);
    }

    static void storeServerListForClient(Set servers, Map namingAttrs) {
        HashSet<String> serverList = new HashSet<String>();
        for (String serverEntry : servers) {
            int index = serverEntry.indexOf(delimiter);
            if (index != -1) {
                String server = serverEntry.substring(0, index);
                String serverId = serverEntry.substring(index + 1, serverEntry.length());
                if ((index = serverId.indexOf(delimiter)) != -1) continue;
                HashSet<String> serverSet = new HashSet<String>();
                serverSet.add(server);
                serverList.add(server);
                namingAttrs.put(serverId, serverSet);
                continue;
            }
            namingDebug.error("Platform Server List entry is invalid:" + serverEntry);
        }
        namingAttrs.put("iplanet-am-platform-server-list", serverList);
    }

    static String setToString(Set s) {
        StringBuffer sb = new StringBuffer(100);
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            sb.append((String)iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public ResponseSet process(Vector requests, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServletContext servletContext) {
        ResponseSet rset = new ResponseSet(NAMING_SERVICE);
        for (int i = 0; i < requests.size(); ++i) {
            Request req = (Request)requests.elementAt(i);
            Response res = this.processRequest(req);
            rset.addResponse(res);
        }
        return rset;
    }

    private Response processRequest(Request req) {
        String content = req.getContent();
        NamingRequest nreq = NamingRequest.parseXML(content);
        NamingResponse nres = new NamingResponse(nreq.getRequestID());
        float reqVersion = Float.valueOf(nreq.getRequestVersion()).floatValue();
        boolean limitNametable = (double)reqVersion > 1.0;
        String sessionId = nreq.getSessionId();
        try {
            if (sessionId == null) {
                nres.setNamingTable(NamingService.getNamingTable(limitNametable));
            } else {
                Hashtable tempHash = new Hashtable();
                tempHash = this.transferTable(NamingService.getNamingTable(limitNametable));
                Hashtable replacedTable = null;
                URL url = this.usePreferredNamingURL(nreq, reqVersion);
                if (url != null) {
                    String uri = (double)reqVersion < 3.0 ? SystemProperties.get("com.iplanet.am.services.deploymentDescriptor") : WebtopNaming.getURI(url);
                    replacedTable = this.replaceTable(tempHash, url.getProtocol(), url.getHost(), Integer.toString(url.getPort()), uri);
                } else {
                    replacedTable = this.replaceTable(tempHash, sessionId);
                }
                if (replacedTable == null) {
                    nres.setException("SessionID ---" + sessionId + "---is Invalid");
                } else {
                    nres.setNamingTable(replacedTable);
                }
                nres.setAttribute("am_load_balancer_cookie", Session.getLBCookie(sessionId));
            }
        }
        catch (Exception e) {
            nres.setException(e.getMessage());
        }
        if ((double)reqVersion < 3.0) {
            String uri = SystemProperties.get("com.iplanet.am.services.deploymentDescriptor");
            if (!uri.startsWith("/")) {
                uri = "/" + uri;
            }
            nres.replaceURI(uri);
        }
        return new Response(nres.toXMLString());
    }

    private URL usePreferredNamingURL(NamingRequest request, float reqVersion) throws ServerEntryNotFoundException, MalformedURLException {
        String secondarysites;
        String preferredNamingURL = null;
        URL preferredURL = null;
        if (request == null) {
            return null;
        }
        preferredNamingURL = request.getPreferredNamingURL();
        if (preferredNamingURL == null) {
            return null;
        }
        String sessionid = request.getSessionId();
        if (sessionid == null) {
            return null;
        }
        URL url = new URL(request.getPreferredNamingURL());
        String uri = (double)reqVersion < 3.0 ? SystemProperties.get("com.iplanet.am.services.deploymentDescriptor") : WebtopNaming.getURI(url);
        String serverID = WebtopNaming.getServerID(url.getProtocol(), url.getHost(), Integer.toString(url.getPort()), uri);
        SessionID sessionID = new SessionID(sessionid);
        String primary_id = sessionID.getExtension("S1");
        if (primary_id != null && (secondarysites = WebtopNaming.getSecondarySites(primary_id)) != null && serverID != null && secondarysites.indexOf(serverID) != -1) {
            preferredURL = url;
        }
        return preferredURL;
    }

    private Hashtable replaceTable(Hashtable namingTable, String sessionID) {
        SessionID sessID = new SessionID(sessionID);
        namingDebug.message("SessionId received is --" + sessionID);
        return this.replaceTable(namingTable, sessID.getSessionServerProtocol(), sessID.getSessionServer(), sessID.getSessionServerPort(), sessID.getSessionServerURI());
    }

    private Hashtable replaceTable(Hashtable namingTable, String protocol, String host, String port, String uri) {
        if (protocol.equalsIgnoreCase("") || host.equalsIgnoreCase("") || port.equalsIgnoreCase("")) {
            return null;
        }
        if (!(protocol.equals(server_proto) && host.equals(server_host) && port.equals(server_port))) {
            String cookieURL = protocol + "://" + host + ":" + port;
            String platformList = (String)namingTable.get("iplanet-am-platform-server-list");
            if (platformList.indexOf(cookieURL) == -1) {
                return null;
            }
        }
        Hashtable tempNamingTable = namingTable;
        Enumeration e = tempNamingTable.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            String key = obj.toString();
            String url = tempNamingTable.get(obj).toString();
            url = url.replaceAll("%protocol", protocol);
            url = url.replaceAll("%host", host);
            url = url.replaceAll("%port", port);
            url = url.replaceAll("%uri", uri);
            tempNamingTable.put(key, url);
        }
        return tempNamingTable;
    }

    private Hashtable transferTable(Hashtable hashTab) {
        if (hashTab == null) {
            return null;
        }
        Hashtable<String, String> newTab = new Hashtable<String, String>();
        Enumeration e = hashTab.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            String key = obj.toString();
            String value = hashTab.get(obj).toString();
            newTab.put(key, value);
        }
        return newTab;
    }

    public void schemaChanged(String serviceName, String version) {
        if (serviceName == null || !serviceName.equals("iPlanetAMPlatformService") && !serviceName.equals("iPlanetAMNamingService")) {
            return;
        }
        try {
            NamingService.updateNamingTable();
        }
        catch (SMSException ex) {
            namingDebug.error("Error occured in updating naming table", (Throwable)ex);
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (serviceName == null || !serviceName.equals("iPlanetAMPlatformService") && !serviceName.equals("iPlanetAMNamingService")) {
            return;
        }
        try {
            NamingService.updateNamingTable();
            SessionService ss = SessionService.getSessionService();
            if (ss != null && ss.isSessionFailoverEnabled()) {
                ss.ReInitClusterMemberMap();
            }
        }
        catch (Exception ex) {
            namingDebug.error("Error occured in updating naming table", (Throwable)ex);
        }
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    private static void registFQDNMapping(Set sites) {
        if (sites == null || sites.isEmpty()) {
            return;
        }
        MessageFormat form = new MessageFormat("com.sun.identity.server.fqdnMap[{0}]");
        for (String entry : sites) {
            StringTokenizer tok = new StringTokenizer(entry, "|");
            String strUrl = tok.nextToken();
            String strId = tok.nextToken();
            try {
                URL url = new URL(strUrl);
                String host = url.getHost();
                if (host == null) continue;
                Object[] args = new Object[]{host};
                form.format(args);
                SystemProperties.initializeProperties(form.format(args), host);
            }
            catch (MalformedURLException ex) {
                namingDebug.error("NamingService.registFQDNMapping", (Throwable)ex);
            }
        }
        FQDNUtils.getInstance().init();
    }

    private static Set getSites(Map platformAttrs) throws Exception {
        Set sites = null;
        if (serviceRevNumber < 20) {
            Set servers = (Set)platformAttrs.get("iplanet-am-platform-server-list");
            sites = NamingService.getSitesFromSessionConfig(servers);
        } else {
            sites = SiteConfiguration.getSiteInfo(sso);
        }
        if (namingDebug.messageEnabled() && sites != null) {
            namingDebug.message("Sites : " + sites.toString());
        }
        return sites;
    }

    private static Set getServers(Map platformAttrs, Set sites) throws Exception {
        Set servers = ServerConfiguration.getServerInfo(sso);
        if (sites != null && serviceRevNumber < 20) {
            servers = NamingService.getServersFromSessionConfig(sites, servers);
        }
        if (namingDebug.messageEnabled() && servers != null) {
            namingDebug.message("servers : " + servers.toString());
        }
        return servers;
    }

    private static Set getSitesFromSessionConfig(Set platform) throws Exception {
        HashSet<String> sites = new HashSet<String>();
        for (String server : platform) {
            int idx;
            String serverFQDN = server.substring(0, idx = server.indexOf(delimiter));
            if (!sessionConfig.contains(serverFQDN)) continue;
            sites.add(server);
        }
        return sites.isEmpty() ? null : sites;
    }

    private static Set getServersFromSessionConfig(Set sites, Set platform) throws Exception {
        HashSet<String> servers = new HashSet<String>();
        Hashtable clusterInfo = NamingService.getClusterInfo(sites);
        for (String server : platform) {
            if (sites.contains(server)) continue;
            int idx = server.indexOf(delimiter);
            String serverid = server.substring(idx + 1, server.length());
            Iterator keys = clusterInfo.keySet().iterator();
            boolean found = false;
            while (!found && keys.hasNext()) {
                String siteid = (String)keys.next();
                String clusterlist = (String)clusterInfo.get(siteid);
                if (clusterlist.indexOf(serverid) < 0) continue;
                servers.add(server + delimiter + siteid);
                found = true;
            }
            if (found) continue;
            servers.add(server);
        }
        return servers.isEmpty() ? null : servers;
    }

    private static Hashtable getClusterInfo(Set sites) throws Exception {
        Hashtable<String, String> clustertbl = new Hashtable<String, String>();
        for (String site : sites) {
            int idx = site.indexOf(delimiter);
            String siteid = site.substring(idx + 1, site.length());
            site = site.substring(0, idx);
            ServiceConfig subConfig = sessionServiceConfig.getSubConfig(site);
            Map sessionAttrs = subConfig.getAttributes();
            String clusterServerList = CollectionHelper.getMapAttr((Map)sessionAttrs, (String)"iplanet-am-session-cluster-serverlist", (String)"");
            clustertbl.put(siteid, clusterServerList);
        }
        return clustertbl;
    }

    private static void insertLBCookieValues(Hashtable nametable) throws Exception {
        Map lbCookieMappings = null;
        lbCookieMappings = ServerConfiguration.getLBCookieValues(sso);
        if (namingDebug.messageEnabled()) {
            namingDebug.message("NamingService.insertLBCookieValues()LBCookie Mappings : " + lbCookieMappings.toString());
        }
        StringBuffer strBuffer = new StringBuffer();
        Set s = lbCookieMappings.keySet();
        for (String key : s) {
            String val = (String)lbCookieMappings.get(key);
            strBuffer.append(key).append(delimiter).append(val).append(",");
        }
        String strCookieMappings = "";
        if (strBuffer.length() > 0) {
            strCookieMappings = strBuffer.substring(0, strBuffer.length() - 1);
        }
        nametable.put("iplanet-am-platform-lb-cookie-value-list", strCookieMappings);
    }

    static {
        namingDebug = null;
        namingTable = null;
        platformProperties = null;
        server_proto = null;
        server_host = null;
        server_port = null;
        sso = null;
        ssmNaming = null;
        ssmPlatform = null;
        scmNaming = null;
        scmPlatform = null;
        sessionServiceConfig = null;
        sessionConfig = null;
        delimiter = "|";
        namingDebug = Debug.getInstance((String)"amNaming");
        platformProperties = SystemProperties.getAll();
        server_proto = platformProperties.getProperty("com.iplanet.am.server.protocol", "");
        server_host = platformProperties.getProperty("com.iplanet.am.server.host", "");
        server_port = platformProperties.getProperty("com.iplanet.am.server.port", "");
        try {
            SSOTokenManager mgr = SSOTokenManager.getInstance();
            String adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
            String adminPassword = (String)AccessController.doPrivileged(new AdminPasswordAction());
            sso = mgr.createSSOToken(new AuthPrincipal(adminDN), adminPassword);
            ssmNaming = new ServiceSchemaManager("iPlanetAMNamingService", sso);
            ssmPlatform = new ServiceSchemaManager("iPlanetAMPlatformService", sso);
            scmNaming = new ServiceConfigManager("iPlanetAMNamingService", sso);
            scmPlatform = new ServiceConfigManager("iPlanetAMPlatformService", sso);
            serviceRevNumber = ssmPlatform.getRevisionNumber();
            if (serviceRevNumber < 20) {
                ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMSessionService", sso);
                sessionServiceConfig = scm.getGlobalConfig(null);
                sessionConfig = sessionServiceConfig.getSubConfigNames();
            }
            ssmNaming.addListener(new NamingService());
            ssmPlatform.addListener(new NamingService());
            scmNaming.addListener(new NamingService());
            scmPlatform.addListener(new NamingService());
        }
        catch (Exception ne) {
            namingDebug.error("Naming Initialization failed.", (Throwable)ne);
        }
    }
}

