/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.dctree;

import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import com.iplanet.ums.dctree.DomainComponent;
import com.iplanet.ums.dctree.DomainNotFoundException;
import com.iplanet.ums.dctree.InvalidDCRootException;
import com.sun.identity.shared.ldap.LDAPDN;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DomainComponentTree {
    private static I18n i18n = I18n.getInstance("amSDK");
    private PersistentObject m_dcRoot = null;
    private SSOToken m_token = null;

    public DomainComponentTree() {
    }

    public DomainComponentTree(SSOToken token, Guid dcRoot) throws InvalidDCRootException, UMSException {
        if (token == null) {
            throw new IllegalArgumentException(i18n.getString("ums-null-token"));
        }
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        this.setSSOToken(token);
        try {
            this.setDCRoot(dcRoot);
        }
        catch (EntryNotFoundException e) {
            throw new InvalidDCRootException(dcRoot.getDn(), e.getRootCause());
        }
    }

    void setSSOToken(SSOToken token) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        this.m_token = token;
    }

    SSOToken getSSOToken() {
        return this.m_token;
    }

    public void setDCRoot(Guid root) throws UMSException {
        SSOToken token = this.getSSOToken();
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        if (token != null) {
            this.m_dcRoot = UMSObject.getObject(token, root);
        }
    }

    public PersistentObject getDCRoot() {
        return this.m_dcRoot;
    }

    public DomainComponent addDomain(String domain) throws UMSException {
        if (domain == null || domain.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.m_dcRoot == null) {
            throw new InvalidDCRootException();
        }
        StringTokenizer st = new StringTokenizer(domain, ".");
        int nDoms = st.countTokens();
        String[] doms = new String[nDoms];
        int i = 0;
        while (st.hasMoreElements()) {
            doms[i++] = st.nextToken();
        }
        PersistentObject parent = UMSObject.getObject(this.getSSOToken(), this.m_dcRoot.getGuid());
        DomainComponent dc = null;
        for (i = 0; i < nDoms; ++i) {
            SearchResults results = parent.getChildren("dc=" + doms[nDoms - i - 1], null);
            try {
                dc = (DomainComponent)results.assertOneEntry();
            }
            catch (EntryNotFoundException e) {
                dc = new DomainComponent(this.getSSOToken(), doms[nDoms - i - 1]);
                parent.addChild(dc);
            }
            parent = UMSObject.getObject(this.getSSOToken(), dc.getGuid());
        }
        return dc;
    }

    public void removeDomain(String domain) throws UMSException {
        if (this.m_dcRoot == null) {
            return;
        }
        DomainComponent dc = this.getDomainComponent(domain);
        this.m_dcRoot.removeChild(dc);
    }

    public void setDomainMapping(String domain, PersistentObject org) throws UMSException {
        this.setDomainMapping(domain, org.getGuid());
    }

    public void setDomainMapping(String domain, Guid orgGuid) throws UMSException {
        DomainComponent dc = this.getDomainComponent(domain);
        dc.setAssociatedOrganization(orgGuid);
    }

    public void setDomainStatus(String domain, String status) throws DomainNotFoundException, UMSException {
        DomainComponent dc = this.getDomainComponent(domain);
        dc.setDomainStatus(status);
    }

    public String getDomainStatus(String domain) throws DomainNotFoundException, UMSException {
        DomainComponent dc = this.getDomainComponent(domain);
        return dc.getDomainStatus();
    }

    public String mapDomainToDN(String domain) {
        StringTokenizer st = new StringTokenizer(domain, ".");
        String dn = new String();
        while (st.hasMoreElements()) {
            dn = dn + "dc=" + st.nextToken() + ",";
        }
        dn = dn + this.getDCRoot().getDN();
        return dn;
    }

    public DomainComponent getDomainComponent(String domain) throws DomainNotFoundException, UMSException {
        String dn = this.mapDomainToDN(domain);
        try {
            DomainComponent dc = (DomainComponent)UMSObject.getObject(this.getSSOToken(), new Guid(dn));
            dc.setSSOToken(this.getSSOToken());
            return dc;
        }
        catch (EntryNotFoundException e) {
            throw new DomainNotFoundException(domain, e.getRootCause());
        }
    }

    public PersistentObject getOrganization(String domain) throws DomainNotFoundException, UMSException {
        DomainComponent dc = this.getDomainComponent(domain);
        return dc.getOrganization();
    }

    public User getUser(String uid, String domain) throws DomainNotFoundException, UMSException {
        return this.getUser("uid", uid, domain);
    }

    public User getUser(String namingAttribute, String value, String domain) throws DomainNotFoundException, UMSException {
        PersistentObject orgEntry = this.getOrganization(domain);
        SearchResults result = orgEntry.search(namingAttribute + "=" + value, null);
        return (User)result.assertOneEntry();
    }

    public String mapDCToDomainName(DomainComponent dc) {
        if (this.m_dcRoot == null) {
            return null;
        }
        String rootDN = LDAPDN.normalize((String)this.m_dcRoot.getDN());
        String dcDN = LDAPDN.normalize((String)dc.getDN());
        int end = dcDN.indexOf("," + rootDN);
        dcDN = dcDN.substring(0, end);
        String[] doms = LDAPDN.explodeDN((String)dcDN, (boolean)true);
        String domainName = doms[0];
        for (int i = 1; i < doms.length; ++i) {
            domainName = domainName + "." + doms[i];
        }
        return domainName;
    }

    public Hashtable getChildDomainIDs() throws UMSException {
        if (this.m_dcRoot == null) {
            return null;
        }
        SearchResults results = this.m_dcRoot.search("(&(objectclass=inetDomain)(inetDomainBaseDN=*))", null);
        Hashtable<String, String> domains = new Hashtable<String, String>();
        while (results.hasMoreElements()) {
            DomainComponent dc = (DomainComponent)results.next();
            String domainName = this.mapDCToDomainName(dc);
            domains.put(domainName, dc.getAssociatedOrganizationGuid().getDn());
        }
        return domains;
    }
}

