/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CLIUtil;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class SetServerConfigXML
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String serverName = this.getStringOptionValue("servername");
        String xmlFile = this.getStringOptionValue("xmlfile");
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (ServerConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            String[] params = new String[]{serverName};
            this.writeLog(0, Level.INFO, "ATTEMPT_SET_SERVER_CONFIG_XML", params);
            String xml = xmlFile;
            boolean isWebEnabled = this.getCommandManager().webEnabled();
            if (!isWebEnabled) {
                xml = CLIUtil.getFileContent(this.getCommandManager(), xmlFile);
            }
            ServerConfiguration.setServerConfigXML(adminSSOToken, serverName, xml);
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("set-serverconfig-xml-succeeded"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_SET_SERVER_CONFIG_XML", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("SetServerConfigXML.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVER_CONFIG_XML", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("SetServerConfigXML.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVER_CONFIG_XML", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{serverName, e.getMessage()};
            this.debugError("SetServerConfigXML.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_SET_SERVER_CONFIG_XML", args);
            throw new CLIException(e, 127);
        }
    }
}

