/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.am.util.SystemProperties;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FQDNUtils {
    private static FQDNUtils instance = new FQDNUtils();
    private Map fqdnMap;
    private String defaultHostName;
    private Set validHostNames;

    private FQDNUtils() {
        this.init();
    }

    public static FQDNUtils getInstance() {
        return instance;
    }

    public void init() {
        this.fqdnMap = this.getFQDNMapFromAMConfig();
        this.defaultHostName = SystemProperties.get("com.iplanet.am.server.host");
        this.validHostNames = this.getLowerCaseValuesFromMap(this.fqdnMap);
        this.validHostNames.add(this.defaultHostName.toLowerCase());
    }

    public FQDNUtils(Map fqdnMap, String defaultHostName) {
        this.fqdnMap = fqdnMap;
        this.defaultHostName = defaultHostName;
        this.validHostNames = this.getLowerCaseValuesFromMap(fqdnMap);
        this.validHostNames.add(defaultHostName.toLowerCase());
    }

    private Map getFQDNMapFromAMConfig() {
        HashMap<String, String> map = new HashMap<String, String>();
        String prefix = "com.sun.identity.server.fqdnMap[";
        int prefixLen = prefix.length();
        Enumeration<?> e = SystemProperties.getAll().propertyNames();
        while (e.hasMoreElements()) {
            int idx;
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix) || (idx = key.indexOf(93, prefixLen + 1)) == -1) continue;
            String partialName = key.substring(prefixLen, idx);
            if ((partialName = partialName.trim()).length() <= 0) continue;
            map.put(partialName, SystemProperties.get(key));
        }
        return map;
    }

    private Set getLowerCaseValuesFromMap(Map map) {
        HashSet<String> set = new HashSet<String>();
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            set.add(((String)iter.next()).toLowerCase());
        }
        return set;
    }

    public boolean isHostnameValid(String hostname) {
        return hostname != null && this.validHostNames.contains(hostname.toLowerCase());
    }

    public String getFullyQualifiedHostName(String hostname) {
        String fqHostName = null;
        if (!(this.isHostnameValid(hostname) || (fqHostName = (String)this.fqdnMap.get(hostname)) != null && fqHostName.length() != 0)) {
            fqHostName = this.defaultHostName;
        }
        return fqHostName;
    }
}

