/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ISubConfigNames;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.Set;

public class SessionSiteNames
implements ISubConfigNames {
    private static final String SESSION_SVC_NAME = "iPlanetAMSessionService";
    private static final String SUBSCHEMA_SITE = "Site";
    private Debug debug = Debug.getInstance((String)"amSetupServlet");

    public Set getNames() {
        Set names = Collections.EMPTY_SET;
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            Set possibleNames = SiteConfiguration.getSites(adminToken);
            if (possibleNames != null && !possibleNames.isEmpty()) {
                Set existingNames = this.getExistingNames(adminToken);
                if (existingNames != null) {
                    possibleNames.removeAll(existingNames);
                }
                names = possibleNames;
            }
        }
        catch (SMSException ex) {
            this.debug.error("SessionSiteNames.getNames", (Throwable)ex);
        }
        catch (SSOException ex) {
            this.debug.error("SessionSiteNames.getNames", (Throwable)((Object)ex));
        }
        return names;
    }

    private Set getExistingNames(SSOToken adminToken) {
        try {
            ServiceConfigManager scm = new ServiceConfigManager(SESSION_SVC_NAME, adminToken);
            ServiceConfig serviceConfig = scm.getGlobalConfig(null);
            return serviceConfig.getSubConfigNames("*", SUBSCHEMA_SITE);
        }
        catch (SMSException ex) {
            this.debug.error("SessionSiteNames.getExistingNames", (Throwable)ex);
        }
        catch (SSOException ex) {
            this.debug.error("SessionSiteNames.getExistingNames", (Throwable)((Object)ex));
        }
        return null;
    }
}

