/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMAdminConstants;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSEntry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AMFormatUtils
implements AMAdminConstants {
    public static List sortItems(Collection collection, Locale locale) {
        ArrayList sorted = Collections.EMPTY_LIST;
        if (collection != null && !collection.isEmpty()) {
            sorted = new ArrayList(collection);
            Collator collator = Collator.getInstance(locale);
            Collections.sort(sorted, collator);
        }
        return sorted;
    }

    public static Map reverseStringMap(Map map) {
        HashMap mapReverse = Collections.EMPTY_MAP;
        if (map != null && !map.isEmpty()) {
            mapReverse = new HashMap(map.size() * 2);
            for (String key : map.keySet()) {
                mapReverse.put(map.get(key), key);
            }
        }
        return mapReverse;
    }

    public static List sortKeyInMap(Map map, Locale locale) {
        List sorted = Collections.EMPTY_LIST;
        if (map != null && !map.isEmpty()) {
            sorted = AMFormatUtils.sortItems(map.keySet(), locale);
        }
        return sorted;
    }

    public static OptionList getSortedOptionList(Map map, Locale locale) {
        OptionList optionList = new OptionList();
        Map reversed = AMFormatUtils.reverseStringMap(map);
        List sorted = AMFormatUtils.sortItems(reversed.keySet(), locale);
        for (String label : sorted) {
            optionList.add(label, (String)reversed.get(label));
        }
        return optionList;
    }

    public static String DNToName(AMModel model, String dn) {
        String ret = dn;
        if (DN.isDN((String)dn)) {
            if (LDAPDN.equals((String)dn, (String)SMSEntry.getRootSuffix())) {
                ret = model.getLocalizedString("top.level.realm");
            } else {
                String[] comps = LDAPDN.explodeDN((String)dn, (boolean)true);
                ret = comps[0];
            }
        }
        return ret;
    }

    public static List sortMapByValue(Map map, Locale locale) {
        ArrayList listSorted = Collections.EMPTY_LIST;
        if (map != null && !map.isEmpty()) {
            Map mapReverse = AMFormatUtils.reverseStringMap(map);
            List sortedKey = AMFormatUtils.sortKeyInMap(mapReverse, locale);
            listSorted = new ArrayList(sortedKey.size());
            for (String key : sortedKey) {
                listSorted.addAll((Set)mapReverse.get(key));
            }
        }
        return listSorted;
    }

    public static String replaceString(String originalString, String token, String newString) {
        int lenToken = token.length();
        int idx = originalString.indexOf(token);
        while (idx != -1) {
            originalString = originalString.substring(0, idx) + newString + originalString.substring(idx + lenToken);
            idx = originalString.indexOf(token, idx + lenToken);
        }
        return originalString;
    }

    public static String toCommaSeparatedFormat(Set set) {
        StringBuffer buff = new StringBuffer();
        boolean firstEntry = true;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            if (!firstEntry) {
                buff.append(", ");
            } else {
                firstEntry = false;
            }
            buff.append((String)iter.next());
        }
        return buff.toString();
    }

    public static String getIdentityDisplayName(AMModel model, String universalId) {
        String name = "";
        try {
            name = AMFormatUtils.getIdentityDisplayName(model, IdUtils.getIdentity(model.getUserSSOToken(), universalId));
        }
        catch (IdRepoException e) {
            AMModelBase.debug.warning("AMFormatUtils.getIdentityDisplayName Could not get display name returning universalId " + universalId);
        }
        return name;
    }

    public static String getIdentityDisplayName(AMModel model, AMIdentity entity) {
        String name = entity.getName();
        IdType type = entity.getType();
        if (type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE)) {
            String dn = name.replaceAll("_", ",");
            if (DN.isDN((String)dn) && dn.endsWith(SMSEntry.getRootSuffix())) {
                String[] rdns = LDAPDN.explodeDN((String)dn, (boolean)true);
                name = rdns[0] + " " + model.getLocalizedString("admin_suffix.name");
            }
        } else if (type.equals(IdType.USER)) {
            name = model.getUserDisplayName(entity);
        }
        return name;
    }
}

