/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.delegation.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMAuthUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.delegation.model.DelegationConfigNode;
import com.sun.identity.delegation.DelegationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegationConfig {
    private static final String CONFIG_FILENAME = "amAccessControl.xml";
    private static DelegationConfig instance = new DelegationConfig();
    private Map mapViewBeanToActionHandler = new HashMap();
    private Set ignore = new HashSet();
    private static final String NODE_NAME_VIEWBEAN = "viewbean";
    private static final String NODE_NAME_IGNORE = "neednodealwith";
    private static final String NODE_NAME_ACTION_HANDLER = "actionhandler";
    private static final String NODE_NAME_STATIC_TEXT = "statictext";
    private static final String NODE_NAME_TABLE = "table";
    private static final String ATTR_NAME_VIEW = "view";
    private static final String ATTR_NAME_MODIFY = "modify";

    private DelegationConfig() {
        Document doc = this.parseDocument(CONFIG_FILENAME);
        this.configure(doc);
    }

    private Document parseDocument(String fileName) {
        Document document = null;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            dbFactory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new DefaultHandler());
            document = documentBuilder.parse(is);
        }
        catch (UnsupportedEncodingException e) {
            AMModelBase.debug.error("DelegationConfig.parseDocument", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            AMModelBase.debug.error("DelegationConfig.parseDocument", (Throwable)e);
        }
        catch (SAXException e) {
            AMModelBase.debug.error("DelegationConfig.parseDocument", (Throwable)e);
        }
        catch (IOException e) {
            AMModelBase.debug.error("DelegationConfig.parseDocument", (Throwable)e);
        }
        return document;
    }

    private void configure(Document doc) {
        Node node;
        int i;
        int sz;
        NodeList nodes = doc.getElementsByTagName(NODE_NAME_VIEWBEAN);
        if (nodes != null) {
            sz = nodes.getLength();
            for (i = 0; i < sz; ++i) {
                node = nodes.item(i);
                this.configureViewBean(node);
            }
        }
        if ((nodes = doc.getElementsByTagName(NODE_NAME_IGNORE)) != null) {
            sz = nodes.getLength();
            for (i = 0; i < sz; ++i) {
                node = nodes.item(i);
                this.ignore.add(this.getAttribute(node, "classname"));
            }
        }
    }

    private String getAttribute(Node node, String attrName) {
        String value = null;
        NamedNodeMap attrs = node.getAttributes();
        Node nodeID = attrs.getNamedItem(attrName);
        if (nodeID != null) {
            value = nodeID.getNodeValue();
            value = value.trim();
        }
        return value;
    }

    private void configureViewBean(Node parent) {
        String viewbeanClassName = this.getAttribute(parent, "classname");
        if (viewbeanClassName != null && viewbeanClassName.length() > 0) {
            DelegationConfigNode configNode = new DelegationConfigNode(viewbeanClassName);
            String permView = this.getAttribute(parent, ATTR_NAME_VIEW);
            configNode.setPermissions("READ", AMAdminUtils.getDelimitedValues(permView, ","));
            String permModify = this.getAttribute(parent, ATTR_NAME_MODIFY);
            configNode.setPermissions("MODIFY", AMAdminUtils.getDelimitedValues(permModify, ","));
            this.mapViewBeanToActionHandler.put(viewbeanClassName, configNode);
            NodeList children = parent.getChildNodes();
            if (children != null) {
                int sz = children.getLength();
                for (int i = 0; i < sz; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeName().equals(NODE_NAME_ACTION_HANDLER)) {
                        String actionhandlers = this.getAttribute(child, "name");
                        configNode.setActionHandlers(AMAdminUtils.getDelimitedValues(actionhandlers, ","));
                        continue;
                    }
                    if (child.getNodeName().equals(NODE_NAME_TABLE)) {
                        String tables = this.getAttribute(child, "name");
                        configNode.setTables(AMAdminUtils.getDelimitedValues(tables, ","));
                        continue;
                    }
                    if (!child.getNodeName().equals(NODE_NAME_STATIC_TEXT)) continue;
                    String statictexts = this.getAttribute(child, "name");
                    configNode.setStaticTexts(AMAdminUtils.getDelimitedValues(statictexts, ","));
                }
            }
        }
    }

    public static DelegationConfig getInstance() {
        return instance;
    }

    public boolean hasPermission(String realmName, String serviceName, String action, HttpServletRequest req, String viewbeanClassName) {
        boolean hasPermission = false;
        try {
            SSOToken ssoToken = AMAuthUtils.getSSOToken(req);
            hasPermission = this.hasPermission(realmName, serviceName, action, ssoToken, viewbeanClassName);
        }
        catch (SSOException e) {
            AMModelBase.debug.warning("AccessControlModelImpl.<init>", (Throwable)((Object)e));
        }
        return hasPermission;
    }

    public boolean hasPermission(String realmName, String serviceName, String action, AMModel model, String viewbeanClassName) {
        return this.hasPermission(realmName, serviceName, action, model.getUserSSOToken(), viewbeanClassName);
    }

    public boolean hasPermission(String realmName, String serviceName, String action, SSOToken ssoToken, String viewbeanClassName) {
        boolean hasPermission = false;
        DelegationConfigNode configNode = (DelegationConfigNode)this.mapViewBeanToActionHandler.get(viewbeanClassName);
        if (configNode != null) {
            try {
                hasPermission = configNode.hasPermission(realmName, serviceName, action, ssoToken);
            }
            catch (DelegationException e) {
                AMModelBase.debug.error("DelegationConfig.hasPermission", (Throwable)e);
            }
        } else if (this.ignore.contains(viewbeanClassName)) {
            hasPermission = true;
        } else {
            AMModelBase.debug.error("DelegationConfig.hasPermission: cannot find access control information for " + viewbeanClassName);
        }
        return hasPermission;
    }

    public void configureButtonsAndTables(String realmName, String serviceName, AMModel model, AMViewBeanBase viewbean) {
        String viewbeanClassName = ((Object)((Object)viewbean)).getClass().getName();
        DelegationConfigNode configNode = (DelegationConfigNode)this.mapViewBeanToActionHandler.get(viewbeanClassName);
        if (configNode != null) {
            try {
                configNode.configureButtonsAndTables(realmName, serviceName, model, viewbean);
            }
            catch (DelegationException e) {
                AMModelBase.debug.error("DelegationConfig.configureButtons", (Throwable)e);
            }
        } else if (!this.ignore.contains(viewbeanClassName)) {
            AMModelBase.debug.error("DelegationConfig.configureButtons: cannot find access control information for " + viewbeanClassName);
        }
    }

    public boolean isUncontrolledViewBean(String viewBeanClassName) {
        return this.ignore.contains(viewBeanClassName);
    }
}

