/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.dm.RolePropertiesBase;
import com.sun.identity.console.dm.model.RoleModel;
import com.sun.identity.console.dm.model.RoleModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Map;

public class RoleEditServiceViewBean
extends RolePropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/RoleEditService.jsp";
    private static final String PAGE_TITLE = "pgtitle";
    private static final String PROPERTY_ATTRIBUTES = "propertyAttributes";
    private AMPropertySheetModel psModel = null;
    public String location = null;

    public RoleEditServiceViewBean() {
        super("RoleEditService");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String curgroup;
        if (!this.initialized && (curgroup = (String)this.getPageSessionAttribute("CurrentProfileView")) != null) {
            super.initialize();
            this.createPageTitleModel();
            this.createPropertyModel();
            this.registerChildren();
            this.initialized = true;
        }
    }

    protected void registerChildren() {
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.psModel.registerChildren((ContainerViewBase)this);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTES) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.psModel, name) : (this.psModel.isChildSupported(name) ? this.psModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.model = (RoleModel)this.getModel();
        if (this.model != null) {
            try {
                String name = (String)this.getPageSessionAttribute("CurrentProfileView");
                AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTES);
                this.psModel.clear();
                ps.setAttributeValues(this.model.getValues(name), this.model);
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("warning", "message.warning", "noproperties.message");
            }
        }
        this.setPageTitle();
    }

    public void setPageTitle() {
        String title = "page.title.edit.role.service";
        String service = (String)this.getPageSessionAttribute("currentServiceName");
        if (service != null) {
            service = this.model.getLocalizedServiceName(service);
        }
        RoleModel model = (RoleModel)this.getModel();
        Object[] tmp = new String[]{service};
        this.ptModel.setPageTitleText(MessageFormat.format(model.getLocalizedString(title), tmp));
    }

    protected AMModel getModelInternal() {
        if (this.model == null) {
            RequestContext rc = RequestManager.getRequestContext();
            this.model = new RoleModelImpl(rc.getRequest(), this.getPageSessionAttributes());
        }
        return this.model;
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        RoleModel model = (RoleModel)this.getModel();
        String name = (String)this.getPageSessionAttribute("CurrentProfileView");
        String service = (String)this.getPageSessionAttribute("currentServiceName");
        try {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTES);
            Map values = ps.getAttributeValues(model.getValues(name), false, model);
            model.updateRole(name, values);
            this.setInlineAlertMessage("info", "message.information", model.getLocalizedString("message.updated"));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        this.forwardTo();
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
    }

    private void createPropertyModel() {
        RoleModel model = (RoleModel)this.getModel();
        String role = (String)this.getPageSessionAttribute("CurrentProfileView");
        String service = (String)this.getPageSessionAttribute("currentServiceName");
        this.psModel = new AMPropertySheetModel(model.getServiceXML(service));
        this.psModel.clear();
    }
}

