/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.delegation.plugins;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationManager;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.delegation.DelegationPrivilege;
import com.sun.identity.delegation.interfaces.DelegationInterface;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdEventListener;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyEvent;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.interfaces.PolicyListener;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class DelegationPolicyImpl
implements DelegationInterface,
ServiceListener,
IdEventListener,
PolicyListener {
    private static final String POLICY_REPOSITORY_REALM = "/sunamhiddenrealmdelegationservicepermissions";
    private static final String NAME_DELIMITER = "^^";
    private static final char REPLACEMENT_FOR_COMMA = '^';
    private static final String PREFIX = "sms://";
    private static final String DELIMITER = "/";
    private static final String ACTION_ALLOW = "allow";
    private static final String ACTION_DENY = "deny";
    private static final String DELEGATION_RULE = "delegation-rule";
    private static final String DELEGATION_SUBJECT = "delegation-subject";
    private static final String POLICY_SUBJECT = "AMIdentitySubject";
    private static final String AUTHN_USERS_ID = "id=All Authenticated Users,ou=role," + ServiceManager.getBaseDN();
    private static final String DELEGATION_AUTHN_USERS = "AuthenticatedUsers";
    private static final String AUTHENTICATED_USERS_SUBJECT = "AuthenticatedUsers";
    private static final String CONFIGURED_CACHE_SIZE = "com.sun.identity.delegation.cache.size";
    private static final int DEFAULT_CACHE_SIZE = 20000;
    private static Cache delegationCache;
    private static int maxCacheSize;
    private static Map idRepoListeners;
    private static ServiceConfigManager scm;
    private SSOToken appToken;
    private PolicyEvaluator pe;

    public void initialize(SSOToken token, Map configParams) throws DelegationException {
        this.appToken = token;
        try {
            OrganizationConfigManager ocm;
            Set orgNames;
            String cacheSize = SystemProperties.get(CONFIGURED_CACHE_SIZE);
            if (cacheSize != null) {
                try {
                    maxCacheSize = Integer.parseInt(cacheSize);
                    if (maxCacheSize < 0) {
                        maxCacheSize = 20000;
                    }
                }
                catch (NumberFormatException nfe) {
                    DelegationManager.debug.error("DelegationPolicyImpl.initialize(): invalid cache size specified in AMConfig.properties. Use default cache size 20000");
                    maxCacheSize = 20000;
                }
            }
            delegationCache = new Cache(maxCacheSize);
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.initialize(): cache size=" + maxCacheSize);
            }
            this.pe = new PolicyEvaluator(POLICY_REPOSITORY_REALM, "sunAMDelegationService");
            this.pe.addPolicyListener(this);
            AMIdentityRepository idRepo = new AMIdentityRepository(this.appToken, DELIMITER);
            idRepo.addEventListener(this);
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener added for root realm.");
            }
            if ((orgNames = (ocm = new OrganizationConfigManager(this.appToken, DELIMITER)).getSubOrganizationNames("*", true)) != null && !orgNames.isEmpty()) {
                for (String org : orgNames) {
                    AMIdentityRepository idr = new AMIdentityRepository(this.appToken, org);
                    idr.addEventListener(this);
                    idRepoListeners.put(org, idRepo);
                    if (!DelegationManager.debug.messageEnabled()) continue;
                    DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener added for realm (" + org + ").");
                }
            }
            scm = new ServiceConfigManager("iPlanetAMPolicyConfigService", token);
            scm.addListener(this);
        }
        catch (Exception e) {
            DelegationManager.debug.error("DelegationPolicyImpl: initialize() failed");
            throw new DelegationException(e);
        }
    }

    public Set getPrivileges(SSOToken token, String orgName) throws SSOException, DelegationException {
        try {
            PolicyManager pm;
            Set pnames;
            HashSet<DelegationPrivilege> privileges = new HashSet<DelegationPrivilege>();
            if (this.hasDelegationPermissionsForRealm(token, orgName)) {
                token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
            if ((pnames = (pm = new PolicyManager(token, POLICY_REPOSITORY_REALM)).getPolicyNames()) != null) {
                String prefix = null;
                if (orgName != null) {
                    prefix = orgName.toLowerCase() + NAME_DELIMITER;
                    prefix = prefix.replace(',', '^');
                } else {
                    prefix = NAME_DELIMITER;
                }
                int prefixLength = prefix.length();
                for (String pname : pnames) {
                    Policy p;
                    DelegationPrivilege dp;
                    if (!pname.toLowerCase().startsWith(prefix) || (dp = this.policyToPrivilege(p = pm.getPolicy(pname))) == null) continue;
                    dp.setName(pname.substring(prefixLength));
                    privileges.add(dp);
                }
            }
            return privileges;
        }
        catch (Exception e) {
            DelegationManager.debug.error("unable to get privileges from realm " + orgName);
            throw new DelegationException(e);
        }
    }

    public void addPrivilege(SSOToken token, String orgName, DelegationPrivilege privilege) throws SSOException, DelegationException {
        block7: {
            if (privilege != null) {
                try {
                    PolicyManager pm;
                    Policy p;
                    if (this.hasDelegationPermissionsForRealm(token, orgName)) {
                        token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    }
                    if ((p = this.privilegeToPolicy(pm = new PolicyManager(token, POLICY_REPOSITORY_REALM), privilege, orgName)) != null) {
                        Set existingPolicies = pm.getPolicyNames();
                        if (existingPolicies.contains(p.getName())) {
                            pm.replacePolicy(p);
                        } else {
                            pm.addPolicy(p);
                        }
                        break block7;
                    }
                    throw new DelegationException("amDelegation", "invalid_delegation_privilege", null, null);
                }
                catch (Exception e) {
                    throw new DelegationException(e);
                }
            }
        }
    }

    public void removePrivilege(SSOToken token, String orgName, String privilegeName) throws SSOException, DelegationException {
        try {
            if (this.hasDelegationPermissionsForRealm(token, orgName)) {
                token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
            PolicyManager pm = new PolicyManager(token, POLICY_REPOSITORY_REALM);
            String prefix = null;
            if (orgName != null) {
                prefix = orgName.toLowerCase() + NAME_DELIMITER;
                prefix = prefix.replace(',', '^');
            } else {
                prefix = NAME_DELIMITER;
            }
            pm.removePolicy(prefix + privilegeName);
        }
        catch (Exception e) {
            throw new DelegationException(e);
        }
    }

    public Set getSubjects(SSOToken token, String orgName, Set types, String pattern) throws SSOException, DelegationException {
        HashSet<String> results = new HashSet<String>();
        if (pattern != null && pattern.equals("*")) {
            results.add(AUTHN_USERS_ID);
        }
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl.getSubjects(): types=" + types);
        }
        try {
            AMIdentityRepository idRepo = new AMIdentityRepository(this.appToken, orgName);
            Set supportedTypes = idRepo.getSupportedIdTypes();
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.getSubjects(): supported subject types=" + supportedTypes);
            }
            if (supportedTypes != null && !supportedTypes.isEmpty() && types != null && !types.isEmpty()) {
                Iterator it = types.iterator();
                while (it.hasNext()) {
                    Set searchRes;
                    IdType idType = IdUtils.getType((String)it.next());
                    if (!supportedTypes.contains(idType)) continue;
                    IdSearchControl ctrl = new IdSearchControl();
                    ctrl.setRecursive(true);
                    ctrl.setMaxResults(-1);
                    ctrl.setTimeOut(-1);
                    IdSearchResults idsr = idRepo.searchIdentities(idType, pattern, ctrl);
                    if (idsr == null || (searchRes = idsr.getSearchResults()) == null || searchRes.isEmpty()) continue;
                    for (AMIdentity id : searchRes) {
                        results.add(IdUtils.getUniversalId(id));
                    }
                }
            }
            return results;
        }
        catch (IdRepoException ide) {
            throw new DelegationException(ide);
        }
    }

    public Set getManageableOrganizationNames(SSOToken token, Set organizationNames) throws SSOException, DelegationException {
        HashSet<String> names = new HashSet<String>();
        if (organizationNames != null && !organizationNames.isEmpty()) {
            for (String orgName : organizationNames) {
                Set perms = this.getPermissions(token, orgName);
                if (perms == null || perms.isEmpty()) continue;
                names.add(orgName);
            }
        }
        return names;
    }

    public boolean isAllowed(SSOToken token, DelegationPermission permission, Map envParams) throws SSOException, DelegationException {
        SSOTokenID tokenId;
        String resource = null;
        boolean result = false;
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl.isAllowed() is called");
        }
        if (token != null && (tokenId = token.getTokenID()) != null && permission != null) {
            String tokenIdStr = ((Object)tokenId).toString();
            Set actions = permission.getActions();
            if (actions != null && !actions.isEmpty()) {
                try {
                    Map ads;
                    resource = this.getResourceName(permission);
                    PolicyDecision pd = DelegationPolicyImpl.getResultFromCache(tokenIdStr, resource, envParams);
                    if (pd != null) {
                        if (DelegationManager.debug.messageEnabled()) {
                            DelegationManager.debug.message("got delegation evaluation result from cache.");
                        }
                    } else {
                        pd = this.pe.getPolicyDecision(token, resource, null, envParams);
                        DelegationPolicyImpl.putResultIntoCache(tokenIdStr, resource, envParams, pd);
                        if (DelegationManager.debug.messageEnabled()) {
                            DelegationManager.debug.message("put delegation evaluation result into cache.");
                        }
                    }
                    if ((ads = pd.getActionDecisions()) != null && !ads.isEmpty()) {
                        result = true;
                        Iterator it = actions.iterator();
                        while (it.hasNext() && result) {
                            String actionName = (String)it.next();
                            ActionDecision ad = (ActionDecision)ads.get(actionName);
                            if (ad != null) {
                                Set values = ad.getValues();
                                if (values != null && !values.contains(ACTION_DENY)) continue;
                                result = false;
                                continue;
                            }
                            result = false;
                        }
                    }
                }
                catch (PolicyException pe) {
                    throw new DelegationException(pe);
                }
            }
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.isAllowed(): actions=" + actions + "  resource=" + resource + "  result is:" + result);
            }
        }
        return result;
    }

    private static PolicyDecision getResultFromCache(String tokenIdStr, String resource, Map envParams) throws SSOException, DelegationException {
        ArrayList al;
        Map items;
        if (resource != null && (items = (Map)delegationCache.get(tokenIdStr)) != null && !items.isEmpty() && (al = (ArrayList)items.get(resource)) != null) {
            PolicyDecision pd;
            Map cachedEnv = (Map)al.get(0);
            if (envParams == null || envParams.isEmpty()) {
                envParams = Collections.EMPTY_MAP;
            }
            if (cachedEnv == null || cachedEnv.isEmpty()) {
                cachedEnv = Collections.EMPTY_MAP;
            }
            if (((Object)envParams).equals(cachedEnv) && (pd = (PolicyDecision)al.get(1)) != null) {
                long currentTime;
                long pdTTL = pd.getTimeToLive();
                if (pdTTL > (currentTime = System.currentTimeMillis())) {
                    return pd;
                }
                if (DelegationManager.debug.messageEnabled()) {
                    DelegationManager.debug.message("DelegationPolicyImpl: delegation decision expired.  TTL=" + pdTTL + "; current time=" + currentTime);
                }
            }
        }
        return null;
    }

    private static void putResultIntoCache(String tokenIdStr, String resource, Map envParams, PolicyDecision pd) throws SSOException, DelegationException {
        if (resource != null) {
            ArrayList<Object> al = new ArrayList<Object>(2);
            al.add(0, envParams);
            al.add(1, pd);
            HashMap items = (HashMap)delegationCache.get(tokenIdStr);
            if (items == null) {
                items = new HashMap();
            }
            items.put(resource, al);
            delegationCache.put(tokenIdStr, items);
        }
    }

    private static void cleanupCache() {
        if (delegationCache.size() > 0) {
            delegationCache = new Cache(maxCacheSize);
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("DelegationPolicyImpl.cleanupCache(): cache cleared");
            }
        }
    }

    public Set getPermissions(SSOToken token, String orgName) throws SSOException, DelegationException {
        HashSet perms = new HashSet();
        AMIdentity userIdentity = null;
        AMIdentity subjectIdentity = null;
        IdSearchResults results = null;
        if (token == null) {
            if (DelegationManager.debug.warningEnabled()) {
                DelegationManager.debug.warning("DelegationPolicyImpl.getPermissions():user sso token is null");
            }
            return perms;
        }
        try {
            userIdentity = IdUtils.getIdentity(token);
            if (userIdentity == null) {
                if (DelegationManager.debug.warningEnabled()) {
                    DelegationManager.debug.warning("DelegationPolicyImpl.getPermissions():could not get user's identity from token");
                }
                return perms;
            }
            Set privileges = this.getPrivileges(this.appToken, orgName);
            if (privileges != null && !privileges.isEmpty()) {
                AMIdentityRepository idRepo = new AMIdentityRepository(this.appToken, orgName);
                IdSearchControl ctrl = new IdSearchControl();
                ctrl.setRecursive(true);
                ctrl.setMaxResults(-1);
                ctrl.setTimeOut(-1);
                for (DelegationPrivilege dp : privileges) {
                    Set subjects = dp.getSubjects();
                    if (subjects == null || subjects.isEmpty()) continue;
                    for (String subject : subjects) {
                        Set idSet;
                        String subjectId = new DN(subject).explodeDN(true)[0];
                        if (subjectId == null || (results = idRepo.searchIdentities(IdType.ROLE, subjectId, ctrl)) == null || (idSet = results.getSearchResults()) == null || idSet.isEmpty() || !userIdentity.isMember(subjectIdentity = (AMIdentity)idSet.iterator().next())) continue;
                        perms.addAll(dp.getPermissions());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DelegationException(e);
        }
        return perms;
    }

    private Policy privilegeToPolicy(PolicyManager pm, DelegationPrivilege priv, String orgName) throws DelegationException {
        try {
            HashSet sv;
            String prefix = null;
            if (orgName != null) {
                prefix = orgName.toLowerCase() + NAME_DELIMITER;
                prefix = prefix.replace(',', '^');
            } else {
                prefix = NAME_DELIMITER;
            }
            String name = prefix + priv.getName();
            Policy policy = new Policy(name);
            Set permissions = priv.getPermissions();
            if (permissions != null && !permissions.isEmpty()) {
                Iterator pmit = permissions.iterator();
                int seqNum = 0;
                while (pmit.hasNext()) {
                    DelegationPermission perm = (DelegationPermission)pmit.next();
                    String resourceName = this.getResourceName(perm);
                    HashMap actions = new HashMap();
                    Set permActions = perm.getActions();
                    if (permActions != null) {
                        HashSet<String> values = new HashSet<String>();
                        values.add(ACTION_ALLOW);
                        for (String actionName : permActions) {
                            actions.put(actionName, values);
                        }
                    }
                    String ruleName = DELEGATION_RULE;
                    if (seqNum != 0) {
                        ruleName = ruleName + seqNum;
                    }
                    Rule rule = new Rule(ruleName, "sunAMDelegationService", resourceName, actions);
                    policy.addRule(rule);
                    ++seqNum;
                }
            }
            if ((sv = new HashSet(priv.getSubjects())) != null && sv.contains(AUTHN_USERS_ID)) {
                Subject allauthNUsers = pm.getSubjectTypeManager().getSubject("AuthenticatedUsers");
                policy.addSubject("AuthenticatedUsers", allauthNUsers);
                sv.remove(AUTHN_USERS_ID);
            }
            if (sv != null && !sv.isEmpty()) {
                Subject subject = pm.getSubjectTypeManager().getSubject(POLICY_SUBJECT);
                subject.setValues(sv);
                policy.addSubject(DELEGATION_SUBJECT, subject);
            }
            return policy;
        }
        catch (Exception e) {
            DelegationManager.debug.error("unable to convert a privilege to a policy", (Throwable)e);
            throw new DelegationException(e);
        }
    }

    private DelegationPrivilege policyToPrivilege(Policy policy) throws DelegationException {
        String pname = null;
        HashSet<DelegationPermission> permissions = new HashSet<DelegationPermission>();
        HashSet<String> svalues = new HashSet<String>();
        if (policy == null) {
            return null;
        }
        try {
            pname = policy.getName();
            Set snames = policy.getSubjectNames();
            if (snames != null && !snames.isEmpty()) {
                Subject subject;
                Set values;
                if (snames.contains("AuthenticatedUsers")) {
                    svalues.add(AUTHN_USERS_ID);
                }
                if (snames.contains(DELEGATION_SUBJECT) && (values = (subject = policy.getSubject(DELEGATION_SUBJECT)).getValues()) != null) {
                    svalues.addAll(values);
                }
            }
            if (DelegationManager.debug.messageEnabled()) {
                DelegationManager.debug.message("SubjectValues=" + svalues);
            }
            String realmName = null;
            String serviceName = null;
            String version = null;
            String configType = null;
            String subconfigName = null;
            String resource = null;
            Set actions = null;
            Set ruleNames = policy.getRuleNames();
            if (ruleNames != null && !ruleNames.isEmpty()) {
                for (String ruleName : ruleNames) {
                    String suffix;
                    Rule rule = policy.getRule(ruleName);
                    String service = rule.getServiceTypeName();
                    if (!service.equalsIgnoreCase("sunAMDelegationService")) continue;
                    resource = rule.getResourceName();
                    actions = rule.getActionNames();
                    if (resource.startsWith(PREFIX) && (suffix = resource.substring(PREFIX.length())) != null) {
                        StringTokenizer st = new StringTokenizer(suffix, DELIMITER);
                        realmName = st.nextToken();
                        if (st.hasMoreTokens()) {
                            serviceName = st.nextToken();
                            if (st.hasMoreTokens()) {
                                version = st.nextToken();
                                if (st.hasMoreTokens()) {
                                    configType = st.nextToken();
                                    if (st.hasMoreTokens()) {
                                        subconfigName = st.nextToken();
                                        while (st.hasMoreTokens()) {
                                            subconfigName = subconfigName + DELIMITER + st.nextToken();
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (DelegationManager.debug.messageEnabled()) {
                        DelegationManager.debug.message("DelegationPolicyImpl.policyToPrivilege(): create DelegationPermission object with: realm=" + realmName + "; service=" + serviceName + "; version=" + version + "; configType=" + configType + "; subconfig=" + subconfigName + "; actions=" + actions);
                    }
                    DelegationPermission dp = new DelegationPermission(realmName, serviceName, version, configType, subconfigName, actions, null);
                    permissions.add(dp);
                }
            }
            return new DelegationPrivilege(pname, permissions, svalues);
        }
        catch (Exception e) {
            throw new DelegationException(e);
        }
    }

    private String getResourceName(DelegationPermission perm) {
        String realmName = perm.getOrganizationName();
        String serviceName = perm.getServiceName();
        String version = perm.getVersion();
        String configType = perm.getConfigType();
        String subConfigName = perm.getSubConfigName();
        StringBuffer sb = new StringBuffer(100);
        sb.append(PREFIX);
        if (realmName != null) {
            sb.append(realmName);
        }
        sb.append(DELIMITER);
        if (serviceName != null) {
            sb.append(serviceName);
            sb.append(DELIMITER);
        }
        if (version != null) {
            sb.append(version);
            sb.append(DELIMITER);
        }
        if (configType != null) {
            sb.append(configType);
            sb.append(DELIMITER);
        }
        if (subConfigName != null) {
            sb.append(subConfigName);
        }
        return sb.toString();
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: org config changed: " + orgName);
        }
        Map map = idRepoListeners;
        synchronized (map) {
            if (type == 1) {
                if (idRepoListeners.get(orgName) == null) {
                    try {
                        AMIdentityRepository idRepo = new AMIdentityRepository(this.appToken, orgName);
                        idRepo.addEventListener(this);
                        idRepoListeners.put(orgName, idRepo);
                        if (DelegationManager.debug.messageEnabled()) {
                            DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener added for realm (" + orgName + ").");
                        }
                    }
                    catch (Exception e) {
                        DelegationManager.debug.error("DelegationPolicyImpl: failed to process organization config changes. ", (Throwable)e);
                    }
                }
            } else if (type == 2) {
                idRepoListeners.remove(orgName);
                if (DelegationManager.debug.messageEnabled()) {
                    DelegationManager.debug.message("DelegationPolicyImpl: IdRepo event listener removed for realm (" + orgName + ").");
                }
            }
        }
    }

    public void identityChanged(String universalId) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: changed universalId=" + universalId);
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public void identityDeleted(String universalId) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: deleted universalId=" + universalId);
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public void identityRenamed(String universalId) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: renamed universalId=" + universalId);
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public void allIdentitiesChanged() {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: all identities changed.");
        }
        DelegationPolicyImpl.cleanupCache();
    }

    public String getServiceTypeName() {
        return "sunAMDelegationService";
    }

    public void policyChanged(PolicyEvent policyEvent) {
        if (DelegationManager.debug.messageEnabled()) {
            DelegationManager.debug.message("DelegationPolicyImpl: delegation policy changed.");
        }
        DelegationPolicyImpl.cleanupCache();
    }

    private boolean hasDelegationPermissionsForRealm(SSOToken token, String orgName) throws SSOException, DelegationException {
        HashSet<String> action = new HashSet<String>();
        action.add("DELEGATE");
        DelegationPermission de = new DelegationPermission(orgName, "sunAMRealmService", "1.0", "organizationconfig", null, action, Collections.EMPTY_MAP);
        DelegationEvaluator evaluator = new DelegationEvaluator();
        return evaluator.isAllowed(token, de, Collections.EMPTY_MAP);
    }

    static {
        maxCacheSize = 20000;
        idRepoListeners = new HashMap();
    }
}

