/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.ValidateResourceResult;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.entitlement.util.JSONUtils;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entitlement {
    private String name;
    private String applicationName = "iPlanetAMWebAgentService";
    private Set<String> resourceNames;
    private Set<String> excludedResourceNames;
    private Map<String, Boolean> actionValues;
    private Map<String, Set<String>> advices;
    private Map<String, Set<String>> attributes;
    private Application application;

    public Entitlement() {
    }

    public Entitlement(JSONObject jo) throws JSONException {
        this.name = (String)jo.opt("name");
        this.applicationName = (String)jo.opt("applicationName");
        this.resourceNames = JSONUtils.getSet(jo, "resourceNames");
        this.excludedResourceNames = JSONUtils.getSet(jo, "excludedResourceNames");
        this.actionValues = JSONUtils.getMapStringBoolean(jo, "actionsValues");
        this.advices = JSONUtils.getMapStringSetString(jo, "advices");
        this.attributes = JSONUtils.getMapStringSetString(jo, "attributes");
    }

    public Entitlement(Set<String> resourceNames, Set<String> actionNames) {
        this.setResourceNames(resourceNames);
        this.setActionNames(actionNames);
    }

    public Entitlement(String resourceName, Set<String> actionNames) {
        this.setResourceName(resourceName);
        this.setActionNames(actionNames);
    }

    public Entitlement(String applicationName, String resourceName, Set<String> actionNames) {
        this.setApplicationName(applicationName);
        this.setResourceName(resourceName);
        this.setActionNames(actionNames);
    }

    public Entitlement(String resourceName, Map<String, Boolean> actionValues) {
        this.setResourceName(resourceName);
        this.setActionValues(actionValues);
    }

    public Entitlement(String applicationName, String resourceName, Map<String, Boolean> actionValues) {
        this.setApplicationName(applicationName);
        this.setResourceName(resourceName);
        this.setActionValues(actionValues);
    }

    public Entitlement(String applicationName, Set<String> resourceNames, Map<String, Boolean> actionValues) {
        this.setApplicationName(applicationName);
        this.setResourceNames(resourceNames);
        this.setActionValues(actionValues);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setResourceNames(Set<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public Set<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceName(String resourceName) {
        HashSet<String> rn = new HashSet<String>();
        rn.add(resourceName);
        this.setResourceNames(rn);
    }

    public String getResourceName() {
        if (this.resourceNames == null || this.resourceNames.isEmpty()) {
            return null;
        }
        return this.resourceNames.iterator().next();
    }

    public void setExcludedResourceNames(Set<String> excludedResourceNames) {
        this.excludedResourceNames = excludedResourceNames;
    }

    public Set<String> getExcludedResourceNames() {
        return this.excludedResourceNames == null ? Collections.EMPTY_SET : this.excludedResourceNames;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setActionName(String actionName) {
        this.actionValues = new HashMap<String, Boolean>();
        this.actionValues.put(actionName, Boolean.TRUE);
    }

    public void setActionNames(Set<String> actionNames) {
        this.actionValues = new HashMap<String, Boolean>();
        for (String i : actionNames) {
            this.actionValues.put(i, Boolean.TRUE);
        }
    }

    public void setActionValues(Map<String, Boolean> actionValues) {
        this.actionValues = new HashMap<String, Boolean>();
        for (String s : actionValues.keySet()) {
            Boolean b = actionValues.get(s) != false ? Boolean.TRUE : Boolean.FALSE;
            this.actionValues.put(s, b);
        }
    }

    public Boolean getActionValue(String name) {
        return this.actionValues.get(name);
    }

    public Map<String, Boolean> getActionValues() {
        return this.actionValues;
    }

    public Set<Object> getActionValues(String name) {
        Boolean o = this.actionValues.get(name);
        if (o instanceof Set) {
            return (Set)((Object)o);
        }
        HashSet<Object> set = new HashSet<Object>();
        set.add(o);
        return set;
    }

    public void setAdvices(Map<String, Set<String>> advices) {
        this.advices = advices;
    }

    public Map<String, Set<String>> getAdvices() {
        return this.advices;
    }

    public void setAttributes(Map<String, Set<String>> attributes) {
        this.attributes = attributes;
    }

    public Map<String, Set<String>> getAttributes() {
        return this.attributes;
    }

    public Set<String> evaluate(Subject adminSubject, String realm, Subject subject, String applicationName, String resourceName, Set<String> actionNames, Map<String, Set<String>> environment, boolean recursive) throws EntitlementException {
        for (String a : actionNames) {
            if (!this.actionValues.keySet().contains(a)) continue;
            return this.getMatchingResources(adminSubject, realm, subject, applicationName, resourceName, recursive);
        }
        return Collections.EMPTY_SET;
    }

    protected Set<String> getMatchingResources(Subject adminSubject, String realm, Subject subject, String applicationName, String resourceName, boolean recursive) throws EntitlementException {
        if (this.resourceNames == null || this.resourceNames.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (!this.applicationName.endsWith(applicationName)) {
            return Collections.EMPTY_SET;
        }
        ResourceName resComparator = this.getResourceComparator(adminSubject, realm);
        resourceName = resComparator.canonicalize(resourceName);
        HashSet<String> matched = new HashSet<String>();
        Set<String> resources = this.tagswapResourceNames(subject, this.resourceNames);
        for (String r : resources) {
            ResourceMatch match = resComparator.compare(resourceName, r, true);
            if (match.equals(ResourceMatch.EXACT_MATCH) || match.equals(ResourceMatch.WILDCARD_MATCH)) {
                matched.add(r);
                continue;
            }
            if (!recursive || !match.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
            matched.add(r);
        }
        Iterator i = matched.iterator();
        block1: while (i.hasNext()) {
            String r;
            r = (String)i.next();
            if (this.excludedResourceNames == null || this.excludedResourceNames.isEmpty()) continue;
            Set<String> excludes = this.tagswapResourceNames(subject, this.excludedResourceNames);
            for (String e : excludes) {
                ResourceMatch match = resComparator.compare(r, e, true);
                if (match.equals(ResourceMatch.EXACT_MATCH) || match.equals(ResourceMatch.WILDCARD_MATCH)) {
                    i.remove();
                    continue block1;
                }
                if (!recursive || !match.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
                i.remove();
                continue block1;
            }
        }
        return matched;
    }

    private Set<String> tagswapResourceNames(Subject sbj, Set<String> set) throws EntitlementException {
        if (sbj == null) {
            return set;
        }
        HashSet<String> resources = new HashSet<String>();
        HashSet<String> userIds = new HashSet<String>();
        Set<Principal> principals = sbj.getPrincipals();
        if (!principals.isEmpty()) {
            for (Principal p : principals) {
                String pName = p.getName();
                if (DN.isDN((String)pName)) {
                    String[] rdns = LDAPDN.explodeDN((String)pName, (boolean)true);
                    userIds.add(rdns[0]);
                    continue;
                }
                userIds.add(pName);
            }
        }
        if (!userIds.isEmpty()) {
            for (String r : set) {
                for (String uid : userIds) {
                    resources.add(r.replaceAll("\\$SELF", uid));
                }
            }
        }
        return resources;
    }

    public String toString() {
        String s = null;
        try {
            JSONObject jo = this.toJSONObject();
            s = jo == null ? super.toString() : jo.toString(2);
        }
        catch (JSONException joe) {
            PrivilegeManager.debug.error("Entitlement.toString()", (Throwable)joe);
        }
        return s;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jo = new JSONObject();
        jo.put("name", (Object)this.name);
        jo.put("applicationName", (Object)this.applicationName);
        if (this.resourceNames != null) {
            jo.put("resourceNames", this.resourceNames);
        }
        if (this.excludedResourceNames != null) {
            jo.put("excludedResourceNames", this.excludedResourceNames);
        }
        if (this.actionValues != null) {
            jo.put("actionsValues", this.actionValues);
        }
        if (this.advices != null) {
            jo.put("advices", this.advices);
        }
        if (this.attributes != null) {
            jo.put("attributes", this.attributes);
        }
        return jo;
    }

    public boolean equals(Object obj) {
        boolean equalled = true;
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Entitlement object = (Entitlement)obj;
        if (this.name == null) {
            if (object.getName() != null) {
                return false;
            }
        } else {
            if (object.getName() == null) {
                return false;
            }
            if (!this.name.equals(object.getName())) {
                return false;
            }
        }
        if (this.applicationName == null) {
            if (object.getApplicationName() != null) {
                return false;
            }
        } else {
            if (object.getApplicationName() == null) {
                return false;
            }
            if (!this.applicationName.equals(object.getApplicationName())) {
                return false;
            }
        }
        if (this.resourceNames == null) {
            if (object.getResourceNames() != null) {
                return false;
            }
        } else {
            if (object.getResourceNames() == null) {
                return false;
            }
            if (!((Object)this.resourceNames).equals(object.getResourceNames())) {
                return false;
            }
        }
        if (this.excludedResourceNames == null || this.excludedResourceNames.isEmpty()) {
            if (object.excludedResourceNames != null && !object.excludedResourceNames.isEmpty()) {
                return false;
            }
        } else {
            if (object.excludedResourceNames == null) {
                return false;
            }
            if (!((Object)this.excludedResourceNames).equals(object.excludedResourceNames)) {
                return false;
            }
        }
        if (this.actionValues == null) {
            if (object.getActionValues() != null && !object.getActionValues().isEmpty()) {
                return false;
            }
        } else {
            if (object.getActionValues() == null) {
                return false;
            }
            if (!((Object)this.actionValues).equals(object.getActionValues())) {
                return false;
            }
        }
        if (this.advices == null) {
            if (object.getAdvices() != null && !object.getAdvices().isEmpty()) {
                return false;
            }
        } else {
            if (object.getAdvices() == null) {
                return false;
            }
            if (!((Object)this.advices).equals(object.getAdvices())) {
                return false;
            }
        }
        if (this.attributes == null) {
            if (object.getAttributes() != null && !object.getAttributes().isEmpty()) {
                return false;
            }
        } else {
            if (object.getAttributes() == null) {
                return false;
            }
            if (!((Object)this.attributes).equals(object.getAttributes())) {
                return false;
            }
        }
        return equalled;
    }

    public int hashCode() {
        int code = 0;
        if (this.name != null) {
            code += this.name.hashCode();
        }
        if (this.applicationName != null) {
            code += this.applicationName.hashCode();
        }
        if (this.resourceNames != null) {
            code += ((Object)this.resourceNames).hashCode();
        }
        if (this.excludedResourceNames != null) {
            code += ((Object)this.excludedResourceNames).hashCode();
        }
        if (this.actionValues != null) {
            code += ((Object)this.actionValues).hashCode();
        }
        if (this.advices != null) {
            code += ((Object)this.advices).hashCode();
        }
        if (this.attributes != null) {
            code += ((Object)this.attributes).hashCode();
        }
        return code;
    }

    public ResourceSearchIndexes getResourceSearchIndexes(Subject adminSubject, String realm) {
        ResourceSearchIndexes result = null;
        ApplicationType applType = this.getApplication(adminSubject, realm).getApplicationType();
        for (String r : this.resourceNames) {
            ResourceSearchIndexes rsi = applType.getResourceSearchIndex(r);
            if (result == null) {
                result = rsi;
                continue;
            }
            result.addAll(rsi);
        }
        return result;
    }

    public ResourceSaveIndexes getResourceSaveIndexes(Subject adminSubject, String realm) {
        ResourceSaveIndexes result = null;
        ApplicationType applType = this.getApplication(adminSubject, realm).getApplicationType();
        for (String r : this.resourceNames) {
            ResourceSaveIndexes rsi = applType.getResourceSaveIndex(r);
            if (result == null) {
                result = rsi;
                continue;
            }
            result.addAll(rsi);
        }
        return result;
    }

    public Application getApplication(Subject adminSubject, String realm) {
        if (this.application == null) {
            this.application = ApplicationManager.getApplication(adminSubject, realm, this.applicationName);
        }
        if (this.application == null) {
            PrivilegeManager.debug.error("Entitlement.getApplication nullrealm=" + realm + " applicationname=" + this.applicationName, null);
        }
        return this.application;
    }

    ResourceName getResourceComparator(Subject adminSubject, String realm) {
        return this.getApplication(PrivilegeManager.superAdminSubject, realm).getResourceComparator();
    }

    void validateResourceNames(Subject adminSubject, String realm) throws EntitlementException {
        if (this.resourceNames != null && !this.resourceNames.isEmpty()) {
            Application app = this.getApplication(adminSubject, realm);
            for (String r : this.resourceNames) {
                ValidateResourceResult result = app.validateResourceName(r);
                if (result.isValid()) continue;
                Object[] args = new Object[]{r};
                throw new EntitlementException(303, args);
            }
        }
    }

    public void canonicalizeResources(Subject adminSubject, String realm) throws EntitlementException {
        HashSet<String> temp;
        ResourceName resComp = this.getResourceComparator(adminSubject, realm);
        if (this.resourceNames != null && !this.resourceNames.isEmpty()) {
            temp = new HashSet<String>();
            for (String r : this.resourceNames) {
                temp.add(resComp.canonicalize(r));
            }
            this.resourceNames = temp;
        }
        if (this.excludedResourceNames != null && !this.excludedResourceNames.isEmpty()) {
            temp = new HashSet();
            for (String r : this.excludedResourceNames) {
                temp.add(resComp.canonicalize(r));
            }
            this.excludedResourceNames = temp;
        }
    }
}

