/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceInstanceImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ServiceInstance {
    private ServiceConfigManager scm;
    private SSOToken token;
    private ServiceInstanceImpl instance;

    ServiceInstance(ServiceConfigManager scm, ServiceInstanceImpl i) {
        this.scm = scm;
        this.instance = i;
        this.token = scm.getSSOToken();
    }

    public String getName() {
        return this.instance.getName();
    }

    public String getServiceName() {
        return this.scm.getName();
    }

    public String getVersion() {
        return this.scm.getVersion();
    }

    public String getGroup() {
        return this.instance.getGroup();
    }

    public void setGroup(String groupName) throws SSOException, SMSException {
        this.validateServiceInstance();
        if (!this.scm.containsGroup(groupName)) {
            Object[] args = new String[]{groupName};
            throw new SMSException("amSDK", "sms-invalid-group-name", args);
        }
        String[] groups = new String[]{groupName};
        SMSEntry entry = this.instance.getSMSEntry();
        entry.setAttribute("sunserviceID", groups);
        entry.save(this.token);
        this.instance.refresh(entry);
    }

    public String getURI() {
        this.validate();
        return this.instance.getURI();
    }

    public void setURI(String uri) throws SSOException, SMSException {
        this.validateServiceInstance();
        String[] uris = new String[]{uri};
        SMSEntry entry = this.instance.getSMSEntry();
        entry.setAttribute("labeledURI", uris);
        entry.save(this.token);
        this.instance.refresh(entry);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\nService Instance: ").append(this.getName()).append("\n\tGroup: ").append(this.getGroup()).append("\n\tURI: ").append(this.getURI()).append("\n\tAttributes: ").append(this.getAttributes());
        return sb.toString();
    }

    public Map getAttributes() {
        this.validate();
        return this.instance.getAttributes();
    }

    public void setAttributes(Map attrs) throws SSOException, SMSException {
        this.validateServiceInstance();
        SMSEntry e = this.instance.getSMSEntry();
        SMSUtils.setAttributeValuePairs(e, attrs, Collections.EMPTY_SET);
        e.save(this.token);
        this.instance.refresh(e);
    }

    public void addAttribute(String attrName, Set values) throws SSOException, SMSException {
        this.validateServiceInstance();
        SMSEntry e = this.instance.getSMSEntry();
        SMSUtils.addAttribute(e, attrName, values, Collections.EMPTY_SET);
        e.save(this.token);
        this.instance.refresh(e);
    }

    public void removeAttribute(String attrName) throws SSOException, SMSException {
        this.validateServiceInstance();
        SMSEntry e = this.instance.getSMSEntry();
        SMSUtils.removeAttribute(e, attrName);
        e.save(this.token);
        this.instance.refresh(e);
    }

    public void removeAttributeValues(String attrName, Set values) throws SSOException, SMSException {
        this.validateServiceInstance();
        SMSEntry e = this.instance.getSMSEntry();
        SMSUtils.removeAttributeValues(e, attrName, values, Collections.EMPTY_SET);
        e.save(this.token);
        this.instance.refresh(e);
    }

    public void replaceAttributeValue(String attrName, String oldValue, String newValue) throws SSOException, SMSException {
        this.validateServiceInstance();
        SMSEntry e = this.instance.getSMSEntry();
        SMSUtils.replaceAttributeValue(e, attrName, oldValue, newValue, Collections.EMPTY_SET);
        e.save(this.token);
        this.instance.refresh(e);
    }

    public void replaceAttributeValues(String attrName, Set oldValues, Set newValues) throws SSOException, SMSException {
        this.validateServiceInstance();
        SMSEntry e = this.instance.getSMSEntry();
        SMSUtils.replaceAttributeValues(e, attrName, oldValues, newValues, Collections.EMPTY_SET);
        e.save(this.token);
        this.instance.refresh(e);
    }

    public String toXML() {
        return this.instance.toXML();
    }

    void delete() throws SMSException, SSOException {
        this.validateServiceInstance();
        SMSEntry entry = this.instance.getSMSEntry();
        entry.delete();
        this.instance.refresh(entry);
    }

    protected void validate() {
        try {
            this.validateServiceInstance();
        }
        catch (SMSException ex) {
            SMSEntry.debug.error("ServiceInstance:validate exception", (Throwable)ex);
        }
    }

    protected void validateServiceInstance() throws SMSException {
        if (!this.instance.isValid()) {
            throw new SMSException("Serviceinstance:validate " + this.getName() + " No loger valid. Cache has been cleared. Recreate from" + "ServiceConfigManager");
        }
    }
}

