/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.BindRule;
import java.util.ArrayList;

class BindRuleBuilder {
    String _previousToken;
    String _previousTokenType = "";
    String _previousKeyword;
    String _previousKeywordSet;
    String _previousExpressionConnector;
    String _token;
    String _tokenType;
    String _keyword;
    String _keywordSet;
    ArrayList _doneKeywordSets = new ArrayList();
    String _operator;
    String _value;
    String _expressionConnector;
    int _parenthCount;
    int _keywordCount;
    int _previousKeywordCount;
    BindRule br = new BindRule();

    BindRuleBuilder() {
    }

    void addToken(String token) throws ACIParseException {
        this._tokenType = this.getTokenType(token);
        if (this._previousTokenType.equals("keyword") && !this._tokenType.equals("operator")) {
            throw new ACIParseException("keyword not followed by operator : " + this._previousToken);
        }
        if (this._previousTokenType.equals("operator") && !this._tokenType.equals("value")) {
            throw new ACIParseException("operator not followed by value");
        }
        if (this._previousTokenType.equals("value") && !this._tokenType.equals("expressionconnector") && !this._tokenType.equals("(") && !this._tokenType.equals(")")) {
            throw new ACIParseException("value not followed by connector : " + this._previousToken);
        }
        if (this._previousTokenType.equals("expressionconnector") && !this._tokenType.equals("keyword") && !this._tokenType.equals("(")) {
            throw new ACIParseException("expressionconnector not followed by keyword : " + token);
        }
        if (this._tokenType.equals("(")) {
            ++this._parenthCount;
        } else if (this._tokenType.equals(")")) {
            --this._parenthCount;
        } else if (this._tokenType.equals("keyword")) {
            this._keyword = token.toLowerCase();
            this._keywordSet = this.getKeywordSet(token);
            if (this._doneKeywordSets.contains(this._keywordSet)) {
                throw new ACIParseException("keywords from diffrent sets overlap");
            }
            if (this._previousKeywordSet != null && !this._keywordSet.equals(this._previousKeywordSet)) {
                this._doneKeywordSets.add(this._previousKeywordSet);
                this._keywordCount = 0;
                if (!this._expressionConnector.equals("and")) {
                    throw new ACIParseException("sets of of keywords have to be  connected  by logical and ");
                }
            } else {
                ++this._keywordCount;
                if (this._keywordCount > 1 && !this._keywordSet.equals("tod") && !"or".equals(this._expressionConnector)) {
                    throw new ACIParseException("keywords from the same set has to  be connected  by logical OR : " + token);
                }
            }
            this._previousKeyword = this._keyword;
            this._previousKeywordSet = this._keywordSet;
            this._previousKeywordCount = this._keywordCount;
        } else if (this._tokenType.equals("operator")) {
            this._operator = token.toLowerCase();
        } else if (this._tokenType.equals("value")) {
            this._value = token.substring(1, token.length() - 1);
            if (this._keyword == null) {
                throw new ACIParseException("keyword is null");
            }
            this.addParameter(this._keyword, this._operator, this._value);
            this._value = null;
        } else if (this._tokenType.equals("expressionconnector")) {
            this._expressionConnector = token.toLowerCase();
            if (this._expressionConnector.equals("and") && !"timeofday".equals(this._keyword)) {
                if (this._parenthCount != 0) {
                    throw new ACIParseException("Can not enclose keywords from  different sets in the same parenthesis");
                }
                if (this._previousKeywordCount > 1 && !")".equals(this._previousTokenType)) {
                    throw new ACIParseException("preceding set of expressions  not enclosed in parenthesis");
                }
            }
        } else if (!this._tokenType.equals("||")) {
            throw new ACIParseException("Unknown token type for : " + token);
        }
        this._previousTokenType = this._tokenType;
    }

    String getKeywordSet(String keyword) throws ACIParseException {
        String keywordSet = null;
        if (keyword.equals("userdn") || keyword.equals("userdnattr") || keyword.equals("groupdn") || keyword.equals("groupdnattr") || keyword.equals("roledn") || keyword.equals("userattr")) {
            keywordSet = "principal";
        } else if (keyword.equals("ip") || keyword.equals("dns")) {
            keywordSet = "IP";
        } else if (keyword.equals("authmethod")) {
            keywordSet = "authmethod";
        } else if (keyword.equals("timeofday")) {
            keywordSet = "tod";
        } else if (keyword.equals("dayofweek")) {
            keywordSet = "dow";
        } else {
            throw new ACIParseException("can not determine keyword set for : " + keyword);
        }
        return keywordSet;
    }

    String getTokenType(String token) throws ACIParseException {
        token = token.toLowerCase();
        String tokenType = null;
        if (token.charAt(0) == '\"' && token.charAt(token.length() - 1) == '\"') {
            tokenType = "value";
        } else if (token.equals("userdn") || token.equals("userdnattr") || token.equals("groupdn") || token.equals("groupdnattr") || token.equals("roledn") || token.equals("userattr") || token.equals("ip") || token.equals("dns") || token.equals("authmethod") || token.equals("timeofday") || token.equals("dayofweek")) {
            tokenType = "keyword";
        } else if (token.equals("=") || token.equals("!=") || token.equals("<") || token.equals("<=") || token.equals(">") || token.equals(">=")) {
            tokenType = "operator";
        } else if (token.equals("and") || token.equals("or")) {
            tokenType = "expressionconnector";
        } else if (token.equals("(")) {
            tokenType = "(";
        } else if (token.equals(")")) {
            tokenType = ")";
        } else if (token.equals("||")) {
            tokenType = "||";
        } else {
            throw new ACIParseException("tokentype unknown for " + token);
        }
        return tokenType;
    }

    void addParameter(String keyword, String operator, String value) throws ACIParseException {
        if (!keyword.equals("timeofday") && !operator.equals("=")) {
            throw new ACIParseException(" keyword " + keyword + " does not allow operator " + operator);
        }
        if (keyword.equals("timeofday") && operator.equals(">=") && this._keywordCount > 1 && !"or".equals(this._expressionConnector)) {
            throw new ACIParseException(" illegal operator for timeofday : " + operator);
        }
        if (keyword.equals("timeofday") && operator.equals("<=") && !"and".equals(this._expressionConnector)) {
            throw new ACIParseException(" illegal operator for timeofday : " + operator);
        }
        if (keyword.equals("userdn")) {
            this.br.addUsers(value);
        } else if (keyword.equals("userdnattr")) {
            this.br.addUserDNAttr(value);
        } else if (keyword.equals("groupdn")) {
            this.br.addGroups(value);
        } else if (keyword.equals("groupdnattr")) {
            this.br.addGroupDNAttr(value);
        } else if (keyword.equals("roledn")) {
            this.br.addRoles(value);
        } else if (keyword.equals("userattr")) {
            this.br.addUserAttr(value);
        } else if (keyword.equals("authmethod")) {
            this.br.addAuthMethod(value);
        } else if (keyword.equals("ip")) {
            this.br.addClientIP(value);
        } else if (keyword.equals("dns")) {
            this.br.addClientHostName(value);
        } else if (keyword.equals("timeofday")) {
            this.br.addTimeOfDay(value, operator);
        } else if (keyword.equals("dayofweek")) {
            this.br.addDaysOfWeek(value);
        } else {
            throw new ACIParseException("Unknown keyword : " + keyword);
        }
    }

    BindRule getBindRule() {
        return this.br;
    }

    public String toString() {
        StringBuffer bindRule = new StringBuffer();
        return bindRule.toString();
    }
}

