/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.msisdn;

import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class MSISDNValidation {
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private String userTokenId;
    private String errorMsgKey = null;
    private Map options;
    protected static AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
    private String userSearchAttr;
    private String serverHost;
    private int serverPort = 389;
    private String startSearchLoc;
    private String principalUser;
    private String principalPasswd;
    private boolean useSSL;
    private String userNamingAttr;
    private String returnUserDN;
    private static final String amAuthMSISDN = "amAuthMSISDN";
    private Locale locale;
    private static final String TRUSTED_GATEWAY_LIST = "sunAMAuthMSISDNTrustedGatewayList";
    private static final String MSISDN_PARAMETER_NAME = "sunAMAuthMSISDNParameterNameList";
    private static final String USER_SEARCH_ATTR = "sunAMAuthMSISDNUserSearchAttribute";
    private static final String PRINCIPAL = "sunAMAuthMSISDNPrincipalUser";
    private static final String PRINCIPAL_PASSWD = "sunAMAuthMSISDNPrincipalPasswd";
    private static final String USE_SSL = "sunAMAuthMSISDNUseSsl";
    private static final String LDAP_URL = "sunAMAuthMSISDNLdapProviderUrl";
    private static final String MSISDN_AUTH_LEVEL = "sunAMAuthMSISDNAuthLevel";
    private static final String START_SEARCH_DN = "sunAMAuthMSISDNBaseDn";
    private static final String RETURN_USER_DN = "sunAMAuthMSISDNReturnUserDN";
    private static final String USER_NAMING_ATTR = "sunAMAuthMSISDNUserNamingAttribute";
    private static final String DEFAULT_USER_NAMING_ATTR = "uid";

    protected MSISDNValidation(Map options, Debug debug, ResourceBundle bundle, Locale locale) throws AuthLoginException {
        MSISDNValidation.debug = debug;
        this.bundle = bundle;
        this.locale = locale;
        this.initMSISDNConfig(options);
    }

    private void initMSISDNConfig(Map options) throws AuthLoginException {
        String errorMsgKey = null;
        if (options != null) {
            debug.message("MSISDN: getting attributes.");
            this.userSearchAttr = CollectionHelper.getMapAttr((Map)options, (String)USER_SEARCH_ATTR);
            this.principalUser = CollectionHelper.getMapAttr((Map)options, (String)PRINCIPAL);
            this.principalPasswd = CollectionHelper.getMapAttr((Map)options, (String)PRINCIPAL_PASSWD);
            this.useSSL = Boolean.valueOf(CollectionHelper.getMapAttr((Map)options, (String)USE_SSL, (String)"false"));
            this.serverHost = CollectionHelper.getServerMapAttr((Map)options, (String)LDAP_URL);
            this.userNamingAttr = CollectionHelper.getMapAttr((Map)options, (String)USER_NAMING_ATTR, (String)DEFAULT_USER_NAMING_ATTR);
            this.returnUserDN = CollectionHelper.getMapAttr((Map)options, (String)RETURN_USER_DN, (String)"true");
            if (this.serverHost == null) {
                debug.error("Fatal error: LDAP Server and Port misconfigured");
                errorMsgKey = "wrongLDAPServer";
            } else {
                String port = null;
                int index = this.serverHost.indexOf(58);
                if (index != -1) {
                    port = this.serverHost.substring(index + 1);
                    this.serverPort = Integer.parseInt(port);
                    this.serverHost = this.serverHost.substring(0, index);
                }
                this.startSearchLoc = CollectionHelper.getServerMapAttr((Map)options, (String)START_SEARCH_DN);
                if (this.startSearchLoc == null) {
                    debug.error("Fatal error: LDAP Start Search DN misconfigured");
                    errorMsgKey = "wrongStartDN";
                }
            }
            if (debug.messageEnabled()) {
                debug.message("\n ldapProviderUrl=" + this.serverHost + "\n\t serverPort = " + this.serverPort + "\n\t startSearchLoc=" + this.startSearchLoc + "\n\t userSearchAttr=" + this.userSearchAttr + "\n\t principalUser=" + this.principalUser + "\n\t serverHost =" + this.serverHost + "\n\t userNamingAttr =" + this.userNamingAttr + "\n\t returnUserDN =" + this.returnUserDN + "\n\t useSSL=" + this.useSSL);
            }
        } else {
            debug.error("options is null");
            errorMsgKey = "MSISDNValidateEx";
        }
        if (errorMsgKey != null) {
            throw new AuthLoginException(amAuthMSISDN, errorMsgKey, null);
        }
    }

    protected String getUserId(String msisdnNumber) throws AuthLoginException {
        String validatedUserID = null;
        try {
            ResourceBundle ldapBundle = amCache.getResBundle("amAuthLDAP", this.locale);
            LDAPAuthUtils ldapUtil = new LDAPAuthUtils(this.serverHost, this.serverPort, this.useSSL, ldapBundle, this.startSearchLoc, debug);
            String searchFilter = new StringBuffer(250).append("(").append(this.userSearchAttr).append("=").append(msisdnNumber).append(")").toString();
            ldapUtil.setReturnUserDN(this.returnUserDN);
            ldapUtil.setUserNamingAttribute(this.userNamingAttr);
            ldapUtil.setFilter(searchFilter);
            ldapUtil.setAuthDN(this.principalUser);
            ldapUtil.setAuthPassword(this.principalPasswd);
            ldapUtil.searchForUser();
            switch (ldapUtil.getState()) {
                case 33: {
                    debug.message("User search successful");
                    validatedUserID = ldapUtil.getUserId();
                    return validatedUserID;
                }
                case 1: {
                    debug.error("MSISDN - Error finding user");
                    throw new AuthLoginException(amAuthMSISDN, "userNotFound", null);
                }
                case 31: {
                    debug.error("Server down");
                    throw new AuthLoginException(amAuthMSISDN, "MSISDNServerDown", null);
                }
            }
            throw new AuthLoginException(amAuthMSISDN, "MSISDNValidateEx", null);
        }
        catch (Exception e) {
            throw new AuthLoginException(e);
        }
    }
}

