/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.configuration;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.configuration.ConfigurationBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.ServerConfiguration;
import com.sun.identity.shared.FQDNUrl;
import com.sun.identity.shared.NormalizedURL;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SiteConfiguration
extends ConfigurationBase {
    private SiteConfiguration() {
    }

    public static Set getSiteInfo(SSOToken ssoToken) throws SMSException, SSOException {
        HashSet siteInfo = null;
        if (SiteConfiguration.isLegacy(ssoToken)) {
            siteInfo = SiteConfiguration.legacyGetSiteInfo(ssoToken);
        } else {
            siteInfo = new HashSet();
            ServiceConfig sc = SiteConfiguration.getRootSiteConfig(ssoToken);
            if (sc != null) {
                Set names = sc.getSubConfigNames();
                for (String name : names) {
                    siteInfo.addAll(SiteConfiguration.getSiteInfo(sc, name));
                }
            }
        }
        return siteInfo;
    }

    private static Set getSiteInfo(ServiceConfig rootNode, String name) throws SMSException, SSOException {
        HashSet<String> info = new HashSet<String>();
        ServiceConfig sc = rootNode.getSubConfig(name);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Map map = accessPoint.getAttributes();
        Set setId = (Set)map.get("primary-siteid");
        Set setURL = (Set)map.get("primary-url");
        info.add(NormalizedURL.normalize((String)((String)setURL.iterator().next())) + "|" + (String)setId.iterator().next());
        Set secURLs = accessPoint.getSubConfigNames("*");
        if (secURLs != null && !secURLs.isEmpty()) {
            for (String secName : secURLs) {
                ServiceConfig s = accessPoint.getSubConfig(secName);
                Map mapValues = s.getAttributes();
                setId = (Set)mapValues.get("secondary-siteid");
                info.add(NormalizedURL.normalize((String)secName) + "|" + (String)setId.iterator().next());
            }
        }
        return info;
    }

    public static Set getSites(SSOToken ssoToken) throws SMSException, SSOException {
        HashSet<String> sites = new HashSet<String>();
        if (SiteConfiguration.isLegacy(ssoToken)) {
            Set siteInfo = SiteConfiguration.legacyGetSiteInfo(ssoToken);
            if (siteInfo != null && !siteInfo.isEmpty()) {
                for (String site : siteInfo) {
                    int idx = site.indexOf(124);
                    if (idx != -1) {
                        site = site.substring(0, idx);
                    }
                    sites.add(site);
                }
            }
        } else {
            ServiceConfig sc = SiteConfiguration.getRootSiteConfig(ssoToken);
            if (sc != null) {
                sites.addAll(sc.getSubConfigNames("*"));
            }
        }
        return sites;
    }

    public static boolean deleteSite(SSOToken ssoToken, String siteName) throws SMSException, SSOException, ConfigurationException {
        boolean deleted = false;
        if (SiteConfiguration.isLegacy(ssoToken)) {
            ServiceSchemaManager sm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
            ServiceSchema sc = sm.getGlobalSchema();
            Map attrs = sc.getAttributeDefaults();
            String site = siteName + "|";
            Set sites = (Set)attrs.get("iplanet-am-platform-site-list");
            Iterator i = sites.iterator();
            while (i.hasNext() && !deleted) {
                String s = (String)i.next();
                if (!s.startsWith(site)) continue;
                i.remove();
                deleted = true;
            }
            if (deleted) {
                sc.setAttributeDefaults("iplanet-am-platform-site-list", sites);
            }
        } else {
            ServiceConfig cfg;
            ServiceConfig sc = SiteConfiguration.getRootSiteConfig(ssoToken);
            if (sc != null && (cfg = sc.getSubConfig(siteName)) != null) {
                Set svrs = SiteConfiguration.listServers(ssoToken, siteName);
                if (svrs != null && !svrs.isEmpty()) {
                    SiteConfiguration.removeServersFromSite(ssoToken, siteName, svrs);
                }
                sc.removeSubConfig(siteName);
                deleted = true;
            }
        }
        return deleted;
    }

    public static boolean createSite(SSOToken ssoToken, String siteName, String siteURL, Collection secondaryURLs) throws SMSException, SSOException, ConfigurationException {
        boolean created = false;
        if (SiteConfiguration.isLegacy(ssoToken)) {
            ServiceSchemaManager sm = new ServiceSchemaManager("iPlanetAMPlatformService", ssoToken);
            String siteId = SiteConfiguration.getNextId(ssoToken);
            ServiceSchema sc = sm.getGlobalSchema();
            Map attrs = sc.getAttributeDefaults();
            HashSet<String> sites = (HashSet<String>)attrs.get("iplanet-am-platform-site-list");
            if (sites == null || sites.isEmpty()) {
                sites = new HashSet<String>();
            }
            sites.add(siteName + "|" + siteId);
            sc.setAttributeDefaults("iplanet-am-platform-site-list", sites);
        } else {
            ServiceConfig sc = SiteConfiguration.getRootSiteConfig(ssoToken);
            if (sc != null) {
                String siteId = SiteConfiguration.getNextId(ssoToken);
                created = SiteConfiguration.createSite(ssoToken, siteName, siteURL, siteId, secondaryURLs);
            }
        }
        if (created) {
            SiteConfiguration.updateOrganizationAlias(ssoToken, siteURL, true);
        }
        return created;
    }

    private static boolean createSite(SSOToken ssoToken, String siteName, String siteURL, String siteId, Collection secondaryURLs) throws SMSException, SSOException, ConfigurationException {
        boolean created = false;
        ServiceConfig sc = SiteConfiguration.getRootSiteConfig(ssoToken);
        if (sc != null) {
            try {
                FQDNUrl test = new FQDNUrl(siteURL.trim());
                if (!test.isFullyQualified() || test.getPort().length() == 0 || test.getURI().length() == 0) {
                    Object[] param = new String[]{siteURL};
                    throw new ConfigurationException("invalid.site.url", param);
                }
            }
            catch (MalformedURLException ex) {
                Object[] param = new String[]{siteURL};
                throw new ConfigurationException("invalid.site.url", param);
            }
            Set allURLs = SiteConfiguration.getAllSiteURLs(ssoToken);
            if (allURLs.contains(siteURL)) {
                Object[] param = new String[]{siteURL};
                throw new ConfigurationException("duplicated.site.url", param);
            }
            if (secondaryURLs != null && !secondaryURLs.isEmpty()) {
                for (String url : secondaryURLs) {
                    if (allURLs.contains(url)) {
                        Object[] param = new String[]{url};
                        throw new ConfigurationException("duplicated.site.url", param);
                    }
                    try {
                        FQDNUrl test = new FQDNUrl(url);
                        if (test.isFullyQualified() && test.getPort().length() != 0 && test.getURI().length() != 0) continue;
                        Object[] param = new String[]{url};
                        throw new ConfigurationException("invalid.site.secondary.url", param);
                    }
                    catch (MalformedURLException ex) {
                        Object[] param = new String[]{url};
                        throw new ConfigurationException("invalid.site.secondary.url", param);
                    }
                }
            }
            sc.addSubConfig(siteName, "site", 0, Collections.EMPTY_MAP);
            ServiceConfig scSite = sc.getSubConfig(siteName);
            HashMap siteValues = new HashMap(2);
            HashSet<String> setSiteId = new HashSet<String>(2);
            setSiteId.add(siteId);
            siteValues.put("primary-siteid", setSiteId);
            HashSet<String> setSiteURL = new HashSet<String>(2);
            setSiteURL.add(siteURL);
            siteValues.put("primary-url", setSiteURL);
            scSite.addSubConfig("accesspoint", "accesspoint", 0, siteValues);
            if (secondaryURLs != null && !secondaryURLs.isEmpty()) {
                SiteConfiguration.setSiteSecondaryURLs(ssoToken, siteName, secondaryURLs);
            }
            created = true;
        }
        return created;
    }

    public static String getSitePrimaryURL(SSOToken ssoToken, String siteName) throws SMSException, SSOException {
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Map map = accessPoint.getAttributes();
        Set set = (Set)map.get("primary-url");
        return (String)set.iterator().next();
    }

    public static Set getSiteURLs(SSOToken ssoToken, String siteName) throws SMSException, SSOException {
        HashSet<String> urls = new HashSet<String>();
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Map map = accessPoint.getAttributes();
        Set set = (Set)map.get("primary-url");
        urls.add(NormalizedURL.normalize((String)((String)set.iterator().next())));
        Set secondary = accessPoint.getSubConfigNames("*");
        if (secondary != null && !secondary.isEmpty()) {
            Iterator i = secondary.iterator();
            while (i.hasNext()) {
                urls.add(NormalizedURL.normalize((String)((String)i.next())));
            }
        }
        return urls;
    }

    public static Set getSiteSecondaryURLs(SSOToken ssoToken, String siteName) throws SMSException, SSOException {
        HashSet secondaryURLs = new HashSet();
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Set secondary = accessPoint.getSubConfigNames("*");
        if (secondary != null && !secondary.isEmpty()) {
            secondaryURLs.addAll(secondary);
        }
        return secondaryURLs;
    }

    public static void setSitePrimaryURL(SSOToken ssoToken, String siteName, String siteURL) throws SMSException, SSOException, ConfigurationException {
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Map existing = accessPoint.getAttributes();
        Set existingSet = (Set)existing.get("primary-url");
        if (!existingSet.contains(siteURL)) {
            Set allURLs = SiteConfiguration.getAllSiteURLs(ssoToken);
            if (allURLs.contains(siteURL)) {
                Object[] param = new String[]{siteURL};
                throw new ConfigurationException("duplicated.site.url", param);
            }
            HashMap map = new HashMap(2);
            HashSet<String> set = new HashSet<String>(2);
            set.add(siteURL);
            map.put("primary-url", set);
            accessPoint.setAttributes(map);
        }
    }

    public static void setSiteSecondaryURLs(SSOToken ssoToken, String siteName, Collection secondaryURLs) throws SMSException, SSOException, ConfigurationException {
        for (String url : secondaryURLs) {
            try {
                FQDNUrl test = new FQDNUrl(url);
                if (test.isFullyQualified() && test.getPort().length() != 0 && test.getURI().length() != 0) continue;
                Object[] param = new String[]{url};
                throw new ConfigurationException("invalid.site.secondary.url", param);
            }
            catch (MalformedURLException ex) {
                Object[] param = new String[]{url};
                throw new ConfigurationException("invalid.site.secondary.url", param);
            }
        }
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Set secondary = accessPoint.getSubConfigNames("*");
        HashSet toAdd = new HashSet(secondaryURLs.size());
        toAdd.addAll(secondaryURLs);
        HashSet toRemove = new HashSet(secondary.size());
        if (secondary != null && !secondary.isEmpty()) {
            toRemove.addAll(secondary);
            toRemove.removeAll(secondaryURLs);
            toAdd.removeAll(secondary);
        }
        Set allURLs = SiteConfiguration.getAllSiteURLs(ssoToken);
        for (String url : toAdd) {
            if (!allURLs.contains(url)) continue;
            Object[] param = new String[]{url};
            throw new ConfigurationException("duplicated.site.url", param);
        }
        for (String url : toRemove) {
            accessPoint.removeSubConfig(url);
        }
        for (String url : toAdd) {
            HashMap values = new HashMap(2);
            HashSet<String> set = new HashSet<String>(2);
            set.add(SiteConfiguration.getNextId(ssoToken));
            values.put("secondary-siteid", set);
            accessPoint.addSubConfig(url, "secondary-urls", 0, values);
        }
    }

    public static void addSiteSecondaryURLs(SSOToken ssoToken, String siteName, Collection secondaryURLs) throws SMSException, SSOException, ConfigurationException {
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        HashSet toAdd = new HashSet(secondaryURLs.size() * 2);
        toAdd.addAll(secondaryURLs);
        Set secondary = accessPoint.getSubConfigNames("*");
        if (secondary != null && !secondary.isEmpty()) {
            toAdd.removeAll(secondary);
        }
        Set allURLs = SiteConfiguration.getAllSiteURLs(ssoToken);
        for (String url : toAdd) {
            if (!allURLs.contains(url)) continue;
            Object[] param = new String[]{url};
            throw new ConfigurationException("duplicated.site.url", param);
        }
        for (String url : toAdd) {
            HashMap values = new HashMap(2);
            HashSet<String> set = new HashSet<String>(2);
            set.add(SiteConfiguration.getNextId(ssoToken));
            values.put("secondary-siteid", set);
            accessPoint.addSubConfig(url, "secondary-urls", 0, values);
        }
    }

    public static void removeSiteSecondaryURLs(SSOToken ssoToken, String siteName, Collection secondaryURLs) throws SMSException, SSOException {
        ServiceConfig rootNode = SiteConfiguration.getRootSiteConfig(ssoToken);
        ServiceConfig sc = rootNode.getSubConfig(siteName);
        ServiceConfig accessPoint = sc.getSubConfig("accesspoint");
        Set secondary = accessPoint.getSubConfigNames("*");
        if (secondary != null && !secondary.isEmpty()) {
            for (String secName : secondary) {
                if (!secondaryURLs.contains(secName)) continue;
                accessPoint.removeSubConfig(secName);
            }
        }
    }

    public static void addServersToSite(SSOToken ssoToken, String siteName, Collection serverInstanceNames) throws SMSException, SSOException, ConfigurationException {
        String siteId = SiteConfiguration.getSiteId(ssoToken, siteName);
        if (siteId != null) {
            for (String svr : serverInstanceNames) {
                ServerConfiguration.addToSite(ssoToken, svr, siteName);
            }
        }
    }

    public static void removeServersFromSite(SSOToken ssoToken, String siteName, Collection serverInstanceNames) throws SMSException, SSOException, ConfigurationException {
        String siteId = SiteConfiguration.getSiteId(ssoToken, siteName);
        if (siteId != null) {
            for (String svr : serverInstanceNames) {
                ServerConfiguration.removeFromSite(ssoToken, svr, siteName);
            }
        }
    }

    private static String getSiteId(SSOToken ssoToken, String siteName) throws SMSException, SSOException, ConfigurationException {
        String siteId = null;
        if (SiteConfiguration.isLegacy(ssoToken)) {
            Set sites = SiteConfiguration.legacyGetSiteInfo(ssoToken);
            if (sites != null && !sites.isEmpty()) {
                Iterator i = sites.iterator();
                while (i.hasNext() && siteId == null) {
                    String name;
                    String site = (String)i.next();
                    int idx = site.indexOf(124);
                    if (idx == -1 || !(name = site.substring(0, idx)).equals(siteName) || (idx = (siteId = site.substring(idx + 1)).indexOf(124)) == -1) continue;
                    siteId = siteId.substring(0, idx);
                }
            }
        } else {
            Set siteIds = SiteConfiguration.getSiteConfigurationIds(ssoToken, null, siteName, true);
            if (siteIds != null && !siteIds.isEmpty()) {
                siteId = (String)siteIds.iterator().next();
            }
        }
        if (siteId == null) {
            Object[] param = new String[]{siteName};
            throw new ConfigurationException("invalid.site.instance", param);
        }
        return siteId;
    }

    public static Set listServers(SSOToken ssoToken, String siteName) throws SMSException, SSOException, ConfigurationException {
        HashSet<String> members = new HashSet<String>();
        String siteId = SiteConfiguration.getSiteId(ssoToken, siteName);
        if (siteId != null) {
            Set allServers = ServerConfiguration.getServers(ssoToken);
            for (String svr : allServers) {
                if (!ServerConfiguration.belongToSite(ssoToken, svr, siteName)) continue;
                members.add(svr);
            }
        }
        return members;
    }

    public static boolean isSiteExist(SSOToken ssoToken, String siteName) throws SMSException, SSOException {
        Set sites = SiteConfiguration.getSites(ssoToken);
        return sites.contains(siteName);
    }

    private static Set getAllSiteURLs(SSOToken ssoToken) throws SMSException, SSOException {
        HashSet urls = new HashSet();
        Set sites = SiteConfiguration.getSites(ssoToken);
        for (String siteName : sites) {
            urls.addAll(SiteConfiguration.getSiteURLs(ssoToken, siteName));
        }
        return urls;
    }

    public static String getSiteIdByURL(SSOToken ssoToken, String url) throws SMSException, SSOException {
        String siteName = null;
        Set sites = SiteConfiguration.getSites(ssoToken);
        Iterator i = sites.iterator();
        while (i.hasNext() && siteName == null) {
            String name = (String)i.next();
            Set urls = SiteConfiguration.getSiteURLs(ssoToken, name);
            if (!urls.contains(url)) continue;
            siteName = name;
        }
        return siteName;
    }
}

