/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.sun.identity.idm.AMIdentity;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthenticateSessionContextElement;
import com.sun.identity.liberty.ws.disco.jaxb.AuthorizeRequesterElement;
import com.sun.identity.liberty.ws.disco.jaxb.EncryptResourceIDElement;
import com.sun.identity.liberty.ws.disco.jaxb.InsertEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.disco.jaxb.QueryType;
import com.sun.identity.liberty.ws.disco.jaxb.RemoveEntryType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb11.GenerateBearerTokenElement;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.plugin.datastore.DataStoreProvider;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.debug.Debug;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DiscoEntryHandlerImplUtils {
    protected static Debug debug = DiscoUtils.debug;

    public static boolean getUserDiscoEntries(DataStoreProvider store, String userID, String attrName, Map discoEntries) throws Exception {
        boolean needStore = false;
        Set attr = store.getAttribute(userID, attrName);
        Iterator i = attr.iterator();
        DiscoEntryElement entry = null;
        String entryID = null;
        String entryStr = null;
        while (i.hasNext()) {
            entryStr = (String)i.next();
            try {
                entry = (DiscoEntryElement)DiscoUtils.getDiscoUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(entryStr)));
                entryID = entry.getResourceOffering().getEntryID();
                if (entryID == null || entryID.length() == 0) {
                    entryID = SAMLUtils.generateID();
                    entry.getResourceOffering().setEntryID(entryID);
                    needStore = true;
                }
                discoEntries.put(entryID, entry);
            }
            catch (Exception e) {
                debug.error("DiscoEntryHandlerImplUtils.getUserDiscoEntries: wrong format for entry. Removing it from store: " + entryStr);
                needStore = true;
            }
        }
        return needStore;
    }

    public static boolean setUserDiscoEntries(DataStoreProvider store, String userID, String attrName, Collection entries) {
        debug.message("in DiscoEntryHandlerImplUtils.setUserDiscoEntries");
        try {
            Iterator i = entries.iterator();
            HashSet<String> xmlStrings = new HashSet<String>();
            StringWriter sw = null;
            while (i.hasNext()) {
                sw = new StringWriter(1000);
                DiscoUtils.getDiscoMarshaller().marshal((Object)((DiscoEntryElement)i.next()), (Writer)sw);
                xmlStrings.add(sw.getBuffer().toString());
            }
            HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
            map.put(attrName, xmlStrings);
            store.setAttributes(userID, map);
            return true;
        }
        catch (Exception e) {
            debug.error("DiscoEntryHandlerImplUtils.setUserDiscoEntries: Exception", (Throwable)e);
            return false;
        }
    }

    public static Map getQueryResults(Map discoEntries, List reqServiceTypes) {
        HashMap<String, DiscoEntryElement> results = null;
        if (reqServiceTypes == null || reqServiceTypes.size() == 0) {
            if (debug.messageEnabled()) {
                debug.message("DiscoEntryHandlerImplUtils.getQueryResults: no reqServiceTypes");
            }
            results = discoEntries;
        } else {
            results = new HashMap<String, DiscoEntryElement>();
            block0: for (String curKey : discoEntries.keySet()) {
                DiscoEntryElement cur = (DiscoEntryElement)discoEntries.get(curKey);
                ResourceOfferingType offering = cur.getResourceOffering();
                String serviceType = offering.getServiceInstance().getServiceType();
                List options = null;
                if (offering.getOptions() != null) {
                    options = offering.getOptions().getOption();
                }
                for (QueryType.RequestedServiceTypeType curReqType : reqServiceTypes) {
                    String requestedServiceType = curReqType.getServiceType();
                    if (!requestedServiceType.equals(serviceType)) continue;
                    List queryOptions = null;
                    if (curReqType.getOptions() != null) {
                        queryOptions = curReqType.getOptions().getOption();
                    }
                    if (!DiscoEntryHandlerImplUtils.evaluateOptionsRules(queryOptions, options)) continue;
                    results.put(curKey, cur);
                    continue block0;
                }
            }
        }
        return results;
    }

    private static boolean evaluateOptionsRules(List reqOptions, List regOptions) {
        if (reqOptions == null || regOptions == null || reqOptions.size() == 0) {
            return true;
        }
        for (String option : reqOptions) {
            if (!regOptions.contains(option)) continue;
            return true;
        }
        return false;
    }

    public static boolean handleRemoves(Map discoEntriesMap, List removes) {
        Iterator i = removes.iterator();
        RemoveEntryType remove = null;
        while (i.hasNext()) {
            remove = (RemoveEntryType)i.next();
            if (!discoEntriesMap.containsKey(remove.getEntryID())) {
                if (debug.messageEnabled()) {
                    debug.message("DiscoEntryHandlerImplUtils.handleRemoves: can not remove entry: " + remove.getEntryID());
                }
                return false;
            }
            discoEntriesMap.remove(remove.getEntryID());
        }
        return true;
    }

    public static Map handleInserts(Set discoEntries, List inserts) {
        HashMap<String, Object> insertResults = new HashMap<String, Object>();
        insertResults.put("STATUS_CODE", "Failed");
        Set supportedDirectives = DiscoServiceManager.getSupportedDirectives();
        if (debug.messageEnabled()) {
            debug.message("DiscoEntryHandlerImplUtils.handleInserts: size of supportedDirective is " + supportedDirectives.size());
        }
        Iterator i = inserts.iterator();
        InsertEntryType insertEntry = null;
        DiscoEntryElement de = null;
        ResourceOfferingType resOff = null;
        LinkedList<String> newEntryIDs = new LinkedList<String>();
        while (i.hasNext()) {
            insertEntry = (InsertEntryType)i.next();
            try {
                de = DiscoUtils.getDiscoEntryFactory().createDiscoEntryElement();
            }
            catch (JAXBException je) {
                debug.error("DiscoEntryHandlerImplUtils.handleInserts: couldn't create DiscoEntry: ", (Throwable)je);
                return insertResults;
            }
            resOff = insertEntry.getResourceOffering();
            String newEntryID = SAMLUtils.generateID();
            if (debug.messageEnabled()) {
                debug.message("DiscoEntryHandlerImplUtils: newEntryID=" + newEntryID);
            }
            resOff.setEntryID(newEntryID);
            newEntryIDs.add(newEntryID);
            de.setResourceOffering(resOff);
            List dirs = insertEntry.getAny();
            if (dirs != null && !dirs.isEmpty()) {
                for (Object dir : dirs) {
                    if (dir instanceof AuthenticateRequesterElement) {
                        if (supportedDirectives.contains("AuthenticateRequester")) continue;
                        debug.error("Directive AuthenticateRequester is not supported.");
                        return insertResults;
                    }
                    if (dir instanceof AuthorizeRequesterElement) {
                        if (supportedDirectives.contains("AuthorizeRequester")) continue;
                        debug.error("Directive AuthorizeRequester is not supported.");
                        return insertResults;
                    }
                    if (dir instanceof AuthenticateSessionContextElement) {
                        if (supportedDirectives.contains("AuthenticateSessionContext")) continue;
                        debug.error("Directive AuthenticateSessionContext is not supported.");
                        return insertResults;
                    }
                    if (dir instanceof EncryptResourceIDElement) {
                        if (supportedDirectives.contains("EncryptResourceID")) continue;
                        debug.error("Directive EncryptResourceID is not supported.");
                        return insertResults;
                    }
                    if (dir instanceof GenerateBearerTokenElement) {
                        if (supportedDirectives.contains("GenerateBearerToken")) continue;
                        debug.error("Directive GenerateBearerToken is not supported.");
                        return insertResults;
                    }
                    debug.error("Directive " + dir + " is not supported.");
                    return insertResults;
                }
                de.getAny().addAll(dirs);
            }
            if (discoEntries.add(de)) continue;
            debug.error("DiscoEntryHandlerImplUtils.handleInserts: couldn't add DiscoEntry to Set.");
            return insertResults;
        }
        insertResults.put("STATUS_CODE", "OK");
        insertResults.put("newEntryIDs", newEntryIDs);
        return insertResults;
    }

    public static void getGlobalDiscoEntries(AMIdentity amIdentity, String attrName, Map discoEntries, String userID) throws Exception {
        Map map = amIdentity.getServiceAttributes("sunIdentityServerDiscoveryService");
        Set attr = (Set)map.get(attrName);
        if (attr == null || attr.isEmpty()) {
            debug.error("DiscoEntryHandlerImplUtils.getServiceDiscoEntries: The resource offerings are not available");
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("DiscoEntryHandlerImplUtils.getServiceDiscoEntries: " + attr);
        }
        Iterator j = attr.iterator();
        String entryStr = null;
        Object resIDValue = null;
        DiscoEntryElement entry = null;
        ResourceIDType resID = null;
        ResourceOfferingType resOff = null;
        String entryID = null;
        Object providerID = null;
        while (j.hasNext()) {
            entryStr = (String)j.next();
            try {
                ResourceIDType rid;
                entry = (DiscoEntryElement)DiscoUtils.getDiscoUnmarshaller().unmarshal((Source)new StreamSource(new StringReader(entryStr)));
                resOff = entry.getResourceOffering();
                entryID = resOff.getEntryID();
                if (entryID == null) {
                    entryID = SAMLUtils.generateID();
                    resOff.setEntryID(entryID);
                }
                if ((rid = resOff.getResourceID()) == null || rid.getValue() == null || rid.getValue().equals("")) {
                    ObjectFactory discoFac = new ObjectFactory();
                    resID = discoFac.createResourceIDType();
                    resID.setValue("urn:liberty:isf:implied-resource");
                    resOff.setResourceID(resID);
                }
                entry.setResourceOffering(resOff);
                discoEntries.put(entryID, entry);
            }
            catch (Exception e) {
                debug.error("DiscoEntryHandlerImplUtils.getServiceDiscoEntries: Exception for getting entry: " + entryStr + ":", (Throwable)e);
            }
        }
    }

    public static boolean setGlobalDiscoEntries(AMIdentity amIdentity, String attrName, Collection entries) {
        try {
            Iterator i = entries.iterator();
            HashSet<String> xmlStrings = new HashSet<String>();
            Object entryId = null;
            StringWriter sw = null;
            while (i.hasNext()) {
                sw = new StringWriter(1000);
                DiscoUtils.getDiscoMarshaller().marshal((Object)((DiscoEntryElement)i.next()), (Writer)sw);
                xmlStrings.add(sw.getBuffer().toString());
            }
            HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
            map.put(attrName, xmlStrings);
            amIdentity.modifyService("sunIdentityServerDiscoveryService", map);
            amIdentity.store();
            return true;
        }
        catch (Exception e) {
            debug.error("DiscoEntryHandlerImplUtils.setServiceDiscoEntries: Exception", (Throwable)e);
            return false;
        }
    }
}

