/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.config.resource;

import com.sun.identity.config.pojos.UrlPattern;
import com.sun.identity.config.pojos.condition.ActiveSessionTimeCondition;
import com.sun.identity.config.pojos.condition.AuthenticationByModuleChainCondition;
import com.sun.identity.config.pojos.condition.AuthenticationByTypeCondition;
import com.sun.identity.config.pojos.condition.AuthenticationToRealmCondition;
import com.sun.identity.config.pojos.condition.Condition;
import com.sun.identity.config.pojos.condition.CurrentSessionPropertiesCondition;
import com.sun.identity.config.pojos.condition.DNSNameCondition;
import com.sun.identity.config.pojos.condition.IPAddressCondition;
import com.sun.identity.config.pojos.condition.IdentityMembershipCondition;
import com.sun.identity.config.pojos.condition.LDAPFilterCondition;
import com.sun.identity.config.pojos.condition.MaximumAuthenticationLevelCondition;
import com.sun.identity.config.pojos.condition.MinimumAuthenticationLevelCondition;
import com.sun.identity.config.pojos.condition.TimeCondition;
import com.sun.identity.config.util.AjaxPage;
import java.util.List;
import net.sf.click.control.ActionLink;

public class Protect
extends AjaxPage {
    public List urlPatterns;
    public ActionLink addUrlPatternLink = new ActionLink("addUrlPattern", (Object)this, "addUrlPattern");
    public ActionLink removeUrlPatternLink = new ActionLink("removeUrlPattern", (Object)this, "removeUrlPattern");
    public ActionLink addConditionLink = new ActionLink("addCondition", (Object)this, "addCondition");
    public ActionLink removeConditionLink = new ActionLink("removeCondition", (Object)this, "removeCondition");

    public boolean removeUrlPattern() {
        String[] patterns = this.toString("urlPattern").split(",");
        UrlPattern[] urlPatterns = new UrlPattern[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            UrlPattern urlPattern = new UrlPattern();
            urlPattern.setId(Integer.valueOf(patterns[i]));
            urlPatterns[i] = urlPattern;
        }
        this.getConfigurator().removeUrlPatterns(urlPatterns);
        return false;
    }

    public boolean addUrlPattern() {
        UrlPattern urlPattern = new UrlPattern();
        urlPattern.setPattern(this.toString("newUrlPattern"));
        this.getConfigurator().addUrlPattern(urlPattern);
        return false;
    }

    public boolean removeCondition() {
        String[] conds = this.toString("condition").split(",");
        Condition[] conditions = new Condition[conds.length];
        for (int i = 0; i < conds.length; ++i) {
            Condition condition = new Condition();
            condition.setId(Integer.valueOf(conds[i]));
            conditions[i] = condition;
        }
        this.getConfigurator().removeConditions(conditions);
        return false;
    }

    public boolean addCondition() {
        String[] conditionTypes = this.toString("conditionType").split(",");
        for (int i = 0; i < conditionTypes.length; ++i) {
            Condition condition = this.resolveCondition(conditionTypes[i]);
            if (condition == null) continue;
            this.getConfigurator().addCondition(condition);
        }
        return false;
    }

    private Condition resolveCondition(String conditionType) {
        Condition condition = null;
        if (conditionType.equals("authByModuleChain")) {
            condition = new AuthenticationByModuleChainCondition();
            condition.setName("Authentication By Module Chain");
        } else if (conditionType.equals("authByType")) {
            condition = new AuthenticationByTypeCondition();
            condition.setName("Authentication By Type");
        } else if (conditionType.equals("minAuthLevel")) {
            condition = new MinimumAuthenticationLevelCondition();
            condition.setName("Minimum Authentication Level");
        } else if (conditionType.equals("maxAuthLEvel")) {
            condition = new MaximumAuthenticationLevelCondition();
            condition.setName("Maximum Authentication Level");
        } else if (conditionType.equals("authToRealm")) {
            condition = new AuthenticationToRealmCondition();
            condition.setName("Authentication To Realm");
        } else if (conditionType.equals("currentSessionProperties")) {
            condition = new CurrentSessionPropertiesCondition();
            condition.setName("Current Session Properties");
        } else if (conditionType.equals("identityMembership")) {
            condition = new IdentityMembershipCondition();
            condition.setName("Identity Membership");
        } else if (conditionType.equals("ipAddress")) {
            condition = new IPAddressCondition();
            IPAddressCondition ipc = (IPAddressCondition)condition;
            ipc.setName(this.toString("name"));
            ipc.setIpAddressFrom(this.toString("fromIP1") + "." + this.toString("fromIP2") + "." + this.toString("fromIP3") + "." + this.toString("fromIP4"));
            ipc.setIpAddressTo(this.toString("toIP1") + "." + this.toString("toIP2") + "." + this.toString("toIP3") + "." + this.toString("toIP4"));
            ipc.setDnsName(this.toString("dnsName"));
            ipc.setDynamic("dynamic".equals(this.toString("parameterType")));
        } else if (conditionType.equals("ldapFilter")) {
            condition = new LDAPFilterCondition();
            condition.setName("LDAP Filter");
        } else if (conditionType.equals("time")) {
            condition = new TimeCondition();
            condition.setName("Time");
        } else if (conditionType.equals("dnsName")) {
            condition = new DNSNameCondition();
            condition.setName("DNS Name");
        } else if (conditionType.equals("activeSessionTime")) {
            condition = new ActiveSessionTimeCondition();
            condition.setName("Active Session Time");
        }
        return condition;
    }
}

