/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.ha.jmqdb.client;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class DataAccessor {
    HashMap<String, PrimaryIndex> primaryIndex = new HashMap();
    HashMap<String, SecondaryIndex> secIndex1 = new HashMap();
    HashMap<String, SecondaryIndex> secIndex2 = new HashMap();
    HashMap<String, Class> classes = new HashMap();

    public DataAccessor(EntityStore store, String initFile) throws DatabaseException, ClassNotFoundException, IOException {
        Properties prop = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(initFile);
        }
        catch (FileNotFoundException e) {
            System.out.println("prop file not found:" + initFile + "\n");
        }
        prop.load(fileInputStream);
        Enumeration<?> svcNames = prop.propertyNames();
        while (svcNames.hasMoreElements()) {
            String svcp = (String)svcNames.nextElement();
            if (!svcp.startsWith("persist_")) continue;
            String svcid = svcp.substring("persist_".length());
            String className = prop.getProperty(svcp);
            Class<?> cl = Class.forName(className);
            this.classes.put(svcid, cl);
            PrimaryIndex pIndex = store.getPrimaryIndex(String.class, cl);
            this.primaryIndex.put(svcid, pIndex);
            SecondaryIndex sIndex1 = store.getSecondaryIndex(pIndex, Long.class, "expDate");
            this.secIndex1.put(svcid, sIndex1);
            SecondaryIndex sIndex2 = store.getSecondaryIndex(pIndex, String.class, "secondaryKey");
            this.secIndex2.put(svcid, sIndex2);
        }
    }

    public PrimaryIndex getPrimaryIndex(String svcid) {
        return this.primaryIndex.get(svcid);
    }

    public SecondaryIndex getSecondaryIndex1(String svcid) {
        return this.secIndex1.get(svcid);
    }

    public SecondaryIndex getSecondaryIndex2(String svcid) {
        return this.secIndex2.get(svcid);
    }

    public Class getSvcClass(String svcid) {
        return this.classes.get(svcid);
    }
}

